/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.runner.eze;

import io.camunda.zeebe.client.ZeebeClient;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import org.camunda.community.eze.EngineFactory;
import org.camunda.community.eze.ZeebeEngine;
import org.camunda.community.zeebe.spec.api.SpecTestRunnerContext;
import org.camunda.community.zeebe.spec.runner.SpecActionExecutor;
import org.camunda.community.zeebe.spec.runner.SpecStateProvider;
import org.camunda.community.zeebe.spec.runner.TestRunnerEnvironment;
import org.camunda.community.zeebe.spec.runner.eze.EzeSpecStateProvider;
import org.camunda.community.zeebe.spec.runner.zeebe.ZeebeSpecActionExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/camunda/community/zeebe/spec/runner/eze/EzeEnvironment;", "Lorg/camunda/community/zeebe/spec/runner/TestRunnerEnvironment;", "zeebeEngine", "Lorg/camunda/community/eze/ZeebeEngine;", "(Lorg/camunda/community/eze/ZeebeEngine;)V", "actionExecutor", "Lorg/camunda/community/zeebe/spec/runner/SpecActionExecutor;", "getActionExecutor", "()Lorg/camunda/community/zeebe/spec/runner/SpecActionExecutor;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "stateProvider", "Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "getStateProvider", "()Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "close", "", "create", "getContext", "Lorg/camunda/community/zeebe/spec/api/SpecTestRunnerContext;", "EzeContext", "zeebe-spec-core"})
public final class EzeEnvironment
implements TestRunnerEnvironment {
    @NotNull
    private final ZeebeEngine zeebeEngine;
    private final Logger logger;
    @NotNull
    private final SpecActionExecutor actionExecutor;
    @NotNull
    private final SpecStateProvider stateProvider;

    public EzeEnvironment(@NotNull ZeebeEngine zeebeEngine) {
        Intrinsics.checkNotNullParameter((Object)zeebeEngine, (String)"zeebeEngine");
        this.zeebeEngine = zeebeEngine;
        this.logger = LoggerFactory.getLogger(EzeEnvironment.class);
        this.actionExecutor = new ZeebeSpecActionExecutor((Function0<? extends ZeebeClient>)((Function0)new Function0<ZeebeClient>((Object)this.zeebeEngine){

            @NotNull
            public final ZeebeClient invoke() {
                return ((ZeebeEngine)this.receiver).createClient();
            }
        }));
        this.stateProvider = new EzeSpecStateProvider((Function0<? extends ZeebeEngine>)((Function0)new PropertyReference0Impl(this){

            @Nullable
            public Object get() {
                return EzeEnvironment.access$getZeebeEngine$p((EzeEnvironment)this.receiver);
            }
        }));
    }

    public /* synthetic */ EzeEnvironment(ZeebeEngine zeebeEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            zeebeEngine = EngineFactory.create$default((EngineFactory)EngineFactory.INSTANCE, null, (int)1, null);
        }
        this(zeebeEngine);
    }

    @Override
    @NotNull
    public SpecActionExecutor getActionExecutor() {
        return this.actionExecutor;
    }

    @Override
    @NotNull
    public SpecStateProvider getStateProvider() {
        return this.stateProvider;
    }

    @Override
    public void create() {
        this.logger.debug("Start EZE engine");
        try {
            this.zeebeEngine.start();
        }
        catch (Exception e) {
            this.zeebeEngine.stop();
            this.logger.error("Failed to start the EZE engine", (Throwable)e);
            throw new RuntimeException("Failed to start the EZE engine", e);
        }
    }

    @Override
    @NotNull
    public SpecTestRunnerContext getContext() {
        return new EzeContext(this.zeebeEngine.createClient());
    }

    @Override
    public void close() {
        this.logger.debug("Close EZE engine");
        this.getActionExecutor().close();
        this.getStateProvider().close();
        this.zeebeEngine.stop();
    }

    public EzeEnvironment() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ZeebeEngine access$getZeebeEngine$p(EzeEnvironment $this) {
        return $this.zeebeEngine;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/eze/EzeEnvironment$EzeContext;", "Lorg/camunda/community/zeebe/spec/api/SpecTestRunnerContext;", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "(Lio/camunda/zeebe/client/ZeebeClient;)V", "component1", "copy", "equals", "", "other", "", "getZeebeClient", "hashCode", "", "toString", "", "zeebe-spec-core"})
    private static final class EzeContext
    implements SpecTestRunnerContext {
        @NotNull
        private final ZeebeClient zeebeClient;

        public EzeContext(@NotNull ZeebeClient zeebeClient) {
            Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
            this.zeebeClient = zeebeClient;
        }

        @Override
        @NotNull
        public ZeebeClient getZeebeClient() {
            return this.zeebeClient;
        }

        private final ZeebeClient component1() {
            return this.zeebeClient;
        }

        @NotNull
        public final EzeContext copy(@NotNull ZeebeClient zeebeClient) {
            Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
            return new EzeContext(zeebeClient);
        }

        public static /* synthetic */ EzeContext copy$default(EzeContext ezeContext, ZeebeClient zeebeClient, int n, Object object) {
            if ((n & 1) != 0) {
                zeebeClient = ezeContext.zeebeClient;
            }
            return ezeContext.copy(zeebeClient);
        }

        @NotNull
        public String toString() {
            return "EzeContext(zeebeClient=" + this.zeebeClient + ")";
        }

        public int hashCode() {
            return this.zeebeClient.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EzeContext)) {
                return false;
            }
            EzeContext ezeContext = (EzeContext)other;
            return Intrinsics.areEqual((Object)this.zeebeClient, (Object)ezeContext.zeebeClient);
        }
    }
}

