/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.runner.zeebe;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobWorker;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.runner.SpecActionExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u001c\u0010\u0017\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010 \u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeebe/ZeebeSpecActionExecutor;", "Lorg/camunda/community/zeebe/spec/runner/SpecActionExecutor;", "zeebeClientProvider", "Lkotlin/Function0;", "Lio/camunda/zeebe/client/ZeebeClient;", "(Lkotlin/jvm/functions/Function0;)V", "jobWorkers", "", "Lio/camunda/zeebe/client/api/worker/JobWorker;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "zeebeClient", "cancelProcessInstance", "", "processInstanceKey", "", "Lorg/camunda/community/zeebe/spec/ProcessInstanceKey;", "close", "completeTask", "jobType", "", "variables", "createProcessInstance", "bpmnProcessId", "deployProcess", "name", "bpmnXml", "Ljava/io/InputStream;", "publishMessage", "messageName", "correlationKey", "throwError", "errorCode", "errorMessage", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nZeebeSpecActionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZeebeSpecActionExecutor.kt\norg/camunda/community/zeebe/spec/runner/zeebe/ZeebeSpecActionExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1549#2:131\n1620#2,3:132\n*S KotlinDebug\n*F\n+ 1 ZeebeSpecActionExecutor.kt\norg/camunda/community/zeebe/spec/runner/zeebe/ZeebeSpecActionExecutor\n*L\n24#1:131\n24#1:132,3\n*E\n"})
public final class ZeebeSpecActionExecutor
implements SpecActionExecutor {
    private final Logger logger;
    @NotNull
    private final List<JobWorker> jobWorkers;
    @NotNull
    private final ZeebeClient zeebeClient;

    public ZeebeSpecActionExecutor(@NotNull Function0<? extends ZeebeClient> zeebeClientProvider) {
        Intrinsics.checkNotNullParameter(zeebeClientProvider, (String)"zeebeClientProvider");
        this.logger = LoggerFactory.getLogger(ZeebeSpecActionExecutor.class);
        this.jobWorkers = new ArrayList();
        this.zeebeClient = (ZeebeClient)zeebeClientProvider.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$mapTo$iv$iv;
        this.logger.debug("Close job workers.");
        Iterable $this$map$iv = this.jobWorkers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JobWorker jobWorker = (JobWorker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            p0.close();
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    public void deployProcess(@NotNull String name, @NotNull InputStream bpmnXml) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bpmnXml, (String)"bpmnXml");
        this.logger.debug("Deploy BPMN process. [name: {}]", (Object)name);
        this.zeebeClient.newDeployResourceCommand().addResourceStream(bpmnXml, name).send().join();
    }

    @Override
    public long createProcessInstance(@NotNull String bpmnProcessId, @NotNull String variables) {
        Intrinsics.checkNotNullParameter((Object)bpmnProcessId, (String)"bpmnProcessId");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        this.logger.debug("Creating a process instance. [BPMN-process-id: {}, variables: {}]", (Object)bpmnProcessId, (Object)variables);
        ProcessInstanceEvent response = (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion().variables(variables).send().join();
        return response.getProcessInstanceKey();
    }

    @Override
    public void completeTask(@NotNull String jobType, @NotNull String variables) {
        Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        this.logger.debug("Start job worker to complete jobs. [job-type: {}, variables: {}]", (Object)jobType, (Object)variables);
        JobWorker jobWorker = this.zeebeClient.newWorker().jobType(jobType).handler((arg_0, arg_1) -> ZeebeSpecActionExecutor.completeTask$lambda$0(variables, arg_0, arg_1)).timeout(Duration.ofSeconds(1L)).open();
        Intrinsics.checkNotNullExpressionValue((Object)jobWorker, (String)"jobWorker");
        this.jobWorkers.add(jobWorker);
    }

    @Override
    public void publishMessage(@NotNull String messageName, @NotNull String correlationKey, @NotNull String variables) {
        Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
        Intrinsics.checkNotNullParameter((Object)correlationKey, (String)"correlationKey");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Object[] objectArray = new Object[]{messageName, correlationKey, variables};
        this.logger.debug("Publish message. [name: {}, correlation-key: {}, variables: {}]", objectArray);
        this.zeebeClient.newPublishMessageCommand().messageName(messageName).correlationKey(correlationKey).variables(variables).timeToLive(Duration.ofSeconds(10L)).send().join();
    }

    @Override
    public void throwError(@NotNull String jobType, @NotNull String errorCode, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Object[] objectArray = new Object[]{jobType, errorCode, errorMessage};
        this.logger.debug("Start job worker to throw errors. [job-type: {}, error-code: {}, error-message: {}]", objectArray);
        JobWorker jobWorker = this.zeebeClient.newWorker().jobType(jobType).handler((arg_0, arg_1) -> ZeebeSpecActionExecutor.throwError$lambda$1(errorCode, errorMessage, arg_0, arg_1)).timeout(Duration.ofSeconds(1L)).open();
        Intrinsics.checkNotNullExpressionValue((Object)jobWorker, (String)"jobWorker");
        this.jobWorkers.add(jobWorker);
    }

    @Override
    public void cancelProcessInstance(long processInstanceKey) {
        this.logger.debug("Cancel process instance. [key: {}]", (Object)processInstanceKey);
        this.zeebeClient.newCancelInstanceCommand(processInstanceKey).send().join();
    }

    private static final void completeTask$lambda$0(String $variables, JobClient jobClient, ActivatedJob job) {
        Intrinsics.checkNotNullParameter((Object)$variables, (String)"$variables");
        jobClient.newCompleteCommand(job.getKey()).variables($variables).send().join();
    }

    private static final void throwError$lambda$1(String $errorCode, String $errorMessage, JobClient jobClient, ActivatedJob job) {
        Intrinsics.checkNotNullParameter((Object)$errorCode, (String)"$errorCode");
        Intrinsics.checkNotNullParameter((Object)$errorMessage, (String)"$errorMessage");
        jobClient.newThrowErrorCommand(job.getKey()).errorCode($errorCode).errorMessage($errorMessage).send().join();
    }
}

