/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.runner.zeeqs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.api.dto.ElementInstance;
import org.camunda.community.zeebe.spec.api.dto.ElementInstanceState;
import org.camunda.community.zeebe.spec.api.dto.Incident;
import org.camunda.community.zeebe.spec.api.dto.IncidentState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceVariable;
import org.camunda.community.zeebe.spec.runner.SpecStateProvider;
import org.camunda.community.zeebe.spec.runner.zeeqs.ZeeqsClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\nH\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsSpecStateProvider;", "Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "zeeqsClientProvider", "Lkotlin/Function0;", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient;", "(Lkotlin/jvm/functions/Function0;)V", "zeeqsClient", "close", "", "getElementInstances", "", "Lorg/camunda/community/zeebe/spec/api/dto/ElementInstance;", "processInstanceKey", "", "Lorg/camunda/community/zeebe/spec/ProcessInstanceKey;", "getIncidents", "Lorg/camunda/community/zeebe/spec/api/dto/Incident;", "getProcessInstanceKeys", "getProcessInstanceState", "Lorg/camunda/community/zeebe/spec/api/dto/ProcessInstanceState;", "getProcessInstanceVariables", "Lorg/camunda/community/zeebe/spec/api/dto/ProcessInstanceVariable;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nZeeqsSpecStateProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZeeqsSpecStateProvider.kt\norg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsSpecStateProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n*S KotlinDebug\n*F\n+ 1 ZeeqsSpecStateProvider.kt\norg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsSpecStateProvider\n*L\n29#1:76\n29#1:77,3\n46#1:80\n46#1:81,3\n58#1:84\n58#1:85,3\n*E\n"})
public final class ZeeqsSpecStateProvider
implements SpecStateProvider {
    @NotNull
    private final ZeeqsClient zeeqsClient;

    public ZeeqsSpecStateProvider(@NotNull Function0<ZeeqsClient> zeeqsClientProvider) {
        Intrinsics.checkNotNullParameter(zeeqsClientProvider, (String)"zeeqsClientProvider");
        this.zeeqsClient = (ZeeqsClient)zeeqsClientProvider.invoke();
    }

    @Override
    @NotNull
    public List<Long> getProcessInstanceKeys() {
        return this.zeeqsClient.getProcessInstanceKeys();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ProcessInstanceState getProcessInstanceState(long processInstanceKey) {
        ProcessInstanceState processInstanceState;
        String state = this.zeeqsClient.getProcessInstanceState(processInstanceKey);
        String string = state;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1383663147: {
                    if (!string.equals("COMPLETED")) break;
                    n = 1;
                    break;
                }
                case -823723485: {
                    if (!string.equals("TERMINATED")) break;
                    n = 2;
                    break;
                }
                case -1303979599: {
                    if (!string.equals("ACTIVATED")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    processInstanceState = ProcessInstanceState.COMPLETED;
                    return processInstanceState;
                }
                case 2: {
                    processInstanceState = ProcessInstanceState.TERMINATED;
                    return processInstanceState;
                }
                case 3: {
                    processInstanceState = ProcessInstanceState.ACTIVATED;
                    return processInstanceState;
                }
            }
        }
        processInstanceState = ProcessInstanceState.UNKNOWN;
        return processInstanceState;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ElementInstance> getElementInstances(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.zeeqsClient.getElementInstances(processInstanceKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ElementInstanceState elementInstanceState;
            void it;
            ZeeqsClient.ElementInstanceDto elementInstanceDto = (ZeeqsClient.ElementInstanceDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getElementId();
            String string2 = it.getElementName();
            switch (it.getState()) {
                case "ACTIVATED": {
                    elementInstanceState = ElementInstanceState.ACTIVATED;
                    break;
                }
                case "COMPLETED": {
                    elementInstanceState = ElementInstanceState.COMPLETED;
                    break;
                }
                case "TERMINATED": {
                    elementInstanceState = ElementInstanceState.TERMINATED;
                    break;
                }
                case "TAKEN": {
                    elementInstanceState = ElementInstanceState.TAKEN;
                    break;
                }
                default: {
                    elementInstanceState = ElementInstanceState.UNKNOWN;
                }
            }
            collection.add(new ElementInstance(string, string2, elementInstanceState));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProcessInstanceVariable> getProcessInstanceVariables(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.zeeqsClient.getProcessInstanceVariables(processInstanceKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            ZeeqsClient.VariableDto variableDto = (ZeeqsClient.VariableDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = it.getValue();
            Object object2 = it.getScope();
            if (object2 == null || (object2 = ((ZeeqsClient.VariableScopeDto)object2).getElementId()) == null) {
                object2 = "";
            }
            if ((object = it.getScope()) == null || (object = ((ZeeqsClient.VariableScopeDto)object).getElementName()) == null) {
                object = "";
            }
            collection.add(new ProcessInstanceVariable(string, string2, (String)object2, (String)object));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Incident> getIncidents(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.zeeqsClient.getIncidents(processInstanceKey);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            IncidentState incidentState;
            void it;
            ZeeqsClient.IncidentDto incidentDto = (ZeeqsClient.IncidentDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getErrorType();
            String string2 = it.getErrorMessage();
            Object object2 = it.getState();
            IncidentState incidentState2 = incidentState = Intrinsics.areEqual((Object)object2, (Object)"CREATED") ? IncidentState.CREATED : (Intrinsics.areEqual((Object)object2, (Object)"RESOLVED") ? IncidentState.RESOLVED : IncidentState.UNKNOWN);
            Object object3 = it.getElementInstance();
            if (object3 == null || (object3 = ((ZeeqsClient.IncidentElementInstanceDto)object3).getElementId()) == null) {
                object3 = object2 = "";
            }
            if ((object = it.getElementInstance()) == null || (object = ((ZeeqsClient.IncidentElementInstanceDto)object).getElementName()) == null) {
                object = "";
            }
            Object object4 = object;
            collection.add(new Incident(string, string2, (String)object2, (String)object4, incidentState));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void close() {
    }
}

