/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.camunda.community.zeebe.spec.ResourceResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/camunda/community/zeebe/spec/ClasspathResourceResolver;", "Lorg/camunda/community/zeebe/spec/ResourceResolver;", "classLoader", "Ljava/lang/ClassLoader;", "rootDirectory", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "deploymentFilter", "Ljava/io/FilenameFilter;", "getResources", "", "Ljava/io/File;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nClasspathResourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathResourceResolver.kt\norg/camunda/community/zeebe/spec/ClasspathResourceResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class ClasspathResourceResolver
implements ResourceResolver {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final String rootDirectory;

    public ClasspathResourceResolver(@NotNull ClassLoader classLoader, @NotNull String rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.classLoader = classLoader;
        this.rootDirectory = rootDirectory;
    }

    public /* synthetic */ ClasspathResourceResolver(ClassLoader classLoader, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(classLoader, string);
    }

    @Override
    @NotNull
    public List<File> getResources() {
        Iterable<Path> iterable;
        block4: {
            block3: {
                Path path;
                URL uRL = this.classLoader.getResource(this.rootDirectory);
                if (uRL == null) break block3;
                URL it = uRL;
                boolean bl = false;
                Path path2 = Path.of(it.toURI());
                if (path2 == null) break block3;
                Path it2 = iterable = path2;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                Path path3 = path = Files.isDirectory(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? iterable : null;
                if (path == null) break block3;
                Path dir = path;
                boolean bl3 = false;
                Object[] objectArray = dir.toFile().listFiles(this.deploymentFilter());
                iterable = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                if (iterable != null) break block4;
            }
            throw new RuntimeException("No resource directory found with name '" + this.rootDirectory + "'");
        }
        return iterable;
    }

    private final FilenameFilter deploymentFilter() {
        return ClasspathResourceResolver::deploymentFilter$lambda$3;
    }

    private static final boolean deploymentFilter$lambda$3(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".bpmn", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".dmn", (boolean)false, (int)2, null);
    }
}

