/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.camunda.community.zeebe.spec.ResourceResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/camunda/community/zeebe/spec/DirectoryResourceResolver;", "Lorg/camunda/community/zeebe/spec/ResourceResolver;", "rootDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "deploymentFilter", "Ljava/io/FilenameFilter;", "getResources", "", "Ljava/io/File;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nDirectoryResourceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryResourceResolver.kt\norg/camunda/community/zeebe/spec/DirectoryResourceResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class DirectoryResourceResolver
implements ResourceResolver {
    @NotNull
    private final Path rootDirectory;

    public DirectoryResourceResolver(@NotNull Path rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
    }

    @Override
    @NotNull
    public List<File> getResources() {
        Iterable<Path> iterable;
        block4: {
            block3: {
                Path path;
                Path it = iterable = this.rootDirectory;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                Path path2 = path = Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? iterable : null;
                if (path == null) break block3;
                Path dir = path;
                boolean bl2 = false;
                Object[] objectArray = dir.toFile().listFiles(this.deploymentFilter());
                iterable = objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                if (iterable != null) break block4;
            }
            throw new RuntimeException("No resource directory found with name '" + PathsKt.getName((Path)this.rootDirectory) + "'");
        }
        return iterable;
    }

    private final FilenameFilter deploymentFilter() {
        return DirectoryResourceResolver::deploymentFilter$lambda$2;
    }

    private static final boolean deploymentFilter$lambda$2(File file, String name) {
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.endsWith$default((String)name, (String)".bpmn", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".dmn", (boolean)false, (int)2, null);
    }
}

