/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.format;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.actions.AwaitElementInstanceStateAction;
import org.camunda.community.zeebe.spec.actions.CancelInstanceAction;
import org.camunda.community.zeebe.spec.actions.CompleteTaskAction;
import org.camunda.community.zeebe.spec.actions.CreateInstanceAction;
import org.camunda.community.zeebe.spec.actions.PublishMessageAction;
import org.camunda.community.zeebe.spec.actions.ThrowErrorAction;
import org.camunda.community.zeebe.spec.api.dto.ElementInstanceState;
import org.camunda.community.zeebe.spec.api.dto.IncidentState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceState;
import org.camunda.community.zeebe.spec.format.Action;
import org.camunda.community.zeebe.spec.format.Instruction;
import org.camunda.community.zeebe.spec.format.TestCase;
import org.camunda.community.zeebe.spec.format.TestSpec;
import org.camunda.community.zeebe.spec.format.Verification;
import org.camunda.community.zeebe.spec.verifications.ElementInstanceStateVerification;
import org.camunda.community.zeebe.spec.verifications.IncidentStateVerification;
import org.camunda.community.zeebe.spec.verifications.NoProcessInstanceVariableVerification;
import org.camunda.community.zeebe.spec.verifications.ProcessInstanceStateVerification;
import org.camunda.community.zeebe.spec.verifications.ProcessInstanceVariableVerification;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/camunda/community/zeebe/spec/format/SpecDeserializer;", "", "()V", "kotlinModule", "Lcom/fasterxml/jackson/module/kotlin/KotlinModule;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "readSpec", "Lorg/camunda/community/zeebe/spec/api/TestSpec;", "input", "Ljava/io/InputStream;", "transformAction", "Lorg/camunda/community/zeebe/spec/api/Action;", "action", "Lorg/camunda/community/zeebe/spec/format/Action;", "transformInstruction", "Lorg/camunda/community/zeebe/spec/api/Instruction;", "instruction", "Lorg/camunda/community/zeebe/spec/format/Instruction;", "transformTestCase", "Lorg/camunda/community/zeebe/spec/api/TestCase;", "testCase", "Lorg/camunda/community/zeebe/spec/format/TestCase;", "transformVerification", "Lorg/camunda/community/zeebe/spec/api/Verification;", "verification", "Lorg/camunda/community/zeebe/spec/format/Verification;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nSpecDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecDeserializer.kt\norg/camunda/community/zeebe/spec/format/SpecDeserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n52#2:155\n43#2:156\n1549#3:157\n1620#3,3:158\n1549#3:161\n1620#3,3:162\n1549#3:165\n1620#3,3:166\n1549#3:169\n1620#3,3:170\n1#4:173\n*S KotlinDebug\n*F\n+ 1 SpecDeserializer.kt\norg/camunda/community/zeebe/spec/format/SpecDeserializer\n*L\n21#1:155\n21#1:156\n24#1:157\n24#1:158,3\n30#1:161\n30#1:162,3\n33#1:165\n33#1:166,3\n34#1:169\n34#1:170,3\n*E\n"})
public final class SpecDeserializer {
    @NotNull
    private final KotlinModule kotlinModule = new KotlinModule.Builder().build();
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)this.kotlinModule);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.camunda.community.zeebe.spec.api.TestSpec readSpec(@NotNull InputStream input) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        TestSpec spec = (TestSpec)$this$readValue$iv.readValue(input, (TypeReference)new TypeReference<TestSpec>(){});
        Iterable $this$map$iv = spec.getTestCases();
        boolean $i$f$map = false;
        Iterable $i$f$jacksonTypeRef22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TestCase testCase = (TestCase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.transformTestCase((TestCase)p0));
        }
        List list = (List)destination$iv$iv;
        return new org.camunda.community.zeebe.spec.api.TestSpec(list);
    }

    /*
     * WARNING - void declaration
     */
    private final org.camunda.community.zeebe.spec.api.TestCase transformTestCase(TestCase testCase) {
        List list;
        Iterable it;
        List<Instruction> list2 = testCase.getInstructions();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Instruction instruction = (Instruction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.transformInstruction((Instruction)((Object)it)));
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable iterable;
            Iterable iterable2;
            Verification it2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            TestCase it3 = testCase;
            boolean bl = false;
            List instructions = new ArrayList();
            Collection collection2 = instructions;
            List<Action> list3 = it3.getActions();
            if (list3 != null) {
                $this$map$iv = list3;
                $i$f$map = false;
                it = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Action action = (Action)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.transformAction((Action)((Object)it2)));
                }
                iterable2 = (List)destination$iv$iv;
            } else {
                iterable2 = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
            collection2 = instructions;
            List<Verification> list4 = it3.getVerifications();
            if (list4 != null) {
                $this$map$iv = list4;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (Verification)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.transformVerification(it2));
                }
                iterable = (List)destination$iv$iv;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
            list = instructions;
        }
        List instructions = list;
        String string = testCase.getName();
        String string2 = testCase.getDescription();
        if (string2 == null) {
            string2 = "";
        }
        return new org.camunda.community.zeebe.spec.api.TestCase(string, string2, instructions);
    }

    private final org.camunda.community.zeebe.spec.api.Instruction transformInstruction(Instruction instruction) {
        org.camunda.community.zeebe.spec.api.Instruction instruction2;
        switch (WhenMappings.$EnumSwitchMapping$0[instruction.type().ordinal()]) {
            case 1: {
                instruction2 = this.transformAction(instruction.toAction());
                break;
            }
            case 2: {
                instruction2 = this.transformVerification(instruction.toVerification());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return instruction2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final org.camunda.community.zeebe.spec.api.Action transformAction(Action action) {
        String string = action.getAction().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        Map map = action.getArgs();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map args = map;
        switch (name) {
            case "create-instance": {
                String string2 = (String)args.get("bpmn_process_id");
                if (string2 == null) {
                    throw new RuntimeException("Missing required parameter 'bpmn_process_id' for action 'create-instance'");
                }
                String string3 = (String)args.get("variables");
                if (string3 == null) {
                    string3 = "{}";
                }
                org.camunda.community.zeebe.spec.api.Action action2 = new CreateInstanceAction(string2, string3, (String)args.get("process_instance_alias"));
                return action2;
            }
            case "complete-task": {
                String string4 = (String)args.get("job_type");
                if (string4 == null) {
                    throw new RuntimeException("Missing required parameter 'job_type' for action 'complete-task'");
                }
                String string5 = (String)args.get("variables");
                if (string5 == null) {
                    string5 = "{}";
                }
                org.camunda.community.zeebe.spec.api.Action action2 = new CompleteTaskAction(string4, string5);
                return action2;
            }
            case "publish-message": {
                String string6 = (String)args.get("message_name");
                if (string6 == null) {
                    throw new RuntimeException("Missing required parameter 'message_name' for action 'publish-message'");
                }
                String string7 = (String)args.get("correlation_key");
                if (string7 == null) {
                    throw new RuntimeException("Missing required parameter 'correlation_key' for action 'publish-message'");
                }
                String string8 = (String)args.get("variables");
                if (string8 == null) {
                    string8 = "{}";
                }
                org.camunda.community.zeebe.spec.api.Action action2 = new PublishMessageAction(string6, string7, string8);
                return action2;
            }
            case "throw-error": {
                String string9 = (String)args.get("job_type");
                if (string9 == null) {
                    throw new RuntimeException("Missing required parameter 'job_type' for action 'throw-error'");
                }
                String string10 = (String)args.get("error_code");
                if (string10 == null) {
                    throw new RuntimeException("Missing required parameter 'error_code' for action 'throw-error'");
                }
                String string11 = (String)args.get("error_message");
                if (string11 == null) {
                    string11 = "";
                }
                org.camunda.community.zeebe.spec.api.Action action2 = new ThrowErrorAction(string9, string10, string11);
                return action2;
            }
            case "cancel-instance": {
                org.camunda.community.zeebe.spec.api.Action action2 = new CancelInstanceAction((String)args.get("process_instance"));
                return action2;
            }
            case "await-element-instance-state": {
                Object object = (String)args.get("state");
                if (object == null) throw new RuntimeException("Missing required parameter 'state' for action 'await-element-instance-state'");
                String it = object;
                boolean bl = false;
                String string12 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toUpperCase(...)");
                ElementInstanceState elementInstanceState = ElementInstanceState.valueOf(string12);
                object = elementInstanceState;
                if (elementInstanceState == null) {
                    throw new RuntimeException("Missing required parameter 'state' for action 'await-element-instance-state'");
                }
                String string13 = (String)args.get("process_instance");
                String string14 = (String)args.get("element_name");
                String string15 = (String)args.get("element_id");
                Object object2 = object;
                org.camunda.community.zeebe.spec.api.Action action2 = new AwaitElementInstanceStateAction((ElementInstanceState)((Object)object2), string15, string14, string13);
                return action2;
            }
            default: {
                throw new RuntimeException("Unknown action '" + name + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final org.camunda.community.zeebe.spec.api.Verification transformVerification(Verification verification) {
        String string = verification.getVerification().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        Map map = verification.getArgs();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map args = map;
        switch (name) {
            case "process-instance-state": {
                Object object = (String)args.get("state");
                if (object == null) throw new RuntimeException("Missing required parameter 'state' for verification 'process-instance-state'");
                String it = object;
                boolean bl = false;
                String string2 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                ProcessInstanceState processInstanceState = ProcessInstanceState.valueOf(string2);
                object = processInstanceState;
                if (processInstanceState == null) {
                    throw new RuntimeException("Missing required parameter 'state' for verification 'process-instance-state'");
                }
                String string3 = (String)args.get("process_instance");
                Object object2 = object;
                org.camunda.community.zeebe.spec.api.Verification verification2 = new ProcessInstanceStateVerification((ProcessInstanceState)((Object)object2), string3);
                return verification2;
            }
            case "element-instance-state": {
                Object object = (String)args.get("state");
                if (object == null) throw new RuntimeException("Missing required parameter 'state' for verification 'element-instance-state'");
                String it = object;
                boolean bl = false;
                String string4 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                ElementInstanceState elementInstanceState = ElementInstanceState.valueOf(string4);
                object = elementInstanceState;
                if (elementInstanceState == null) {
                    throw new RuntimeException("Missing required parameter 'state' for verification 'element-instance-state'");
                }
                String string5 = (String)args.get("process_instance");
                String string6 = (String)args.get("element_name");
                String string7 = (String)args.get("element_id");
                Object object3 = object;
                org.camunda.community.zeebe.spec.api.Verification verification2 = new ElementInstanceStateVerification((ElementInstanceState)((Object)object3), string7, string6, string5);
                return verification2;
            }
            case "process-instance-variable": {
                String string8 = (String)args.get("name");
                if (string8 == null) {
                    throw new RuntimeException("Missing required parameter 'name' for verification 'process-instance-variable'");
                }
                String string9 = string8;
                String string10 = (String)args.get("value");
                if (string10 == null) {
                    throw new RuntimeException("Missing required parameter 'value' for verification 'process-instance-variable'");
                }
                String string11 = string10;
                String string12 = (String)args.get("element_id");
                String it = (String)args.get("element_name");
                String bl = (String)args.get("process_instance");
                org.camunda.community.zeebe.spec.api.Verification verification2 = new ProcessInstanceVariableVerification(string9, string11, bl, string12, it);
                return verification2;
            }
            case "no-process-instance-variable": {
                String string13 = (String)args.get("name");
                if (string13 == null) {
                    throw new RuntimeException("Missing required parameter 'name' for verification 'no-process-instance-variable'");
                }
                String string14 = string13;
                String string15 = (String)args.get("element_id");
                String string16 = (String)args.get("element_name");
                String it = (String)args.get("process_instance");
                org.camunda.community.zeebe.spec.api.Verification verification2 = new NoProcessInstanceVariableVerification(string14, it, string15, string16);
                return verification2;
            }
            case "incident-state": {
                Object object = (String)args.get("state");
                if (object == null) throw new RuntimeException("Missing required parameter 'state' for verification 'incident-state'");
                String it = object;
                boolean bl = false;
                String string17 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toUpperCase(...)");
                IncidentState incidentState = IncidentState.valueOf(string17);
                object = incidentState;
                if (incidentState == null) {
                    throw new RuntimeException("Missing required parameter 'state' for verification 'incident-state'");
                }
                String string18 = (String)args.get("error_type");
                if (string18 == null) {
                    throw new RuntimeException("Missing required parameter 'errorType' for verification 'incident-state'");
                }
                String string19 = (String)args.get("process_instance");
                String string20 = (String)args.get("element_name");
                String string21 = (String)args.get("element_id");
                String string22 = (String)args.get("error_message");
                String string23 = string18;
                Object object4 = object;
                org.camunda.community.zeebe.spec.api.Verification verification2 = new IncidentStateVerification((IncidentState)((Object)object4), string23, string22, string21, string20, string19);
                return verification2;
            }
            default: {
                throw new RuntimeException("Unknown verification: '" + name + "'");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Instruction.InstructionType.values().length];
            try {
                nArray[Instruction.InstructionType.ACTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.InstructionType.VERIFICATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

