/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.runner.eze;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.eze.RecordStream;
import org.camunda.community.eze.ZeebeEngine;
import org.camunda.community.zeebe.spec.api.dto.ElementInstance;
import org.camunda.community.zeebe.spec.api.dto.ElementInstanceState;
import org.camunda.community.zeebe.spec.api.dto.Incident;
import org.camunda.community.zeebe.spec.api.dto.IncidentState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceVariable;
import org.camunda.community.zeebe.spec.runner.SpecStateProvider;
import org.camunda.community.zeebe.spec.runner.eze.EzeSpecStateProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0016J\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00132\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0016J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000fH\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0016J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/camunda/community/zeebe/spec/runner/eze/EzeSpecStateProvider;", "Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "zeebeEngineProvider", "Lkotlin/Function0;", "Lorg/camunda/community/eze/ZeebeEngine;", "(Lkotlin/jvm/functions/Function0;)V", "zeebeEngine", "close", "", "getElementId", "", "elementInstanceKey", "", "Lorg/camunda/community/zeebe/spec/ProcessInstanceKey;", "getElementInstances", "", "Lorg/camunda/community/zeebe/spec/api/dto/ElementInstance;", "processInstanceKey", "getElementNameLookup", "Lkotlin/Function1;", "getIncidents", "Lorg/camunda/community/zeebe/spec/api/dto/Incident;", "getProcessInstanceKeys", "getProcessInstanceState", "Lorg/camunda/community/zeebe/spec/api/dto/ProcessInstanceState;", "getProcessInstanceVariables", "Lorg/camunda/community/zeebe/spec/api/dto/ProcessInstanceVariable;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nEzeSpecStateProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EzeSpecStateProvider.kt\norg/camunda/community/zeebe/spec/runner/eze/EzeSpecStateProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,173:1\n1549#2:174\n1620#2,3:175\n1549#2:178\n1620#2,3:179\n1477#2:182\n1502#2,3:183\n1505#2,3:193\n1477#2:200\n1502#2,3:201\n1505#2,3:211\n1477#2:218\n1502#2,3:219\n1505#2,3:229\n372#3,7:186\n372#3,7:204\n372#3,7:222\n125#4:196\n152#4,3:197\n125#4:214\n152#4,3:215\n125#4:232\n152#4,3:233\n*S KotlinDebug\n*F\n+ 1 EzeSpecStateProvider.kt\norg/camunda/community/zeebe/spec/runner/eze/EzeSpecStateProvider\n*L\n28#1:174\n28#1:175,3\n37#1:178\n37#1:179,3\n56#1:182\n56#1:183,3\n56#1:193,3\n83#1:200\n83#1:201,3\n83#1:211,3\n107#1:218\n107#1:219,3\n107#1:229,3\n56#1:186,7\n83#1:204,7\n107#1:222,7\n57#1:196\n57#1:197,3\n84#1:214\n84#1:215,3\n108#1:232\n108#1:233,3\n*E\n"})
public final class EzeSpecStateProvider
implements SpecStateProvider {
    @NotNull
    private final ZeebeEngine zeebeEngine;

    public EzeSpecStateProvider(@NotNull Function0<? extends ZeebeEngine> zeebeEngineProvider) {
        Intrinsics.checkNotNullParameter(zeebeEngineProvider, (String)"zeebeEngineProvider");
        this.zeebeEngine = (ZeebeEngine)zeebeEngineProvider.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Long> getProcessInstanceKeys() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = RecordStream.INSTANCE.withElementType((Iterable)this.zeebeEngine.processInstanceRecords(), BpmnElementType.PROCESS);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ProcessInstanceRecordValue)it.getValue()).getProcessInstanceKey());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProcessInstanceState getProcessInstanceState(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = RecordStream.INSTANCE.withElementType(RecordStream.INSTANCE.withProcessInstanceKey((Iterable)this.zeebeEngine.processInstanceRecords(), processInstanceKey), BpmnElementType.PROCESS);
        boolean $i$f$map = false;
        void var6_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIntent());
        }
        Intent state = (Intent)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
        iterable = state;
        return iterable == ProcessInstanceIntent.ELEMENT_ACTIVATED ? ProcessInstanceState.ACTIVATED : (iterable == ProcessInstanceIntent.ELEMENT_COMPLETED ? ProcessInstanceState.COMPLETED : (iterable == ProcessInstanceIntent.ELEMENT_TERMINATED ? ProcessInstanceState.TERMINATED : ProcessInstanceState.UNKNOWN));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ElementInstance> getElementInstances(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Function1<String, String> elementNameLookup = this.getElementNameLookup(processInstanceKey);
        Iterable iterable = RecordStream.INSTANCE.events(RecordStream.INSTANCE.withProcessInstanceKey((Iterable)this.zeebeEngine.processInstanceRecords(), processInstanceKey));
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = it.getKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            List records = (List)entry.getValue();
            Record lastElementInstanceRecord = (Record)CollectionsKt.last((List)records);
            String elementId = ((ProcessInstanceRecordValue)lastElementInstanceRecord.getValue()).getElementId();
            Intrinsics.checkNotNull((Object)elementId);
            Intent intent = lastElementInstanceRecord.getIntent();
            object.add(new ElementInstance(elementId, (String)elementNameLookup.invoke((Object)elementId), intent == ProcessInstanceIntent.ELEMENT_ACTIVATED ? ElementInstanceState.ACTIVATED : (intent == ProcessInstanceIntent.ELEMENT_COMPLETED ? ElementInstanceState.COMPLETED : (intent == ProcessInstanceIntent.ELEMENT_TERMINATED ? ElementInstanceState.TERMINATED : (intent == ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN ? ElementInstanceState.TAKEN : ElementInstanceState.UNKNOWN)))));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProcessInstanceVariable> getProcessInstanceVariables(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Function1<String, String> elementNameLookup = this.getElementNameLookup(processInstanceKey);
        Iterable iterable = RecordStream.INSTANCE.events((Iterable)this.zeebeEngine.variableRecords().withProcessInstanceKey(processInstanceKey));
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = it.getKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            List records = (List)entry.getValue();
            VariableRecordValue lastVariableRecordValue = (VariableRecordValue)((Record)CollectionsKt.last((List)records)).getValue();
            long scopeKey = lastVariableRecordValue.getScopeKey();
            String scopeElementId = this.getElementId(scopeKey);
            String string = lastVariableRecordValue.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = lastVariableRecordValue.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            String string3 = scopeElementId;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = scopeElementId;
            object.add(new ProcessInstanceVariable(string, string2, string3, string4 != null ? (String)elementNameLookup.invoke((Object)string4) : null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Incident> getIncidents(long processInstanceKey) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Function1<String, String> elementNameLookup = this.getElementNameLookup(processInstanceKey);
        Iterable iterable = RecordStream.INSTANCE.events((Iterable)this.zeebeEngine.incidentRecords().withProcessInstanceKey(processInstanceKey));
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = it.getKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            IncidentState incidentState;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            List records = (List)entry.getValue();
            Record lastIncidentRecord = (Record)CollectionsKt.last((List)records);
            String incidentElementId = this.getElementId(((IncidentRecordValue)lastIncidentRecord.getValue()).getElementInstanceKey());
            String string = ((IncidentRecordValue)lastIncidentRecord.getValue()).getErrorType().name();
            String string2 = ((IncidentRecordValue)lastIncidentRecord.getValue()).getErrorMessage();
            Object object2 = lastIncidentRecord.getIntent();
            IncidentState incidentState2 = incidentState = object2 == IncidentIntent.CREATED ? IncidentState.CREATED : (object2 == IncidentIntent.RESOLVED ? IncidentState.RESOLVED : IncidentState.UNKNOWN);
            String string3 = incidentElementId;
            if (string3 == null) {
                string3 = "?";
            }
            object2 = string3;
            String string4 = incidentElementId;
            String string5 = string4 != null ? (String)elementNameLookup.invoke((Object)string4) : null;
            object.add(new Incident(string, string2, (String)object2, string5, incidentState));
        }
        return (List)destination$iv$iv;
    }

    private final Function1<String, String> getElementNameLookup(long processInstanceKey) {
        Process processRecord;
        ProcessInstanceRecordValue processInstanceRecordValue;
        Record record = (Record)CollectionsKt.firstOrNull((Iterable)RecordStream.INSTANCE.withProcessInstanceKey(RecordStream.INSTANCE.events((Iterable)this.zeebeEngine.processInstanceRecords()), processInstanceKey));
        long processDefinitionKey = record != null && (processInstanceRecordValue = (ProcessInstanceRecordValue)record.getValue()) != null ? processInstanceRecordValue.getProcessDefinitionKey() : -1L;
        processInstanceRecordValue = (Record)CollectionsKt.firstOrNull((Iterable)RecordStream.INSTANCE.withKey(this.zeebeEngine.processRecords(), processDefinitionKey));
        Process process = processRecord = processInstanceRecordValue != null ? (Process)processInstanceRecordValue.getValue() : null;
        if (processRecord != null) {
            Process it = processRecord;
            boolean bl = false;
            byte[] bpmnXml = it.getResource();
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(bpmnXml));
            return (Function1)new Function1<String, String>(it, bpmnModelInstance){
                final /* synthetic */ Process $it;
                final /* synthetic */ BpmnModelInstance $bpmnModelInstance;
                {
                    this.$it = $it;
                    this.$bpmnModelInstance = $bpmnModelInstance;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String elementId) {
                    FlowElement flowElement;
                    Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
                    return Intrinsics.areEqual((Object)elementId, (Object)this.$it.getBpmnProcessId()) ? this.$it.getBpmnProcessId() : ((flowElement = (FlowElement)this.$bpmnModelInstance.getModelElementById(elementId)) != null ? flowElement.getName() : null);
                }
            };
        }
        return getElementNameLookup.2.INSTANCE;
    }

    private final String getElementId(long elementInstanceKey) {
        ProcessInstanceRecordValue processInstanceRecordValue;
        Record record = (Record)CollectionsKt.firstOrNull((Iterable)RecordStream.INSTANCE.withKey((Iterable)this.zeebeEngine.processInstanceRecords(), elementInstanceKey));
        return record != null && (processInstanceRecordValue = (ProcessInstanceRecordValue)record.getValue()) != null ? processInstanceRecordValue.getElementId() : null;
    }

    @Override
    public void close() {
    }
}

