/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.runner.zeeqs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0014\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient;", "", "zeeqsEndpoint", "", "(Ljava/lang/String;)V", "httpClient", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getElementInstances", "", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstanceDto;", "processInstanceKey", "", "getIncidents", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentDto;", "getProcessInstanceKeys", "getProcessInstanceState", "getProcessInstanceVariables", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableDto;", "sendRequest", "query", "ElementInstanceDto", "ElementInstancesDataDto", "ElementInstancesDto", "ElementInstancesResponse", "IncidentDto", "IncidentElementInstanceDto", "IncidentsDataDto", "IncidentsDto", "IncidentsResponse", "ProcessInstanceDataDto", "ProcessInstanceDto", "ProcessInstanceResponse", "ProcessInstancesDataDto", "ProcessInstancesDto", "ProcessInstancesResponse", "VariableDto", "VariableScopeDto", "VariablesDataDto", "VariablesDto", "VariablesResponse", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nZeeqsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZeeqsClient.kt\norg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n50#2:131\n43#2:132\n50#2:137\n43#2:138\n50#2:139\n43#2:140\n50#2:141\n43#2:142\n50#2:143\n43#2:144\n1549#3:133\n1620#3,3:134\n*S KotlinDebug\n*F\n+ 1 ZeeqsClient.kt\norg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient\n*L\n24#1:131\n24#1:132\n33#1:137\n33#1:138\n42#1:139\n42#1:140\n51#1:141\n51#1:142\n60#1:143\n60#1:144\n26#1:133\n26#1:134,3\n*E\n"})
public final class ZeeqsClient {
    @NotNull
    private final String zeeqsEndpoint;
    private final Logger logger;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public ZeeqsClient(@NotNull String zeeqsEndpoint) {
        Intrinsics.checkNotNullParameter((Object)zeeqsEndpoint, (String)"zeeqsEndpoint");
        this.zeeqsEndpoint = zeeqsEndpoint;
        this.logger = LoggerFactory.getLogger(ZeeqsClient.class);
        this.httpClient = HttpClient.newHttpClient();
        this.objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, false, false, false, null, false, false, false, 255, null));
    }

    public /* synthetic */ ZeeqsClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "http://localhost:9000/graphql";
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getProcessInstanceKeys() {
        void $this$mapTo$iv$iv;
        String responseBody = this.sendRequest("{ processInstances { nodes  { key, state } } }");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        ProcessInstancesResponse response = (ProcessInstancesResponse)$this$readValue$iv.readValue(responseBody, (TypeReference)new TypeReference<ProcessInstancesResponse>(){});
        Iterable $this$map$iv = response.getData().getProcessInstances().getNodes();
        boolean $i$f$map = false;
        Iterable $i$f$jacksonTypeRef22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Long.parseLong(it.getKey()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getProcessInstanceState(long processInstanceKey) {
        String responseBody = this.sendRequest("{ processInstance(key: " + processInstanceKey + ") { key, state } }");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        ProcessInstanceResponse response = (ProcessInstanceResponse)$this$readValue$iv.readValue(responseBody, (TypeReference)new TypeReference<ProcessInstanceResponse>(){});
        ProcessInstanceDto processInstanceDto = response.getData().getProcessInstance();
        return processInstanceDto != null ? processInstanceDto.getState() : null;
    }

    @NotNull
    public final List<ElementInstanceDto> getElementInstances(long processInstanceKey) {
        String responseBody = this.sendRequest("{ processInstance(key: " + processInstanceKey + ") { elementInstances { elementId, elementName, state } } }");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        ElementInstancesResponse response = (ElementInstancesResponse)$this$readValue$iv.readValue(responseBody, (TypeReference)new TypeReference<ElementInstancesResponse>(){});
        Object object = response.getData().getProcessInstance();
        if (object == null || (object = ((ElementInstancesDto)object).getElementInstances()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<VariableDto> getProcessInstanceVariables(long processInstanceKey) {
        String responseBody = this.sendRequest("{ processInstance(key: " + processInstanceKey + ") { variables { name, value, scope { elementId, elementName } } } }");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        VariablesResponse response = (VariablesResponse)$this$readValue$iv.readValue(responseBody, (TypeReference)new TypeReference<VariablesResponse>(){});
        Object object = response.getData().getProcessInstance();
        if (object == null || (object = ((VariablesDto)object).getVariables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<IncidentDto> getIncidents(long processInstanceKey) {
        String responseBody = this.sendRequest("{ processInstance(key: " + processInstanceKey + ") { incidents { errorType, errorMessage, state, elementInstance { elementId, elementName } } } }");
        ObjectMapper objectMapper = this.objectMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"objectMapper");
        ObjectMapper $this$readValue$iv = objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        IncidentsResponse response = (IncidentsResponse)$this$readValue$iv.readValue(responseBody, (TypeReference)new TypeReference<IncidentsResponse>(){});
        Object object = response.getData().getProcessInstance();
        if (object == null || (object = ((IncidentsDto)object).getIncidents()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final String sendRequest(String query) {
        HttpRequest.BodyPublisher requestBody = HttpRequest.BodyPublishers.ofString("{ \"query\": \"" + query + "\" }");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + this.zeeqsEndpoint)).header("Content-Type", "application/json").POST(requestBody).build();
        this.logger.trace("Send query request to ZeeQS: {}", (Object)query);
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        String responseBody = response.body();
        this.logger.trace("Received query response from ZeeQS: [status-code: {}, body: {}]", (Object)statusCode, (Object)responseBody);
        if (statusCode != 200) {
            throw new RuntimeException("Failed to query ZeeQS. [status-code: " + statusCode + ", body: " + responseBody + "]");
        }
        Intrinsics.checkNotNull((Object)responseBody);
        return responseBody;
    }

    public ZeeqsClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstanceDto;", "", "state", "", "elementId", "elementName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "getElementName", "getState", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class ElementInstanceDto {
        @NotNull
        private final String state;
        @NotNull
        private final String elementId;
        @Nullable
        private final String elementName;

        public ElementInstanceDto(@NotNull String state, @NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            this.state = state;
            this.elementId = elementId;
            this.elementName = elementName;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @NotNull
        public final String getElementId() {
            return this.elementId;
        }

        @Nullable
        public final String getElementName() {
            return this.elementName;
        }

        @NotNull
        public final String component1() {
            return this.state;
        }

        @NotNull
        public final String component2() {
            return this.elementId;
        }

        @Nullable
        public final String component3() {
            return this.elementName;
        }

        @NotNull
        public final ElementInstanceDto copy(@NotNull String state, @NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            return new ElementInstanceDto(state, elementId, elementName);
        }

        public static /* synthetic */ ElementInstanceDto copy$default(ElementInstanceDto elementInstanceDto, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = elementInstanceDto.state;
            }
            if ((n & 2) != 0) {
                string2 = elementInstanceDto.elementId;
            }
            if ((n & 4) != 0) {
                string3 = elementInstanceDto.elementName;
            }
            return elementInstanceDto.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ElementInstanceDto(state=" + this.state + ", elementId=" + this.elementId + ", elementName=" + this.elementName + ")";
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + this.elementId.hashCode();
            result = result * 31 + (this.elementName == null ? 0 : this.elementName.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementInstanceDto)) {
                return false;
            }
            ElementInstanceDto elementInstanceDto = (ElementInstanceDto)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)elementInstanceDto.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.elementId, (Object)elementInstanceDto.elementId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.elementName, (Object)elementInstanceDto.elementName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDataDto;", "", "processInstance", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDto;)V", "getProcessInstance", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ElementInstancesDataDto {
        @Nullable
        private final ElementInstancesDto processInstance;

        public ElementInstancesDataDto(@Nullable ElementInstancesDto processInstance) {
            this.processInstance = processInstance;
        }

        @Nullable
        public final ElementInstancesDto getProcessInstance() {
            return this.processInstance;
        }

        @Nullable
        public final ElementInstancesDto component1() {
            return this.processInstance;
        }

        @NotNull
        public final ElementInstancesDataDto copy(@Nullable ElementInstancesDto processInstance) {
            return new ElementInstancesDataDto(processInstance);
        }

        public static /* synthetic */ ElementInstancesDataDto copy$default(ElementInstancesDataDto elementInstancesDataDto, ElementInstancesDto elementInstancesDto, int n, Object object) {
            if ((n & 1) != 0) {
                elementInstancesDto = elementInstancesDataDto.processInstance;
            }
            return elementInstancesDataDto.copy(elementInstancesDto);
        }

        @NotNull
        public String toString() {
            return "ElementInstancesDataDto(processInstance=" + this.processInstance + ")";
        }

        public int hashCode() {
            return this.processInstance == null ? 0 : this.processInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementInstancesDataDto)) {
                return false;
            }
            ElementInstancesDataDto elementInstancesDataDto = (ElementInstancesDataDto)other;
            return Intrinsics.areEqual((Object)this.processInstance, (Object)elementInstancesDataDto.processInstance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDto;", "", "elementInstances", "", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstanceDto;", "(Ljava/util/List;)V", "getElementInstances", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ElementInstancesDto {
        @NotNull
        private final List<ElementInstanceDto> elementInstances;

        public ElementInstancesDto(@NotNull List<ElementInstanceDto> elementInstances) {
            Intrinsics.checkNotNullParameter(elementInstances, (String)"elementInstances");
            this.elementInstances = elementInstances;
        }

        @NotNull
        public final List<ElementInstanceDto> getElementInstances() {
            return this.elementInstances;
        }

        @NotNull
        public final List<ElementInstanceDto> component1() {
            return this.elementInstances;
        }

        @NotNull
        public final ElementInstancesDto copy(@NotNull List<ElementInstanceDto> elementInstances) {
            Intrinsics.checkNotNullParameter(elementInstances, (String)"elementInstances");
            return new ElementInstancesDto(elementInstances);
        }

        public static /* synthetic */ ElementInstancesDto copy$default(ElementInstancesDto elementInstancesDto, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = elementInstancesDto.elementInstances;
            }
            return elementInstancesDto.copy(list);
        }

        @NotNull
        public String toString() {
            return "ElementInstancesDto(elementInstances=" + this.elementInstances + ")";
        }

        public int hashCode() {
            return ((Object)this.elementInstances).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementInstancesDto)) {
                return false;
            }
            ElementInstancesDto elementInstancesDto = (ElementInstancesDto)other;
            return Intrinsics.areEqual(this.elementInstances, elementInstancesDto.elementInstances);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesResponse;", "", "data", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDataDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDataDto;)V", "getData", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ElementInstancesDataDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ElementInstancesResponse {
        @NotNull
        private final ElementInstancesDataDto data;

        public ElementInstancesResponse(@NotNull ElementInstancesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final ElementInstancesDataDto getData() {
            return this.data;
        }

        @NotNull
        public final ElementInstancesDataDto component1() {
            return this.data;
        }

        @NotNull
        public final ElementInstancesResponse copy(@NotNull ElementInstancesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new ElementInstancesResponse(data);
        }

        public static /* synthetic */ ElementInstancesResponse copy$default(ElementInstancesResponse elementInstancesResponse, ElementInstancesDataDto elementInstancesDataDto, int n, Object object) {
            if ((n & 1) != 0) {
                elementInstancesDataDto = elementInstancesResponse.data;
            }
            return elementInstancesResponse.copy(elementInstancesDataDto);
        }

        @NotNull
        public String toString() {
            return "ElementInstancesResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementInstancesResponse)) {
                return false;
            }
            ElementInstancesResponse elementInstancesResponse = (ElementInstancesResponse)other;
            return Intrinsics.areEqual((Object)this.data, (Object)elementInstancesResponse.data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentDto;", "", "errorType", "", "errorMessage", "state", "elementInstance", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentElementInstanceDto;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentElementInstanceDto;)V", "getElementInstance", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentElementInstanceDto;", "getErrorMessage", "()Ljava/lang/String;", "getErrorType", "getState", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class IncidentDto {
        @NotNull
        private final String errorType;
        @Nullable
        private final String errorMessage;
        @NotNull
        private final String state;
        @Nullable
        private final IncidentElementInstanceDto elementInstance;

        public IncidentDto(@NotNull String errorType, @Nullable String errorMessage, @NotNull String state, @Nullable IncidentElementInstanceDto elementInstance) {
            Intrinsics.checkNotNullParameter((Object)errorType, (String)"errorType");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.errorType = errorType;
            this.errorMessage = errorMessage;
            this.state = state;
            this.elementInstance = elementInstance;
        }

        @NotNull
        public final String getErrorType() {
            return this.errorType;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @Nullable
        public final IncidentElementInstanceDto getElementInstance() {
            return this.elementInstance;
        }

        @NotNull
        public final String component1() {
            return this.errorType;
        }

        @Nullable
        public final String component2() {
            return this.errorMessage;
        }

        @NotNull
        public final String component3() {
            return this.state;
        }

        @Nullable
        public final IncidentElementInstanceDto component4() {
            return this.elementInstance;
        }

        @NotNull
        public final IncidentDto copy(@NotNull String errorType, @Nullable String errorMessage, @NotNull String state, @Nullable IncidentElementInstanceDto elementInstance) {
            Intrinsics.checkNotNullParameter((Object)errorType, (String)"errorType");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new IncidentDto(errorType, errorMessage, state, elementInstance);
        }

        public static /* synthetic */ IncidentDto copy$default(IncidentDto incidentDto, String string, String string2, String string3, IncidentElementInstanceDto incidentElementInstanceDto, int n, Object object) {
            if ((n & 1) != 0) {
                string = incidentDto.errorType;
            }
            if ((n & 2) != 0) {
                string2 = incidentDto.errorMessage;
            }
            if ((n & 4) != 0) {
                string3 = incidentDto.state;
            }
            if ((n & 8) != 0) {
                incidentElementInstanceDto = incidentDto.elementInstance;
            }
            return incidentDto.copy(string, string2, string3, incidentElementInstanceDto);
        }

        @NotNull
        public String toString() {
            return "IncidentDto(errorType=" + this.errorType + ", errorMessage=" + this.errorMessage + ", state=" + this.state + ", elementInstance=" + this.elementInstance + ")";
        }

        public int hashCode() {
            int result = this.errorType.hashCode();
            result = result * 31 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = result * 31 + this.state.hashCode();
            result = result * 31 + (this.elementInstance == null ? 0 : this.elementInstance.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncidentDto)) {
                return false;
            }
            IncidentDto incidentDto = (IncidentDto)other;
            if (!Intrinsics.areEqual((Object)this.errorType, (Object)incidentDto.errorType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)incidentDto.errorMessage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.state, (Object)incidentDto.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.elementInstance, (Object)incidentDto.elementInstance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentElementInstanceDto;", "", "elementId", "", "elementName", "(Ljava/lang/String;Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "getElementName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class IncidentElementInstanceDto {
        @NotNull
        private final String elementId;
        @Nullable
        private final String elementName;

        public IncidentElementInstanceDto(@NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            this.elementId = elementId;
            this.elementName = elementName;
        }

        @NotNull
        public final String getElementId() {
            return this.elementId;
        }

        @Nullable
        public final String getElementName() {
            return this.elementName;
        }

        @NotNull
        public final String component1() {
            return this.elementId;
        }

        @Nullable
        public final String component2() {
            return this.elementName;
        }

        @NotNull
        public final IncidentElementInstanceDto copy(@NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            return new IncidentElementInstanceDto(elementId, elementName);
        }

        public static /* synthetic */ IncidentElementInstanceDto copy$default(IncidentElementInstanceDto incidentElementInstanceDto, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = incidentElementInstanceDto.elementId;
            }
            if ((n & 2) != 0) {
                string2 = incidentElementInstanceDto.elementName;
            }
            return incidentElementInstanceDto.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "IncidentElementInstanceDto(elementId=" + this.elementId + ", elementName=" + this.elementName + ")";
        }

        public int hashCode() {
            int result = this.elementId.hashCode();
            result = result * 31 + (this.elementName == null ? 0 : this.elementName.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncidentElementInstanceDto)) {
                return false;
            }
            IncidentElementInstanceDto incidentElementInstanceDto = (IncidentElementInstanceDto)other;
            if (!Intrinsics.areEqual((Object)this.elementId, (Object)incidentElementInstanceDto.elementId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.elementName, (Object)incidentElementInstanceDto.elementName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDataDto;", "", "processInstance", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDto;)V", "getProcessInstance", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class IncidentsDataDto {
        @Nullable
        private final IncidentsDto processInstance;

        public IncidentsDataDto(@Nullable IncidentsDto processInstance) {
            this.processInstance = processInstance;
        }

        @Nullable
        public final IncidentsDto getProcessInstance() {
            return this.processInstance;
        }

        @Nullable
        public final IncidentsDto component1() {
            return this.processInstance;
        }

        @NotNull
        public final IncidentsDataDto copy(@Nullable IncidentsDto processInstance) {
            return new IncidentsDataDto(processInstance);
        }

        public static /* synthetic */ IncidentsDataDto copy$default(IncidentsDataDto incidentsDataDto, IncidentsDto incidentsDto, int n, Object object) {
            if ((n & 1) != 0) {
                incidentsDto = incidentsDataDto.processInstance;
            }
            return incidentsDataDto.copy(incidentsDto);
        }

        @NotNull
        public String toString() {
            return "IncidentsDataDto(processInstance=" + this.processInstance + ")";
        }

        public int hashCode() {
            return this.processInstance == null ? 0 : this.processInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncidentsDataDto)) {
                return false;
            }
            IncidentsDataDto incidentsDataDto = (IncidentsDataDto)other;
            return Intrinsics.areEqual((Object)this.processInstance, (Object)incidentsDataDto.processInstance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDto;", "", "incidents", "", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentDto;", "(Ljava/util/List;)V", "getIncidents", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class IncidentsDto {
        @NotNull
        private final List<IncidentDto> incidents;

        public IncidentsDto(@NotNull List<IncidentDto> incidents) {
            Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
            this.incidents = incidents;
        }

        @NotNull
        public final List<IncidentDto> getIncidents() {
            return this.incidents;
        }

        @NotNull
        public final List<IncidentDto> component1() {
            return this.incidents;
        }

        @NotNull
        public final IncidentsDto copy(@NotNull List<IncidentDto> incidents) {
            Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
            return new IncidentsDto(incidents);
        }

        public static /* synthetic */ IncidentsDto copy$default(IncidentsDto incidentsDto, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = incidentsDto.incidents;
            }
            return incidentsDto.copy(list);
        }

        @NotNull
        public String toString() {
            return "IncidentsDto(incidents=" + this.incidents + ")";
        }

        public int hashCode() {
            return ((Object)this.incidents).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncidentsDto)) {
                return false;
            }
            IncidentsDto incidentsDto = (IncidentsDto)other;
            return Intrinsics.areEqual(this.incidents, incidentsDto.incidents);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsResponse;", "", "data", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDataDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDataDto;)V", "getData", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$IncidentsDataDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class IncidentsResponse {
        @NotNull
        private final IncidentsDataDto data;

        public IncidentsResponse(@NotNull IncidentsDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final IncidentsDataDto getData() {
            return this.data;
        }

        @NotNull
        public final IncidentsDataDto component1() {
            return this.data;
        }

        @NotNull
        public final IncidentsResponse copy(@NotNull IncidentsDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new IncidentsResponse(data);
        }

        public static /* synthetic */ IncidentsResponse copy$default(IncidentsResponse incidentsResponse, IncidentsDataDto incidentsDataDto, int n, Object object) {
            if ((n & 1) != 0) {
                incidentsDataDto = incidentsResponse.data;
            }
            return incidentsResponse.copy(incidentsDataDto);
        }

        @NotNull
        public String toString() {
            return "IncidentsResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IncidentsResponse)) {
                return false;
            }
            IncidentsResponse incidentsResponse = (IncidentsResponse)other;
            return Intrinsics.areEqual((Object)this.data, (Object)incidentsResponse.data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDataDto;", "", "processInstance", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDto;)V", "getProcessInstance", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ProcessInstanceDataDto {
        @Nullable
        private final ProcessInstanceDto processInstance;

        public ProcessInstanceDataDto(@Nullable ProcessInstanceDto processInstance) {
            this.processInstance = processInstance;
        }

        @Nullable
        public final ProcessInstanceDto getProcessInstance() {
            return this.processInstance;
        }

        @Nullable
        public final ProcessInstanceDto component1() {
            return this.processInstance;
        }

        @NotNull
        public final ProcessInstanceDataDto copy(@Nullable ProcessInstanceDto processInstance) {
            return new ProcessInstanceDataDto(processInstance);
        }

        public static /* synthetic */ ProcessInstanceDataDto copy$default(ProcessInstanceDataDto processInstanceDataDto, ProcessInstanceDto processInstanceDto, int n, Object object) {
            if ((n & 1) != 0) {
                processInstanceDto = processInstanceDataDto.processInstance;
            }
            return processInstanceDataDto.copy(processInstanceDto);
        }

        @NotNull
        public String toString() {
            return "ProcessInstanceDataDto(processInstance=" + this.processInstance + ")";
        }

        public int hashCode() {
            return this.processInstance == null ? 0 : this.processInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstanceDataDto)) {
                return false;
            }
            ProcessInstanceDataDto processInstanceDataDto = (ProcessInstanceDataDto)other;
            return Intrinsics.areEqual((Object)this.processInstance, (Object)processInstanceDataDto.processInstance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDto;", "", "key", "", "state", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getState", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class ProcessInstanceDto {
        @NotNull
        private final String key;
        @NotNull
        private final String state;

        public ProcessInstanceDto(@NotNull String key, @NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.key = key;
            this.state = state;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.state;
        }

        @NotNull
        public final ProcessInstanceDto copy(@NotNull String key, @NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new ProcessInstanceDto(key, state);
        }

        public static /* synthetic */ ProcessInstanceDto copy$default(ProcessInstanceDto processInstanceDto, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = processInstanceDto.key;
            }
            if ((n & 2) != 0) {
                string2 = processInstanceDto.state;
            }
            return processInstanceDto.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ProcessInstanceDto(key=" + this.key + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstanceDto)) {
                return false;
            }
            ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)processInstanceDto.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)processInstanceDto.state);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceResponse;", "", "data", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDataDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDataDto;)V", "getData", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDataDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ProcessInstanceResponse {
        @NotNull
        private final ProcessInstanceDataDto data;

        public ProcessInstanceResponse(@NotNull ProcessInstanceDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final ProcessInstanceDataDto getData() {
            return this.data;
        }

        @NotNull
        public final ProcessInstanceDataDto component1() {
            return this.data;
        }

        @NotNull
        public final ProcessInstanceResponse copy(@NotNull ProcessInstanceDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new ProcessInstanceResponse(data);
        }

        public static /* synthetic */ ProcessInstanceResponse copy$default(ProcessInstanceResponse processInstanceResponse, ProcessInstanceDataDto processInstanceDataDto, int n, Object object) {
            if ((n & 1) != 0) {
                processInstanceDataDto = processInstanceResponse.data;
            }
            return processInstanceResponse.copy(processInstanceDataDto);
        }

        @NotNull
        public String toString() {
            return "ProcessInstanceResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstanceResponse)) {
                return false;
            }
            ProcessInstanceResponse processInstanceResponse = (ProcessInstanceResponse)other;
            return Intrinsics.areEqual((Object)this.data, (Object)processInstanceResponse.data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDataDto;", "", "processInstances", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDto;)V", "getProcessInstances", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ProcessInstancesDataDto {
        @NotNull
        private final ProcessInstancesDto processInstances;

        public ProcessInstancesDataDto(@NotNull ProcessInstancesDto processInstances) {
            Intrinsics.checkNotNullParameter((Object)processInstances, (String)"processInstances");
            this.processInstances = processInstances;
        }

        @NotNull
        public final ProcessInstancesDto getProcessInstances() {
            return this.processInstances;
        }

        @NotNull
        public final ProcessInstancesDto component1() {
            return this.processInstances;
        }

        @NotNull
        public final ProcessInstancesDataDto copy(@NotNull ProcessInstancesDto processInstances) {
            Intrinsics.checkNotNullParameter((Object)processInstances, (String)"processInstances");
            return new ProcessInstancesDataDto(processInstances);
        }

        public static /* synthetic */ ProcessInstancesDataDto copy$default(ProcessInstancesDataDto processInstancesDataDto, ProcessInstancesDto processInstancesDto, int n, Object object) {
            if ((n & 1) != 0) {
                processInstancesDto = processInstancesDataDto.processInstances;
            }
            return processInstancesDataDto.copy(processInstancesDto);
        }

        @NotNull
        public String toString() {
            return "ProcessInstancesDataDto(processInstances=" + this.processInstances + ")";
        }

        public int hashCode() {
            return this.processInstances.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstancesDataDto)) {
                return false;
            }
            ProcessInstancesDataDto processInstancesDataDto = (ProcessInstancesDataDto)other;
            return Intrinsics.areEqual((Object)this.processInstances, (Object)processInstancesDataDto.processInstances);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDto;", "", "nodes", "", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstanceDto;", "(Ljava/util/List;)V", "getNodes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ProcessInstancesDto {
        @NotNull
        private final List<ProcessInstanceDto> nodes;

        public ProcessInstancesDto(@NotNull List<ProcessInstanceDto> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.nodes = nodes;
        }

        @NotNull
        public final List<ProcessInstanceDto> getNodes() {
            return this.nodes;
        }

        @NotNull
        public final List<ProcessInstanceDto> component1() {
            return this.nodes;
        }

        @NotNull
        public final ProcessInstancesDto copy(@NotNull List<ProcessInstanceDto> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            return new ProcessInstancesDto(nodes);
        }

        public static /* synthetic */ ProcessInstancesDto copy$default(ProcessInstancesDto processInstancesDto, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = processInstancesDto.nodes;
            }
            return processInstancesDto.copy(list);
        }

        @NotNull
        public String toString() {
            return "ProcessInstancesDto(nodes=" + this.nodes + ")";
        }

        public int hashCode() {
            return ((Object)this.nodes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstancesDto)) {
                return false;
            }
            ProcessInstancesDto processInstancesDto = (ProcessInstancesDto)other;
            return Intrinsics.areEqual(this.nodes, processInstancesDto.nodes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesResponse;", "", "data", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDataDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDataDto;)V", "getData", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$ProcessInstancesDataDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class ProcessInstancesResponse {
        @NotNull
        private final ProcessInstancesDataDto data;

        public ProcessInstancesResponse(@NotNull ProcessInstancesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final ProcessInstancesDataDto getData() {
            return this.data;
        }

        @NotNull
        public final ProcessInstancesDataDto component1() {
            return this.data;
        }

        @NotNull
        public final ProcessInstancesResponse copy(@NotNull ProcessInstancesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new ProcessInstancesResponse(data);
        }

        public static /* synthetic */ ProcessInstancesResponse copy$default(ProcessInstancesResponse processInstancesResponse, ProcessInstancesDataDto processInstancesDataDto, int n, Object object) {
            if ((n & 1) != 0) {
                processInstancesDataDto = processInstancesResponse.data;
            }
            return processInstancesResponse.copy(processInstancesDataDto);
        }

        @NotNull
        public String toString() {
            return "ProcessInstancesResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInstancesResponse)) {
                return false;
            }
            ProcessInstancesResponse processInstancesResponse = (ProcessInstancesResponse)other;
            return Intrinsics.areEqual((Object)this.data, (Object)processInstancesResponse.data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableDto;", "", "name", "", "value", "scope", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableScopeDto;", "(Ljava/lang/String;Ljava/lang/String;Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableScopeDto;)V", "getName", "()Ljava/lang/String;", "getScope", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableScopeDto;", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class VariableDto {
        @NotNull
        private final String name;
        @NotNull
        private final String value;
        @Nullable
        private final VariableScopeDto scope;

        public VariableDto(@NotNull String name, @NotNull String value, @Nullable VariableScopeDto scope) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.name = name;
            this.value = value;
            this.scope = scope;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final VariableScopeDto getScope() {
            return this.scope;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @Nullable
        public final VariableScopeDto component3() {
            return this.scope;
        }

        @NotNull
        public final VariableDto copy(@NotNull String name, @NotNull String value, @Nullable VariableScopeDto scope) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new VariableDto(name, value, scope);
        }

        public static /* synthetic */ VariableDto copy$default(VariableDto variableDto, String string, String string2, VariableScopeDto variableScopeDto, int n, Object object) {
            if ((n & 1) != 0) {
                string = variableDto.name;
            }
            if ((n & 2) != 0) {
                string2 = variableDto.value;
            }
            if ((n & 4) != 0) {
                variableScopeDto = variableDto.scope;
            }
            return variableDto.copy(string, string2, variableScopeDto);
        }

        @NotNull
        public String toString() {
            return "VariableDto(name=" + this.name + ", value=" + this.value + ", scope=" + this.scope + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariableDto)) {
                return false;
            }
            VariableDto variableDto = (VariableDto)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)variableDto.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)variableDto.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scope, (Object)variableDto.scope);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableScopeDto;", "", "elementId", "", "elementName", "(Ljava/lang/String;Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "getElementName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "zeebe-spec-core"})
    public static final class VariableScopeDto {
        @NotNull
        private final String elementId;
        @Nullable
        private final String elementName;

        public VariableScopeDto(@NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            this.elementId = elementId;
            this.elementName = elementName;
        }

        @NotNull
        public final String getElementId() {
            return this.elementId;
        }

        @Nullable
        public final String getElementName() {
            return this.elementName;
        }

        @NotNull
        public final String component1() {
            return this.elementId;
        }

        @Nullable
        public final String component2() {
            return this.elementName;
        }

        @NotNull
        public final VariableScopeDto copy(@NotNull String elementId, @Nullable String elementName) {
            Intrinsics.checkNotNullParameter((Object)elementId, (String)"elementId");
            return new VariableScopeDto(elementId, elementName);
        }

        public static /* synthetic */ VariableScopeDto copy$default(VariableScopeDto variableScopeDto, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = variableScopeDto.elementId;
            }
            if ((n & 2) != 0) {
                string2 = variableScopeDto.elementName;
            }
            return variableScopeDto.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "VariableScopeDto(elementId=" + this.elementId + ", elementName=" + this.elementName + ")";
        }

        public int hashCode() {
            int result = this.elementId.hashCode();
            result = result * 31 + (this.elementName == null ? 0 : this.elementName.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariableScopeDto)) {
                return false;
            }
            VariableScopeDto variableScopeDto = (VariableScopeDto)other;
            if (!Intrinsics.areEqual((Object)this.elementId, (Object)variableScopeDto.elementId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.elementName, (Object)variableScopeDto.elementName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDataDto;", "", "processInstance", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDto;)V", "getProcessInstance", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class VariablesDataDto {
        @Nullable
        private final VariablesDto processInstance;

        public VariablesDataDto(@Nullable VariablesDto processInstance) {
            this.processInstance = processInstance;
        }

        @Nullable
        public final VariablesDto getProcessInstance() {
            return this.processInstance;
        }

        @Nullable
        public final VariablesDto component1() {
            return this.processInstance;
        }

        @NotNull
        public final VariablesDataDto copy(@Nullable VariablesDto processInstance) {
            return new VariablesDataDto(processInstance);
        }

        public static /* synthetic */ VariablesDataDto copy$default(VariablesDataDto variablesDataDto, VariablesDto variablesDto, int n, Object object) {
            if ((n & 1) != 0) {
                variablesDto = variablesDataDto.processInstance;
            }
            return variablesDataDto.copy(variablesDto);
        }

        @NotNull
        public String toString() {
            return "VariablesDataDto(processInstance=" + this.processInstance + ")";
        }

        public int hashCode() {
            return this.processInstance == null ? 0 : this.processInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariablesDataDto)) {
                return false;
            }
            VariablesDataDto variablesDataDto = (VariablesDataDto)other;
            return Intrinsics.areEqual((Object)this.processInstance, (Object)variablesDataDto.processInstance);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDto;", "", "variables", "", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariableDto;", "(Ljava/util/List;)V", "getVariables", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class VariablesDto {
        @NotNull
        private final List<VariableDto> variables;

        public VariablesDto(@NotNull List<VariableDto> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            this.variables = variables;
        }

        @NotNull
        public final List<VariableDto> getVariables() {
            return this.variables;
        }

        @NotNull
        public final List<VariableDto> component1() {
            return this.variables;
        }

        @NotNull
        public final VariablesDto copy(@NotNull List<VariableDto> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            return new VariablesDto(variables);
        }

        public static /* synthetic */ VariablesDto copy$default(VariablesDto variablesDto, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = variablesDto.variables;
            }
            return variablesDto.copy(list);
        }

        @NotNull
        public String toString() {
            return "VariablesDto(variables=" + this.variables + ")";
        }

        public int hashCode() {
            return ((Object)this.variables).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariablesDto)) {
                return false;
            }
            VariablesDto variablesDto = (VariablesDto)other;
            return Intrinsics.areEqual(this.variables, variablesDto.variables);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesResponse;", "", "data", "Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDataDto;", "(Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDataDto;)V", "getData", "()Lorg/camunda/community/zeebe/spec/runner/zeeqs/ZeeqsClient$VariablesDataDto;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zeebe-spec-core"})
    public static final class VariablesResponse {
        @NotNull
        private final VariablesDataDto data;

        public VariablesResponse(@NotNull VariablesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final VariablesDataDto getData() {
            return this.data;
        }

        @NotNull
        public final VariablesDataDto component1() {
            return this.data;
        }

        @NotNull
        public final VariablesResponse copy(@NotNull VariablesDataDto data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new VariablesResponse(data);
        }

        public static /* synthetic */ VariablesResponse copy$default(VariablesResponse variablesResponse, VariablesDataDto variablesDataDto, int n, Object object) {
            if ((n & 1) != 0) {
                variablesDataDto = variablesResponse.data;
            }
            return variablesResponse.copy(variablesDataDto);
        }

        @NotNull
        public String toString() {
            return "VariablesResponse(data=" + this.data + ")";
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariablesResponse)) {
                return false;
            }
            VariablesResponse variablesResponse = (VariablesResponse)other;
            return Intrinsics.areEqual((Object)this.data, (Object)variablesResponse.data);
        }
    }
}

