/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.httpclient.impl;

import connectjar.org.apache.http.client.methods.CloseableHttpResponse;
import connectjar.org.apache.http.client.methods.HttpDelete;
import connectjar.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import connectjar.org.apache.http.client.methods.HttpGet;
import connectjar.org.apache.http.client.methods.HttpHead;
import connectjar.org.apache.http.client.methods.HttpOptions;
import connectjar.org.apache.http.client.methods.HttpPatch;
import connectjar.org.apache.http.client.methods.HttpPost;
import connectjar.org.apache.http.client.methods.HttpPut;
import connectjar.org.apache.http.client.methods.HttpRequestBase;
import connectjar.org.apache.http.client.methods.HttpTrace;
import connectjar.org.apache.http.entity.InputStreamEntity;
import connectjar.org.apache.http.impl.client.CloseableHttpClient;
import connectjar.org.apache.http.impl.client.HttpClients;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.camunda.connect.httpclient.HttpBaseRequest;
import org.camunda.connect.httpclient.HttpResponse;
import org.camunda.connect.httpclient.impl.HttpConnectorLogger;
import org.camunda.connect.httpclient.impl.HttpLogger;
import org.camunda.connect.httpclient.impl.HttpRequestInvocation;
import org.camunda.connect.impl.AbstractConnector;
import org.camunda.connect.spi.ConnectorRequest;

public abstract class AbstractHttpConnector<Q extends HttpBaseRequest<Q, R>, R extends HttpResponse>
extends AbstractConnector<Q, R> {
    protected static HttpConnectorLogger LOG = HttpLogger.HTTP_LOGGER;
    protected CloseableHttpClient httpClient = this.createClient();
    protected final Charset charset = Charset.forName("utf-8");

    public AbstractHttpConnector(String connectorId) {
        super(connectorId);
    }

    protected CloseableHttpClient createClient() {
        return HttpClients.createSystem();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public R execute(Q request) {
        Object httpRequest = this.createHttpRequest(request);
        HttpRequestInvocation invocation = new HttpRequestInvocation((HttpRequestBase)httpRequest, (ConnectorRequest<?>)request, this.requestInterceptors, this.httpClient);
        try {
            return this.createResponse((CloseableHttpResponse)invocation.proceed());
        }
        catch (Exception e) {
            throw LOG.unableToExecuteRequest(e);
        }
    }

    protected abstract R createResponse(CloseableHttpResponse var1);

    public abstract Q createRequest();

    protected <T extends HttpRequestBase> T createHttpRequest(Q request) {
        T httpRequest = this.createHttpRequestBase(request);
        this.applyHeaders(httpRequest, request.getHeaders());
        this.applyPayload(httpRequest, request);
        return httpRequest;
    }

    protected <T extends HttpRequestBase> T createHttpRequestBase(Q request) {
        String url = request.getUrl();
        if (url != null && !url.trim().isEmpty()) {
            String method = request.getMethod();
            if ("GET".equals(method)) {
                return (T)new HttpGet(url);
            }
            if ("POST".equals(method)) {
                return (T)new HttpPost(url);
            }
            if ("PUT".equals(method)) {
                return (T)new HttpPut(url);
            }
            if ("DELETE".equals(method)) {
                return (T)new HttpDelete(url);
            }
            if ("PATCH".equals(method)) {
                return (T)new HttpPatch(url);
            }
            if ("HEAD".equals(method)) {
                return (T)new HttpHead(url);
            }
            if ("OPTIONS".equals(method)) {
                return (T)new HttpOptions(url);
            }
            if ("TRACE".equals(method)) {
                return (T)new HttpTrace(url);
            }
            throw LOG.unknownHttpMethod(method);
        }
        throw LOG.requestUrlRequired();
    }

    protected <T extends HttpRequestBase> void applyHeaders(T httpRequest, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.setHeader(entry.getKey(), entry.getValue());
                LOG.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected <T extends HttpRequestBase> void applyPayload(T httpRequest, Q request) {
        if (this.httpMethodSupportsPayload(httpRequest)) {
            if (request.getPayload() != null) {
                byte[] bytes = request.getPayload().getBytes(this.charset);
                ByteArrayInputStream payload = new ByteArrayInputStream(bytes);
                InputStreamEntity entity = new InputStreamEntity((InputStream)payload, bytes.length);
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
            }
        } else if (request.getPayload() != null) {
            LOG.payloadIgnoredForHttpMethod(request.getMethod());
        }
    }

    protected <T extends HttpRequestBase> boolean httpMethodSupportsPayload(T httpRequest) {
        return httpRequest instanceof HttpEntityEnclosingRequestBase;
    }
}

