/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.httpclient.impl;

import java.net.InetAddress;
import java.util.Collection;
import java.util.function.BiConsumer;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;

public enum RequestConfigOption {
    AUTHENTICATION_ENABLED("authentication-enabled", (builder, value) -> builder.setAuthenticationEnabled(((Boolean)value).booleanValue())),
    CIRCULAR_REDIRECTS_ALLOWED("circular-redirects-allowed", (builder, value) -> builder.setCircularRedirectsAllowed(((Boolean)value).booleanValue())),
    CONNECTION_TIMEOUT("connection-timeout", (builder, value) -> builder.setConnectTimeout(((Integer)value).intValue())),
    CONNECTION_REQUEST_TIMEOUT("connection-request-timeout", (builder, value) -> builder.setConnectionRequestTimeout(((Integer)value).intValue())),
    CONTENT_COMPRESSION_ENABLED("content-compression-enabled", (builder, value) -> builder.setContentCompressionEnabled(((Boolean)value).booleanValue())),
    COOKIE_SPEC("cookie-spec", (builder, value) -> builder.setCookieSpec((String)value)),
    DECOMPRESSION_ENABLED("decompression-enabled", (builder, value) -> builder.setDecompressionEnabled(((Boolean)value).booleanValue())),
    EXPECT_CONTINUE_ENABLED("expect-continue-enabled", (builder, value) -> builder.setExpectContinueEnabled(((Boolean)value).booleanValue())),
    LOCAL_ADDRESS("local-address", (builder, value) -> builder.setLocalAddress((InetAddress)value)),
    MAX_REDIRECTS("max-redirects", (builder, value) -> builder.setMaxRedirects(((Integer)value).intValue())),
    NORMALIZE_URI("normalize-uri", (builder, value) -> builder.setNormalizeUri(((Boolean)value).booleanValue())),
    PROXY("proxy", (builder, value) -> builder.setProxy((HttpHost)value)),
    PROXY_PREFERRED_AUTH_SCHEMES("proxy-preferred-auth-scheme", (builder, value) -> builder.setProxyPreferredAuthSchemes((Collection)value)),
    REDIRECTS_ENABLED("relative-redirects-allowed", (builder, value) -> builder.setRedirectsEnabled(((Boolean)value).booleanValue())),
    RELATIVE_REDIRECTS_ALLOWED("relative-redirects-allowed", (builder, value) -> builder.setRelativeRedirectsAllowed(((Boolean)value).booleanValue())),
    SOCKET_TIMEOUT("socket-timeout", (builder, value) -> builder.setSocketTimeout(((Integer)value).intValue())),
    STALE_CONNECTION_CHECK_ENABLED("stale-connection-check-enabled", (builder, value) -> builder.setStaleConnectionCheckEnabled(((Boolean)value).booleanValue())),
    TARGET_PREFERRED_AUTH_SCHEMES("target-preferred-auth-schemes", (builder, value) -> builder.setTargetPreferredAuthSchemes((Collection)value));

    private String name;
    private BiConsumer<RequestConfig.Builder, Object> consumer;

    private RequestConfigOption(String name, BiConsumer<RequestConfig.Builder, Object> consumer) {
        this.name = name;
        this.consumer = consumer;
    }

    public String getName() {
        return this.name;
    }

    public void apply(RequestConfig.Builder configBuilder, Object value) {
        this.consumer.accept(configBuilder, value);
    }
}

