/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.impl.interpreter;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.context.Context;
import org.camunda.feel.context.FunctionProvider;
import org.camunda.feel.package$;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValError;
import org.camunda.feel.syntaxtree.ValFunction;
import org.camunda.feel.syntaxtree.ValFunction$;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValLocalTime;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValNumber$;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.syntaxtree.ValString$;
import org.camunda.feel.syntaxtree.ValTime;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;
import org.camunda.feel.syntaxtree.ZonedTime;
import org.camunda.feel.syntaxtree.ZonedTime$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqFactory;
import scala.collection.SeqFactory$UnapplySeqWrapper$;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.Numeric$BigDecimalIsFractional$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class BuiltinFunctions$
implements FunctionProvider {
    public static final BuiltinFunctions$ MODULE$ = new BuiltinFunctions$();
    private static Pattern dateTimeOffsetZoneIdPattern;
    private static final Map<String, List<ValFunction>> functions;
    private static volatile boolean bitmap$0;

    static {
        FunctionProvider.$init$(MODULE$);
        functions = (Map)((MapOps)((MapOps)((MapOps)((MapOps)MODULE$.conversionFunctions().$plus$plus(MODULE$.booleanFunctions())).$plus$plus(MODULE$.stringFunctions())).$plus$plus(MODULE$.listFunctions())).$plus$plus(MODULE$.numericFunctions())).$plus$plus(MODULE$.contextFunctions());
    }

    @Override
    public Map<String, List<ValFunction>> getFunctions() {
        return FunctionProvider.getFunctions$(this);
    }

    @Override
    public List<ValFunction> getFunctions(String name) {
        return (List)this.functions().getOrElse(name, (Function0<List> & Serializable)() -> List$.MODULE$.empty());
    }

    @Override
    public Iterable<String> functionNames() {
        return this.functions().keys();
    }

    public Map<String, List<ValFunction>> functions() {
        return functions;
    }

    private Map<String, List<ValFunction>> conversionFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date"), new $colon$colon<Nothing$>((Nothing$)((Object)this.dateFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.dateFunction3()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("date and time"), new $colon$colon<Nothing$>((Nothing$)((Object)this.dateTime()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.dateTime2()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("time"), new $colon$colon<Nothing$>((Nothing$)((Object)this.timeFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.timeFunction3()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.timeFunction4()), Nil$.MODULE$)))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("number"), new $colon$colon<Nothing$>((Nothing$)((Object)this.numberFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.numberFunction2()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.numberFunction3()), Nil$.MODULE$)))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string"), new $colon$colon<Nothing$>((Nothing$)((Object)this.stringFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("duration"), new $colon$colon<Nothing$>((Nothing$)((Object)this.durationFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("years and months duration"), new $colon$colon<Nothing$>((Nothing$)((Object)this.durationFunction2()), Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> booleanFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("not"), new $colon$colon<Nothing$>((Nothing$)((Object)this.notFunction()), Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> stringFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring"), new $colon$colon<Nothing$>((Nothing$)((Object)this.substringFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.substringFunction3()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("string length"), new $colon$colon<Nothing$>((Nothing$)((Object)this.stringLengthFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("upper case"), new $colon$colon<Nothing$>((Nothing$)((Object)this.upperCaseFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("lower case"), new $colon$colon<Nothing$>((Nothing$)((Object)this.lowerCaseFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring before"), new $colon$colon<Nothing$>((Nothing$)((Object)this.substringBeforeFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("substring after"), new $colon$colon<Nothing$>((Nothing$)((Object)this.substringAfterFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("replace"), new $colon$colon<Nothing$>((Nothing$)((Object)this.replaceFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.replaceFunction4()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("contains"), new $colon$colon<Nothing$>((Nothing$)((Object)this.containsFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("starts with"), new $colon$colon<Nothing$>((Nothing$)((Object)this.startsWithFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ends with"), new $colon$colon<Nothing$>((Nothing$)((Object)this.endsWithFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("matches"), new $colon$colon<Nothing$>((Nothing$)((Object)this.matchesFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.matchesFunction3()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("split"), new $colon$colon<Nothing$>((Nothing$)((Object)this.splitFunction()), Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> listFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("list contains"), new $colon$colon<Nothing$>((Nothing$)((Object)this.listContainsFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("count"), new $colon$colon<Nothing$>((Nothing$)((Object)this.countFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("min"), new $colon$colon<Nothing$>((Nothing$)((Object)this.minFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("max"), new $colon$colon<Nothing$>((Nothing$)((Object)this.maxFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sum"), new $colon$colon<Nothing$>((Nothing$)((Object)this.sumFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("product"), new $colon$colon<Nothing$>((Nothing$)((Object)this.productFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("mean"), new $colon$colon<Nothing$>((Nothing$)((Object)this.meanFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("median"), new $colon$colon<Nothing$>((Nothing$)((Object)this.medianFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("stddev"), new $colon$colon<Nothing$>((Nothing$)((Object)this.stddevFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("mode"), new $colon$colon<Nothing$>((Nothing$)((Object)this.modeFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("and"), new $colon$colon<Nothing$>((Nothing$)((Object)this.andFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("all"), new $colon$colon<Nothing$>((Nothing$)((Object)this.andFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("or"), new $colon$colon<Nothing$>((Nothing$)((Object)this.orFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("any"), new $colon$colon<Nothing$>((Nothing$)((Object)this.orFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sublist"), new $colon$colon<Nothing$>((Nothing$)((Object)this.sublistFunction()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.sublistFunction3()), Nil$.MODULE$))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("append"), new $colon$colon<Nothing$>((Nothing$)((Object)this.appendFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("concatenate"), new $colon$colon<Nothing$>((Nothing$)((Object)this.concatenateFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("insert before"), new $colon$colon<Nothing$>((Nothing$)((Object)this.insertBeforeFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("remove"), new $colon$colon<Nothing$>((Nothing$)((Object)this.removeFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("reverse"), new $colon$colon<Nothing$>((Nothing$)((Object)this.reverseFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("index of"), new $colon$colon<Nothing$>((Nothing$)((Object)this.indexOfFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("union"), new $colon$colon<Nothing$>((Nothing$)((Object)this.unionFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("distinct values"), new $colon$colon<Nothing$>((Nothing$)((Object)this.distinctValuesFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("flatten"), new $colon$colon<Nothing$>((Nothing$)((Object)this.flattenFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sort"), new $colon$colon<Nothing$>((Nothing$)((Object)this.sortFunction()), Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> numericFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("decimal"), new $colon$colon<Nothing$>((Nothing$)((Object)this.decimalFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("floor"), new $colon$colon<Nothing$>((Nothing$)((Object)this.floorFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("ceiling"), new $colon$colon<Nothing$>((Nothing$)((Object)this.ceilingFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("abs"), new $colon$colon<Nothing$>((Nothing$)((Object)this.absFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("modulo"), new $colon$colon<Nothing$>((Nothing$)((Object)this.moduloFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("sqrt"), new $colon$colon<Nothing$>((Nothing$)((Object)this.sqrtFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("log"), new $colon$colon<Nothing$>((Nothing$)((Object)this.logFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("exp"), new $colon$colon<Nothing$>((Nothing$)((Object)this.expFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("odd"), new $colon$colon<Nothing$>((Nothing$)((Object)this.oddFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("even"), new $colon$colon<Nothing$>((Nothing$)((Object)this.evenFunction()), Nil$.MODULE$))}));
    }

    private Map<String, List<ValFunction>> contextFunctions() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("get entries"), new $colon$colon<Nothing$>((Nothing$)((Object)this.getEntriesFunction()), Nil$.MODULE$)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("get value"), new $colon$colon<Nothing$>((Nothing$)((Object)this.getValueFunction()), Nil$.MODULE$))}));
    }

    private Val error(List<Val> e) {
        Val val;
        List<Val> list = e;
        if (list.exists((Function1<Val, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$error$1(x$1)))) {
            val = (ValError)((AbstractIterable)list.filter((Function1<Val, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$error$2(x$2)))).head();
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(39).append("Suppressed failure: illegal arguments: ").append(list).toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val parseDate(String d) {
        Val val;
        if (package$.MODULE$.isValidDate(d)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValDate> & Serializable)() -> new ValDate(package$.MODULE$.stringToDate(d))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse date from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse date from '").append(d).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val parseTime(String t) {
        return package$.MODULE$.isOffsetTime(t) ? (Val)Try$.MODULE$.apply((Function0<ValTime> & Serializable)() -> new ValTime(package$.MODULE$.stringToTime(t))).getOrElse((Function0<ValNull$> & Serializable)() -> {
            package$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to parse time from '").append(t).append("'").toString());
            return ValNull$.MODULE$;
        }) : (Val)Try$.MODULE$.apply((Function0<ValLocalTime> & Serializable)() -> new ValLocalTime(package$.MODULE$.stringToLocalTime(t))).getOrElse((Function0<ValNull$> & Serializable)() -> {
            package$.MODULE$.logger().warn(new StringBuilder(34).append("Failed to parse local-time from '").append(t).append("'").toString());
            return ValNull$.MODULE$;
        });
    }

    private Val parseDateTime(String dt) {
        Val val;
        if (package$.MODULE$.isValidDate(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValLocalDateTime> & Serializable)() -> new ValLocalDateTime(package$.MODULE$.stringToDate(dt).atTime(0, 0))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(35).append("Failed to parse date(-time) from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isOffsetDateTime(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValDateTime> & Serializable)() -> new ValDateTime(package$.MODULE$.stringToDateTime(dt))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(33).append("Failed to parse date-time from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isLocalDateTime(dt)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValLocalDateTime> & Serializable)() -> new ValLocalDateTime(package$.MODULE$.stringToLocalDateTime(dt))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(39).append("Failed to parse local-date-time from '").append(dt).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(33).append("Failed to parse date-time from '").append(dt).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    private Val parseDuration(String d) {
        Val val;
        if (package$.MODULE$.isYearMonthDuration(d)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValYearMonthDuration> & Serializable)() -> new ValYearMonthDuration(package$.MODULE$.stringToYearMonthDuration(d).normalized())).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(43).append("Failed to parse year-month-duration from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else if (package$.MODULE$.isDayTimeDuration(d)) {
            val = (Val)Try$.MODULE$.apply((Function0<ValDayTimeDuration> & Serializable)() -> new ValDayTimeDuration(package$.MODULE$.stringToDayTimeDuration(d))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                package$.MODULE$.logger().warn(new StringBuilder(41).append("Failed to parse day-time-duration from '").append(d).append("'").toString());
                return ValNull$.MODULE$;
            });
        } else {
            package$.MODULE$.logger().warn(new StringBuilder(32).append("Failed to parse duration from '").append(d).append("'").toString());
            val = ValNull$.MODULE$;
        }
        return val;
    }

    public ValFunction dateFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$3 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            SeqOps seqOps3;
            Val val4;
            Val val5;
            SeqOps seqOps4;
            List list = x$3;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValString) {
                ValString valString = (ValString)val5;
                String from = valString.value();
                val4 = MODULE$.parseDate(from);
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val3;
                LocalDateTime from = valLocalDateTime.value();
                val4 = new ValDate(from.toLocalDate());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val2;
                ZonedDateTime from = valDateTime.value();
                val4 = new ValDate(from.toLocalDate());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDate) {
                ValDate valDate = (ValDate)val;
                LocalDate from = valDate.value();
                val4 = new ValDate(from);
            } else {
                val4 = MODULE$.error(list);
            }
            return val4;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"year"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"month"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"day"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$4 -> {
            void var1_14;
            SeqOps seqOps;
            List list = x$4;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal year = valNumber.value();
                    if (val2 instanceof ValNumber) {
                        ValNumber valNumber2 = (ValNumber)val2;
                        BigDecimal month = valNumber2.value();
                        if (val3 instanceof ValNumber) {
                            ValNumber valNumber3 = (ValNumber)val3;
                            BigDecimal day = valNumber3.value();
                            Object u = Try$.MODULE$.apply((Function0<ValDate> & Serializable)() -> new ValDate(LocalDate.of(year.intValue(), month.intValue(), day.intValue()))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                                package$.MODULE$.logger().warn(new StringBuilder(46).append("Failed to parse date from: year=").append(year).append(", month=").append(month).append(", day=").append(day).toString());
                                return ValNull$.MODULE$;
                            });
                            return var1_14;
                        }
                    }
                }
            }
            Val val = MODULE$.error(list);
            return var1_14;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$5 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$5;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = MODULE$.parseDateTime(from);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction dateTime2() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"date"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"time"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$6 -> {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            SeqOps seqOps4;
            SeqOps seqOps5;
            List list = x$6;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val2 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val2;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(date.atTime(time));
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate date = valDate.value();
                    if (val3 instanceof ValTime) {
                        ValTime valTime = (ValTime)val3;
                        ZonedTime time = valTime.value();
                        return new ValDateTime(time.withDate(date));
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val4 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val4;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Val val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime dateTime = valLocalDateTime.value();
                    if (val5 instanceof ValTime) {
                        ValTime valTime = (ValTime)val5;
                        ZonedTime time = valTime.value();
                        return new ValDateTime(time.withDate(dateTime.toLocalDate()));
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val6 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime dateTime = valDateTime.value();
                    if (val6 instanceof ValLocalTime) {
                        ValLocalTime valLocalTime = (ValLocalTime)val6;
                        LocalTime time = valLocalTime.value();
                        return new ValLocalDateTime(dateTime.toLocalDate().atTime(time));
                    }
                }
            }
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps6 = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
            Val val7 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
            if (!(val instanceof ValDateTime)) return MODULE$.error(list);
            ValDateTime valDateTime = (ValDateTime)val;
            ZonedDateTime dateTime = valDateTime.value();
            if (!(val7 instanceof ValTime)) return MODULE$.error(list);
            ValTime valTime = (ValTime)val7;
            ZonedTime time = valTime.value();
            return new ValDateTime(time.withDate(dateTime.toLocalDate()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$7 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            Val val4;
            SeqOps seqOps3;
            List list = x$7;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValString) {
                ValString valString = (ValString)val4;
                String from = valString.value();
                val3 = MODULE$.parseTime(from);
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val2;
                LocalDateTime from = valLocalDateTime.value();
                val3 = new ValLocalTime(from.toLocalTime());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val;
                ZonedDateTime from = valDateTime.value();
                val3 = new ValTime(ZonedTime$.MODULE$.of(from));
            } else {
                Val val5;
                SeqOps seqOps4;
                val3 = list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValDate ? new ValTime(ZonedTime$.MODULE$.of(LocalTime.MIDNIGHT, ZoneOffset.UTC)) : MODULE$.error(list);
            }
            return val3;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"hour"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"minute"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"second"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$8 -> {
            void var1_14;
            SeqOps seqOps;
            List list = x$8;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal hour = valNumber.value();
                    if (val2 instanceof ValNumber) {
                        ValNumber valNumber2 = (ValNumber)val2;
                        BigDecimal minute = valNumber2.value();
                        if (val3 instanceof ValNumber) {
                            ValNumber valNumber3 = (ValNumber)val3;
                            BigDecimal second = valNumber3.value();
                            Object u = Try$.MODULE$.apply((Function0<ValLocalTime> & Serializable)() -> {
                                int nanos = second.bigDecimal().remainder(java.math.BigDecimal.ONE).movePointRight(9).intValue();
                                return new ValLocalTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), nanos));
                            }).getOrElse((Function0<ValNull$> & Serializable)() -> {
                                package$.MODULE$.logger().warn(new StringBuilder(56).append("Failed to parse local-time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).toString());
                                return ValNull$.MODULE$;
                            });
                            return var1_14;
                        }
                    }
                }
            }
            Val val = MODULE$.error(list);
            return var1_14;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction timeFunction4() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"hour"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"minute"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"second"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"offset"), Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$9 -> {
            SeqOps seqOps;
            void var1_18;
            SeqOps seqOps2;
            List list = x$9;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 4) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
                Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3);
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal hour = valNumber.value();
                    if (val2 instanceof ValNumber) {
                        ValNumber valNumber2 = (ValNumber)val2;
                        BigDecimal minute = valNumber2.value();
                        if (val3 instanceof ValNumber) {
                            ValNumber valNumber3 = (ValNumber)val3;
                            BigDecimal second = valNumber3.value();
                            if (val4 instanceof ValDayTimeDuration) {
                                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val4;
                                Duration offset = valDayTimeDuration.value();
                                Object u = Try$.MODULE$.apply((Function0<ValTime> & Serializable)() -> {
                                    int nanos = second.bigDecimal().remainder(java.math.BigDecimal.ONE).movePointRight(9).intValue();
                                    LocalTime localTime = LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), nanos);
                                    ZoneOffset zonedOffset = ZoneOffset.ofTotalSeconds((int)offset.getSeconds());
                                    return new ValTime(ZonedTime$.MODULE$.of(localTime, zonedOffset));
                                }).getOrElse((Function0<ValNull$> & Serializable)() -> {
                                    package$.MODULE$.logger().warn(new StringBuilder(59).append("Failed to parse time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).append(", offset=").append(offset).toString());
                                    return ValNull$.MODULE$;
                                });
                                return var1_18;
                            }
                        }
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val6 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                Val val7 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
                if (val instanceof ValNumber) {
                    ValNumber valNumber = (ValNumber)val;
                    BigDecimal hour = valNumber.value();
                    if (val5 instanceof ValNumber) {
                        ValNumber valNumber4 = (ValNumber)val5;
                        BigDecimal minute = valNumber4.value();
                        if (val6 instanceof ValNumber) {
                            ValNumber valNumber5 = (ValNumber)val6;
                            BigDecimal second = valNumber5.value();
                            if (ValNull$.MODULE$.equals(val7)) {
                                Object u = Try$.MODULE$.apply((Function0<ValLocalTime> & Serializable)() -> new ValLocalTime(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue()))).getOrElse((Function0<ValNull$> & Serializable)() -> {
                                    package$.MODULE$.logger().warn(new StringBuilder(56).append("Failed to parse local-time from: hour=").append(hour).append(", minute=").append(minute).append(", second=").append(second).toString());
                                    return ValNull$.MODULE$;
                                });
                                return var1_18;
                            }
                        }
                    }
                }
            }
            Val val = MODULE$.error(list);
            return var1_18;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$10 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$10;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = new ValNumber(package$.MODULE$.stringToNumber(from));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction2() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"grouping separator"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$11 -> {
            SeqOps seqOps;
            List list = x$11;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValString) {
                    ValString valString;
                    String grouping;
                    ValString valString2 = (ValString)val;
                    String from = valString2.value();
                    if (val2 instanceof ValString && MODULE$.isValidGroupingSeparator(grouping = (valString = (ValString)val2).value())) {
                        return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "")));
                    }
                }
            }
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            return new ValError("illegal argument for grouping. Must be one of ' ', ',' or '.'");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction numberFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"grouping separator"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"decimal separator"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$12 -> {
            SeqOps seqOps;
            List list = x$12;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
                if (val instanceof ValString) {
                    ValString valString = (ValString)val;
                    String from = valString.value();
                    if (val2 instanceof ValString) {
                        ValString valString2 = (ValString)val2;
                        String grouping = valString2.value();
                        if (val3 instanceof ValString) {
                            ValString valString3 = (ValString)val3;
                            String decimal = valString3.value();
                            if (MODULE$.isValidGroupingSeparator(grouping) && MODULE$.isValidDecimalSeparator(decimal)) {
                                String string = grouping;
                                String string2 = decimal;
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return new ValNumber(package$.MODULE$.stringToNumber(from.replace(grouping, "").replace(decimal, ".")));
                                }
                            }
                        }
                    }
                }
            }
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            Val val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            if (!(val4 instanceof ValString)) return MODULE$.error(list);
            if (!(val5 instanceof ValString)) return MODULE$.error(list);
            return new ValError("illegal arguments for grouping or decimal. Must be one of ' ' (grouping only), ',' or '.'");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidGroupingSeparator(String separator) {
        String string = separator;
        String string2 = " ";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ",";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = separator;
        String string6 = ".";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDecimalSeparator(String separator) {
        String string = separator;
        String string2 = ",";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = separator;
        String string4 = ".";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private Pattern dateTimeOffsetZoneIdPattern$lzycompute() {
        BuiltinFunctions$ builtinFunctions$ = this;
        synchronized (builtinFunctions$) {
            if (!bitmap$0) {
                dateTimeOffsetZoneIdPattern = Pattern.compile("(.*)([+-]\\d{2}:\\d{2}|Z)(@.*)");
                bitmap$0 = true;
            }
        }
        return dateTimeOffsetZoneIdPattern;
    }

    public Pattern dateTimeOffsetZoneIdPattern() {
        return !bitmap$0 ? this.dateTimeOffsetZoneIdPattern$lzycompute() : dateTimeOffsetZoneIdPattern;
    }

    public ValFunction stringFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$13 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            SeqOps seqOps2;
            Val val3;
            SeqOps seqOps3;
            Val val4;
            SeqOps seqOps4;
            Val val5;
            SeqOps seqOps5;
            Val val6;
            SeqOps seqOps6;
            Val val7;
            SeqOps seqOps7;
            Val val8;
            SeqOps seqOps8;
            Val val9;
            SeqOps seqOps9;
            Val val10;
            Val val11;
            SeqOps seqOps10;
            List list = x$13;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps10 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps10)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 1) == 0 && (val11 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 0)) instanceof ValString) {
                ValString valString = (ValString)val11;
                String from = valString.value();
                val10 = new ValString(from);
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1) == 0 && (val9 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0)) instanceof ValBoolean) {
                ValBoolean valBoolean = (ValBoolean)val9;
                boolean from = valBoolean.value();
                val10 = new ValString(((Object)BoxesRunTime.boxToBoolean(from)).toString());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1) == 0 && (val8 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val8;
                BigDecimal from = valNumber.value();
                val10 = new ValString(from.toString());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1) == 0 && (val7 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0)) instanceof ValDate) {
                ValDate valDate = (ValDate)val7;
                LocalDate from = valDate.value();
                val10 = new ValString(from.format(package$.MODULE$.dateFormatter()));
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1) == 0 && (val6 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0)) instanceof ValLocalTime) {
                ValLocalTime valLocalTime = (ValLocalTime)val6;
                LocalTime from = valLocalTime.value();
                val10 = new ValString(from.format(package$.MODULE$.localTimeFormatter()));
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1) == 0 && (val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0)) instanceof ValTime) {
                ValTime valTime = (ValTime)val5;
                ZonedTime from = valTime.value();
                val10 = new ValString(from.format());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1) == 0 && (val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0)) instanceof ValLocalDateTime) {
                ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val4;
                LocalDateTime from = valLocalDateTime.value();
                val10 = new ValString(from.format(package$.MODULE$.localDateTimeFormatter()));
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) instanceof ValDateTime) {
                ValDateTime valDateTime = (ValDateTime)val3;
                ZonedDateTime from = valDateTime.value();
                String formattedDateTime = from.format(package$.MODULE$.dateTimeFormatter());
                String dateTimeWithOffsetOrZoneId = MODULE$.dateTimeOffsetZoneIdPattern().matcher(formattedDateTime).replaceAll("$1$3");
                val10 = new ValString(dateTimeWithOffsetOrZoneId);
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValYearMonthDuration) {
                ValYearMonthDuration valYearMonthDuration = (ValYearMonthDuration)val2;
                Period from = valYearMonthDuration.value();
                val10 = new ValString(from.toString());
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValDayTimeDuration) {
                ValDayTimeDuration valDayTimeDuration = (ValDayTimeDuration)val;
                Duration from = valDayTimeDuration.value();
                val10 = new ValString(from.toString());
            } else {
                val10 = MODULE$.error(list);
            }
            return val10;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$14 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$14;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String from = valString.value();
                val = MODULE$.parseDuration(from);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction durationFunction2() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"from"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"to"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$15 -> {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            SeqOps seqOps4;
            SeqOps seqOps5;
            SeqOps seqOps6;
            SeqOps seqOps7;
            SeqOps seqOps8;
            List list = x$15;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val2 instanceof ValDate) {
                        ValDate valDate2 = (ValDate)val2;
                        LocalDate to = valDate2.value();
                        return new ValYearMonthDuration(Period.between(from, to).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0);
                Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime from = valLocalDateTime.value();
                    if (val3 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime2 = (ValLocalDateTime)val3;
                        LocalDateTime to = valLocalDateTime2.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
                Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val4 instanceof ValDateTime) {
                        ValDateTime valDateTime2 = (ValDateTime)val4;
                        ZonedDateTime to = valDateTime2.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0);
                Val val5 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val5 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val5;
                        LocalDateTime to = valLocalDateTime.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
                Val val6 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
                if (val instanceof ValLocalDateTime) {
                    ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
                    LocalDateTime from = valLocalDateTime.value();
                    if (val6 instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val6;
                        ZonedDateTime to = valDateTime.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
                Val val7 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val7 instanceof ValDateTime) {
                        ValDateTime valDateTime = (ValDateTime)val7;
                        ZonedDateTime to = valDateTime.value();
                        return new ValYearMonthDuration(Period.between(from, to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Val val8 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (val instanceof ValDate) {
                    ValDate valDate = (ValDate)val;
                    LocalDate from = valDate.value();
                    if (val8 instanceof ValLocalDateTime) {
                        ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val8;
                        LocalDateTime to = valLocalDateTime.value();
                        return new ValYearMonthDuration(Period.between(from, to.toLocalDate()).withDays(0).normalized());
                    }
                }
            }
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val9 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValDateTime) {
                    ValDateTime valDateTime = (ValDateTime)val;
                    ZonedDateTime from = valDateTime.value();
                    if (val9 instanceof ValDate) {
                        ValDate valDate = (ValDate)val9;
                        LocalDate to = valDate.value();
                        return new ValYearMonthDuration(Period.between(from.toLocalDate(), to).withDays(0).normalized());
                    }
                }
            }
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps9 = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0);
            Val val10 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1);
            if (!(val instanceof ValLocalDateTime)) return MODULE$.error(list);
            ValLocalDateTime valLocalDateTime = (ValLocalDateTime)val;
            LocalDateTime from = valLocalDateTime.value();
            if (!(val10 instanceof ValDate)) return MODULE$.error(list);
            ValDate valDate = (ValDate)val10;
            LocalDate to = valDate.value();
            return new ValYearMonthDuration(Period.between(from.toLocalDate(), to).withDays(0).normalized());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction notFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"negand"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$16 -> {
            Val other;
            SeqOps seqOps;
            ValBoolean valBoolean;
            boolean negand;
            Val val;
            SeqOps seqOps2;
            List list = x$16;
            Val val2 = list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValBoolean ? new ValBoolean(!(negand = (valBoolean = (ValBoolean)val).value())) : (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (other = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null ? ValNull$.MODULE$ : ValNull$.MODULE$);
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"start position"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$17 -> {
            List list = x$17;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue())));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"start position"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"length"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$18 -> {
            List list = x$18;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValString(string.substring(MODULE$.stringIndex(string, start.intValue()), MODULE$.stringIndex(string, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private int stringIndex(String string, int index) {
        return index > 0 ? index - 1 : string.length() + index;
    }

    public ValFunction stringLengthFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$19 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$19;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(string.length()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction upperCaseFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$20 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$20;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toUpperCase());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction lowerCaseFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$21 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$21;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValString) {
                ValString valString = (ValString)val2;
                String string = valString.value();
                val = new ValString(string.toLowerCase());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringBeforeFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$22 -> {
            List list = x$22;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index > 0 ? new ValString(string.substring(0, index)) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction substringAfterFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$23 -> {
            List list = x$23;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            int index = string.indexOf(m);
            return index >= 0 ? new ValString(string.substring(index + m.length())) : new ValString("");
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"input"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"pattern"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"replacement"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$24 -> {
            List list = x$24;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            return new ValString(input.replaceAll(pattern, replacement));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction replaceFunction4() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"input"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"pattern"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"replacement"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"flags"), Nil$.MODULE$)))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$25 -> {
            List list = x$25;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String replacement = valString3.value();
            if (!(val4 instanceof ValString)) return MODULE$.error(list);
            ValString valString4 = (ValString)val4;
            String flags = valString4.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValString(m.replaceAll(replacement));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private int patternFlags(String flags) {
        void var2_2;
        block3: {
            int f = 0;
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            if (flags.contains("i")) {
                f |= 2;
            }
            if (!flags.contains("x")) break block3;
            f |= 4;
        }
        return (int)var2_2;
    }

    public ValFunction containsFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$26 -> {
            List list = x$26;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.contains(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction startsWithFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$27 -> {
            List list = x$27;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.startsWith(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction endsWithFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$28 -> {
            List list = x$28;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String m = valString2.value();
            return new ValBoolean(string.endsWith(m));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"input"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"pattern"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$29 -> {
            List list = x$29;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction matchesFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"input"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"pattern"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"flags"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$30 -> {
            List list = x$30;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String input = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String pattern = valString2.value();
            if (!(val3 instanceof ValString)) return MODULE$.error(list);
            ValString valString3 = (ValString)val3;
            String flags = valString3.value();
            Pattern p = Pattern.compile(pattern, MODULE$.patternFlags(flags));
            Matcher m = p.matcher(input);
            return new ValBoolean(m.find());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction splitFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"string"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"delimiter"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$31 -> {
            List list = x$31;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValString)) return MODULE$.error(list);
            ValString valString = (ValString)val;
            String string = valString.value();
            if (!(val2 instanceof ValString)) return MODULE$.error(list);
            ValString valString2 = (ValString)val2;
            String delimiter = valString2.value();
            Pattern p = Pattern.compile(delimiter);
            String[] r = p.split(string, -1);
            return new ValList(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(r), ValString$.MODULE$, ClassTag$.MODULE$.apply(ValString.class))).toList());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction listContainsFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"element"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$32 -> {
            List list = x$32;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val element = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            return new ValBoolean(list2.contains(element));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction countFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$33 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$33;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(list2.size()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction minFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$34 -> {
            Val val;
            Val l;
            SeqOps seqOps;
            List list = x$34;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (l = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValNull$ valNull$;
                ValList valList = (ValList)l;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (((Object)Nil$.MODULE$).equals(list3)) {
                    valNull$ = ValNull$.MODULE$;
                } else if (valList.isComparable()) {
                    valNull$ = list2.min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else {
                    package$.MODULE$.logger().warn(new StringBuilder(18).append(valList).append(" is not comparable").toString());
                    valNull$ = ValNull$.MODULE$;
                }
                val = valNull$;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    public ValFunction maxFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$35 -> {
            Val val;
            Val l;
            SeqOps seqOps;
            List list = x$35;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (l = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValNull$ valNull$;
                ValList valList = (ValList)l;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                if (((Object)Nil$.MODULE$).equals(list3)) {
                    valNull$ = ValNull$.MODULE$;
                } else if (valList.isComparable()) {
                    valNull$ = list2.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else {
                    package$.MODULE$.logger().warn(new StringBuilder(18).append(valList).append(" is not comparable").toString());
                    valNull$ = ValNull$.MODULE$;
                }
                val = valNull$;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    public ValFunction sumFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$36 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$36;
            if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable)numbers -> new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$)));
            } else {
                val2 = MODULE$.error(list2);
            }
            return val2;
        }, true);
    }

    public ValFunction productFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$37 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$37;
            if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable)numbers -> new ValNumber(numbers.product(Numeric$BigDecimalIsFractional$.MODULE$)));
            } else {
                val2 = MODULE$.error(list2);
            }
            return val2;
        }, true);
    }

    public ValFunction meanFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$38 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$38;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                List<Val> list3 = list2;
                Val val3 = ((Object)Nil$.MODULE$).equals(list3) ? ValNull$.MODULE$ : MODULE$.withListOfNumbers(list2, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable)numbers -> new ValNumber(numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$).$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size()))));
                val = val3;
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    public ValFunction medianFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$39 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$39;
            if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1<List, Val> & Serializable)numbers -> {
                    ValNumber valNumber;
                    List sortedList = (List)numbers.sorted((Ordering)Ordering$BigDecimal$.MODULE$);
                    if (list3.size() % 2 == 1) {
                        valNumber = new ValNumber((BigDecimal)sortedList.apply(list3.size() / 2));
                    } else {
                        int i = list3.size() / 2;
                        BigDecimal x = (BigDecimal)sortedList.apply(i - 1);
                        BigDecimal y = (BigDecimal)sortedList.apply(i);
                        valNumber = new ValNumber(x.$plus(y).$div(BigDecimal$.MODULE$.int2bigDecimal(2)));
                    }
                    return valNumber;
                });
            } else {
                val2 = MODULE$.error(list2);
            }
            return val2;
        }, true);
    }

    public ValFunction stddevFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$40 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$40;
            if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = ValNull$.MODULE$;
            } else if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1<List, ValNumber> & Serializable)numbers -> {
                    BigDecimal sum = numbers.sum(Numeric$BigDecimalIsFractional$.MODULE$);
                    BigDecimal mean = sum.$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size()));
                    BigDecimal bigDecimal = BigDecimal$.MODULE$.int2bigDecimal(0);
                    BigDecimal d = numbers.$div$colon(bigDecimal, (Function2<BigDecimal, BigDecimal, BigDecimal> & Serializable)(x0$1, x1$1) -> {
                        Tuple2<BigDecimal, BigDecimal> tuple2 = new Tuple2<BigDecimal, BigDecimal>((BigDecimal)x0$1, (BigDecimal)x1$1);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        BigDecimal dev = tuple2._1();
                        BigDecimal n = tuple2._2();
                        BigDecimal bigDecimal = dev.$plus(n.$minus(mean).pow(2));
                        return bigDecimal;
                    });
                    double stddev = Math.sqrt(d.$div(BigDecimal$.MODULE$.int2bigDecimal(numbers.size() - 1)).toDouble());
                    return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(stddev));
                });
            } else {
                val2 = MODULE$.error(list2);
            }
            return val2;
        }, true);
    }

    public ValFunction modeFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$41 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValList valList;
            List<Val> list;
            Val val3;
            SeqOps seqOps2;
            List list2 = x$41;
            if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValList && (list = (valList = (ValList)val3).items()).isEmpty()) {
                val2 = new ValList((List<Val>)List$.MODULE$.empty());
            } else if (list2 != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList2 = (ValList)val;
                List<Val> list3 = valList2.items();
                val2 = MODULE$.withListOfNumbers(list3, (Function1<List<BigDecimal>, Val>)(Function1<List, ValList> & Serializable)numbers -> {
                    Object sortedList = ((List)numbers.groupBy((Function1<BigDecimal, BigDecimal> & Serializable)n -> n).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        BigDecimal n = (BigDecimal)tuple2._1();
                        List ns = (List)tuple2._2();
                        Tuple2<BigDecimal, Integer> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), BoxesRunTime.boxToInteger(ns.size()));
                        return tuple22;
                    }).toList().sortBy((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToInteger(BuiltinFunctions$.$anonfun$modeFunction$5(x0$2)), (Ordering)Ordering$Int$.MODULE$)).reverse();
                    int maxCount = ((Tuple2)((AbstractIterable)sortedList).head())._2$mcI$sp();
                    List modeElements = (List)((List)((List)((List)sortedList).takeWhile((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$modeFunction$6(maxCount, x0$3)))).map((Function1<Tuple2, BigDecimal> & Serializable)x$42 -> (BigDecimal)x$42._1())).sorted((Ordering)Ordering$BigDecimal$.MODULE$);
                    return new ValList((List<Val>)modeElements.map((Function1)ValNumber$.MODULE$));
                });
            } else {
                val2 = MODULE$.error(list2);
            }
            return val2;
        }, true);
    }

    public ValFunction andFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$43 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$43;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.all(list2);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    private Val all(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List<Val> list;
            block5: {
                Val val;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List<Val> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            valBoolean = new ValBoolean(true);
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Val x = (Val)$colon$colon.head();
                        xs2 = $colon$colon.next$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val2 = x;
                        if (val2 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val2;
                            boolean bl4 = valBoolean3.value();
                            if (!bl4) {
                                val = new ValBoolean(false);
                                break block6;
                            }
                        }
                        if (!bl3 || !(bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val3 = this.all(xs2);
                    Val val4 = val3 instanceof ValBoolean && false == (bl = (valBoolean2 = (ValBoolean)val3).value()) ? new ValBoolean(false) : ValNull$.MODULE$;
                    val = val4;
                }
                valBoolean = val;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction orFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$44 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$44;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = MODULE$.atLeastOne(list2);
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    private Val atLeastOne(List<Val> xs) {
        ValBoolean valBoolean;
        block4: {
            List<Val> list;
            block5: {
                Val val;
                block6: {
                    ValBoolean valBoolean2;
                    boolean bl;
                    List<Val> xs2;
                    while (true) {
                        boolean bl2;
                        if (((Object)Nil$.MODULE$).equals(list = xs)) {
                            valBoolean = new ValBoolean(false);
                            break block4;
                        }
                        if (!(list instanceof $colon$colon)) break block5;
                        $colon$colon $colon$colon = ($colon$colon)list;
                        Val x = (Val)$colon$colon.head();
                        xs2 = $colon$colon.next$access$1();
                        boolean bl3 = false;
                        ValBoolean valBoolean3 = null;
                        Val val2 = x;
                        if (val2 instanceof ValBoolean) {
                            bl3 = true;
                            valBoolean3 = (ValBoolean)val2;
                            boolean bl4 = valBoolean3.value();
                            if (bl4) {
                                val = new ValBoolean(true);
                                break block6;
                            }
                        }
                        if (!bl3 || (bl2 = valBoolean3.value())) break;
                        xs = xs2;
                    }
                    Val val3 = this.atLeastOne(xs2);
                    Val val4 = val3 instanceof ValBoolean && true == (bl = (valBoolean2 = (ValBoolean)val3).value()) ? new ValBoolean(true) : ValNull$.MODULE$;
                    val = val4;
                }
                valBoolean = val;
                break block4;
            }
            throw new MatchError(list);
        }
        return valBoolean;
    }

    public ValFunction sublistFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"start"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$45 -> {
            List list = x$45;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), list2.length()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sublistFunction3() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"start"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"length"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$46 -> {
            List list = x$46;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal start = valNumber.value();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val3;
            BigDecimal length = valNumber2.value();
            return new ValList((List<Val>)list2.slice(MODULE$.listIndex(list2, start.intValue()), MODULE$.listIndex(list2, start.intValue()) + length.intValue()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private int listIndex(List<?> list, int index) {
        return index > 0 ? index - 1 : list.size() + index;
    }

    public ValFunction appendFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"items"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$47 -> {
            List list = x$47;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValList)) return MODULE$.error(list);
            ValList valList2 = (ValList)val2;
            List<Val> items = valList2.items();
            return new ValList((List)list2.$plus$plus(items));
        }, true);
    }

    public ValFunction concatenateFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"lists"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$48 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$48;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList(((List)lists.flatMap((Function1<Val, List> & Serializable)x$49 -> {
                    List list;
                    Val val = x$49;
                    if (val instanceof ValList) {
                        List list2;
                        ValList valList = (ValList)val;
                        list = list2 = valList.items();
                    } else {
                        list = new $colon$colon<Nothing$>((Nothing$)((Object)val), Nil$.MODULE$);
                    }
                    return list;
                })).toList());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    public ValFunction insertBeforeFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"position"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"newItem"), Nil$.MODULE$))), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$50 -> {
            Val val;
            List list = x$50;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) != 0) return MODULE$.error(list);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Val newItem = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
            if (!(val2 instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val2;
            List<Val> list2 = valList.items();
            if (!(val3 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val3;
            BigDecimal position = valNumber.value();
            if (newItem == null) return MODULE$.error(list);
            Val val4 = val = newItem;
            return new ValList((List)((IterableOps)((AbstractIterable)list2.take(MODULE$.listIndex(list2, position.intValue()))).$plus$plus(Nil$.MODULE$.$colon$colon(val4))).$plus$plus(list2.drop(MODULE$.listIndex(list2, position.intValue()))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction removeFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"position"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$51 -> {
            List list = x$51;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val2;
            BigDecimal position = valNumber.value();
            return new ValList((List)((AbstractIterable)list2.take(MODULE$.listIndex(list2, position.intValue()))).$plus$plus((IterableOnce)list2.drop(MODULE$.listIndex(list2, position.intValue() + 1))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction reverseFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$52 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$52;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List<Val>)list2.reverse());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction indexOfFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"match"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$53 -> {
            List list = x$53;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val m = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            ValList valList = (ValList)val;
            List<Val> list2 = valList.items();
            if (m == null) return MODULE$.error(list);
            Val val2 = m;
            return new ValList((List<Val>)MODULE$.indexOfList(list2, val2, MODULE$.indexOfList$default$3(), MODULE$.indexOfList$default$4()).map((Function1<Object, ValNumber> & Serializable)x$54 -> BuiltinFunctions$.$anonfun$indexOfFunction$2(BoxesRunTime.unboxToInt(x$54))));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private List<Object> indexOfList(List<Val> list, Val item, int from, List<Object> indexList) {
        int index;
        while ((index = list.indexOf(item, from)) >= 0) {
            indexList = (List)indexList.$plus$plus((IterableOnce)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{index + 1})));
            from = index + 1;
        }
        return indexList;
    }

    private int indexOfList$default$3() {
        return 0;
    }

    private List<Object> indexOfList$default$4() {
        return Nil$.MODULE$;
    }

    public ValFunction unionFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"lists"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$55 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$55;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> lists = valList.items();
                val = new ValList((List)((List)lists.flatMap((Function1<Val, List> & Serializable)x$56 -> {
                    List list;
                    Val val = x$56;
                    if (val instanceof ValList) {
                        List list2;
                        ValList valList = (ValList)val;
                        list = list2 = valList.items();
                    } else {
                        list = new $colon$colon<Nothing$>((Nothing$)((Object)val), Nil$.MODULE$);
                    }
                    return list;
                })).toList().distinct());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, true);
    }

    public ValFunction distinctValuesFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$57 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$57;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList((List)list2.distinct());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction flattenFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$58 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$58;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValList) {
                ValList valList = (ValList)val2;
                List<Val> list2 = valList.items();
                val = new ValList(MODULE$.flatten(list2));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<Val> flatten(List<Val> list) {
        void var2_8;
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<Val> list2 = list;
        if (((Object)Nil$.MODULE$).equals(list2)) {
            Nil$ nil$ = Nil$.MODULE$;
            return var2_8;
        }
        if (list2 instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list2;
            Val val = (Val)$colon$colon.head();
            List<Val> xs = $colon$colon.next$access$1();
            if (val instanceof ValList) {
                ValList valList = (ValList)val;
                List<Val> l = valList.items();
                List list3 = (List)this.flatten(l).$plus$plus(this.flatten(xs));
                return var2_8;
            }
        }
        if (!bl) throw new MatchError(list2);
        Val x = (Val)$colon$colon.head();
        List<Val> xs = $colon$colon.next$access$1();
        Val val = x;
        List<Val> list4 = this.flatten(xs).$colon$colon(val);
        return var2_8;
    }

    public ValFunction sortFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"list"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"precedes"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$59 -> {
            SeqOps seqOps;
            List list = x$59;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValList) {
                    ValList valList = (ValList)val;
                    List<Val> list2 = valList.items();
                    if (val2 instanceof ValFunction) {
                        ValFunction valFunction = (ValFunction)val2;
                        List<String> params = valFunction.params();
                        Function1<List<Val>, Object> f = valFunction.invoke();
                        if (params.size() == 2) {
                            Val val3;
                            try {
                                val3 = new ValList((List)list2.sortWith((Function2<Val, Val, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$sortFunction$2(f, x0$1, x1$1))));
                                return val3;
                            }
                            catch (Throwable e) {
                                val3 = new ValError(new StringBuilder(46).append("fail to sort list by given precedes function: ").append(e.getMessage()).toString());
                            }
                            return val3;
                        }
                    }
                }
            }
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps2 = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Val val4 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (!(val instanceof ValList)) return MODULE$.error(list);
            if (!(val4 instanceof ValFunction)) return MODULE$.error(list);
            ValFunction valFunction = (ValFunction)val4;
            List<String> params = valFunction.params();
            return new ValError(new StringBuilder(54).append("expect boolean function with 2 arguments, but found '").append(params.size()).append("'").toString());
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction decimalFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"n"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"scale"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$60 -> {
            List list = x$60;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal n = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal scale = valNumber2.value();
            return new ValNumber(n.setScale(scale.intValue(), BigDecimal$RoundingMode$.MODULE$.HALF_EVEN()));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction floorFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"n"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$61 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$61;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction ceilingFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"n"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$62 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$62;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING()));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction absFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$63 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$63;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(n.abs());
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction moduloFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"dividend"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"divisor"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$64 -> {
            List list = x$64;
            if (list == null) return MODULE$.error(list);
            SeqOps seqOps = List$.MODULE$.unapplySeq(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return MODULE$.error(list);
            if (new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return MODULE$.error(list);
            if (SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) return MODULE$.error(list);
            Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (!(val instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber = (ValNumber)val;
            BigDecimal dividend = valNumber.value();
            if (!(val2 instanceof ValNumber)) return MODULE$.error(list);
            ValNumber valNumber2 = (ValNumber)val2;
            BigDecimal divisor = valNumber2.value();
            return new ValNumber(dividend.$percent(divisor));
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction sqrtFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$65 -> {
            Val val;
            SeqOps seqOps;
            Val val2;
            ValNumber valNumber;
            BigDecimal n;
            Val val3;
            SeqOps seqOps2;
            List list = x$65;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (val3 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) instanceof ValNumber && (n = (valNumber = (ValNumber)val3).value()).$less(BigDecimal$.MODULE$.int2bigDecimal(0))) {
                val2 = ValNull$.MODULE$;
            } else if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber2 = (ValNumber)val;
                BigDecimal n2 = valNumber2.value();
                val2 = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.sqrt(n2.toDouble())));
            } else {
                val2 = MODULE$.error(list);
            }
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction logFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$66 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$66;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.log(n.toDouble())));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction expFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$67 -> {
            Val val;
            Val val2;
            SeqOps seqOps;
            List list = x$67;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber) {
                ValNumber valNumber = (ValNumber)val2;
                BigDecimal n = valNumber.value();
                val = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(Math.exp(n.toDouble())));
            } else {
                val = MODULE$.error(list);
            }
            return val;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction oddFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$68 -> {
            ValNumber valNumber;
            BigDecimal n;
            Val val;
            SeqOps seqOps;
            List list = x$68;
            Val val2 = list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber ? new ValBoolean(BoxesRunTime.equalsNumObject((n = (valNumber = (ValNumber)val).value()).$percent(BigDecimal$.MODULE$.int2bigDecimal(2)), BoxesRunTime.boxToInteger(1))) : MODULE$.error(list);
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction evenFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"number"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$69 -> {
            ValNumber valNumber;
            BigDecimal n;
            Val val;
            SeqOps seqOps;
            List list = x$69;
            Val val2 = list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValNumber ? new ValBoolean(BoxesRunTime.equalsNumObject((n = (valNumber = (ValNumber)val).value()).$percent(BigDecimal$.MODULE$.int2bigDecimal(2)), BoxesRunTime.boxToInteger(0))) : MODULE$.error(list);
            return val2;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction getEntriesFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"context"), Nil$.MODULE$), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$70 -> {
            Object object;
            ValContext valContext;
            Context c;
            Val val;
            SeqOps seqOps;
            List list = x$70;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof ValContext && (c = (valContext = (ValContext)val).context()) != null) {
                Context context = c;
                object = ((IterableOnceOps)context.variableProvider().getVariables().map((Function1<Tuple2, Map> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Map map = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("key"), new ValString(key)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("value"), value)}));
                    return map;
                })).toList();
            } else {
                object = MODULE$.error(list);
            }
            return object;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    public ValFunction getValueFunction() {
        return new ValFunction((List<String>)new $colon$colon<Nothing$>((Nothing$)((Object)"context"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"key"), Nil$.MODULE$)), (Function1<List<Val>, Object>)(Function1<List, Object> & Serializable)x$71 -> {
            void var1_11;
            SeqOps seqOps;
            List list = x$71;
            if (list != null && !SeqFactory$UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = List$.MODULE$.unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Val val = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Val val2 = (Val)SeqFactory$UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory$UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (val instanceof ValContext) {
                    ValContext valContext = (ValContext)val;
                    Context c = valContext.context();
                    if (val2 instanceof ValString) {
                        ValString valString = (ValString)val2;
                        String key = valString.value();
                        Object b = c.variableProvider().getVariable(key).getOrElse((Function0<ValNull$> & Serializable)() -> ValNull$.MODULE$);
                        return var1_11;
                    }
                }
            }
            Val val = MODULE$.error(list);
            return var1_11;
        }, ValFunction$.MODULE$.apply$default$3());
    }

    private Val withListOfNumbers(List<Val> list, Function1<List<BigDecimal>, Val> f) {
        Val val;
        Option option = ((List)list.map((Function1<Val, Val> & Serializable)x$72 -> {
            ValNumber valNumber;
            Val val = x$72;
            Val val2 = val instanceof ValNumber ? (valNumber = (ValNumber)val) : new ValError(new StringBuilder(28).append("expected number but found '").append(val).append("'").toString());
            return val2;
        })).find((Function1<Val, Object> & Serializable)x$73 -> BoxesRunTime.boxToBoolean(BuiltinFunctions$.$anonfun$withListOfNumbers$2(x$73)));
        if (option instanceof Some) {
            Val e;
            Some some = (Some)option;
            val = e = (Val)some.value();
        } else if (None$.MODULE$.equals(option)) {
            val = f.apply((List<BigDecimal>)list.map((Function1<ValNumber, BigDecimal> & Serializable)x$74 -> x$74.value()));
        } else {
            throw new MatchError(option);
        }
        return val;
    }

    public static final /* synthetic */ boolean $anonfun$error$1(Val x$1) {
        return x$1 instanceof ValError;
    }

    public static final /* synthetic */ boolean $anonfun$error$2(Val x$2) {
        return x$2 instanceof ValError;
    }

    public static final /* synthetic */ int $anonfun$modeFunction$5(Tuple2 x0$2) {
        int count;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n = count = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$modeFunction$6(int maxCount$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int count = tuple2._2$mcI$sp();
        boolean bl = count == maxCount$1;
        return bl;
    }

    public static final /* synthetic */ ValNumber $anonfun$indexOfFunction$2(int x$54) {
        return new ValNumber(BigDecimal$.MODULE$.int2bigDecimal(x$54));
    }

    public static final /* synthetic */ boolean $anonfun$sortFunction$2(Function1 f$1, Val x0$1, Val x1$1) {
        boolean bl;
        Tuple2<Val, Val> tuple2 = new Tuple2<Val, Val>(x0$1, x1$1);
        if (tuple2 != null) {
            boolean isMet;
            Val y;
            Val x = tuple2._1();
            Object r = f$1.apply(new $colon$colon<Nothing$>((Nothing$)((Object)x), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)(y = tuple2._2())), Nil$.MODULE$)));
            if (!(r instanceof ValBoolean)) {
                throw new RuntimeException(new StringBuilder(29).append("expected boolean but found '").append(r).append("'").toString());
            }
            ValBoolean valBoolean = (ValBoolean)r;
            bl = isMet = valBoolean.value();
        } else {
            throw new MatchError(tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$withListOfNumbers$2(Val x$73) {
        return x$73 instanceof ValError;
    }

    private BuiltinFunctions$() {
    }
}

