/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.chinese;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.util.AttributeFactory;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneAnalyzerTokenizerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class TraditionalChineseLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Chinese-Traditional";

    public TraditionalChineseLanguageComponents() {
        super("Carrot2 (Chinese)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = TraditionalChineseLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> word -> null);
        components.put(Tokenizer.class, () -> new LuceneAnalyzerTokenizerAdapter((Analyzer)new TraditionalChineseAnalyzer()));
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private static class TraditionalChineseAnalyzer
    extends Analyzer {
        private TraditionalChineseAnalyzer() {
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents((org.apache.lucene.analysis.Tokenizer)new ICUTokenizer(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, (ICUTokenizerConfig)new DefaultICUTokenizerConfig(true, true)));
        }
    }
}

