/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.chinese;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.MutableCharArray;
import org.carrot2.util.ResourceLookup;

public class SimplifiedChineseLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Chinese-Simplified";

    public SimplifiedChineseLanguageComponents() {
        super("Carrot2 (Chinese)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = SimplifiedChineseLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> word -> null);
        components.put(Tokenizer.class, () -> new ChineseTokenizerAdapter());
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private static final class ChineseTokenizerAdapter
    implements Tokenizer {
        private static final Pattern numeric = Pattern.compile("[\\-+'$]?\\d+([:\\-/,.]?\\d+)*[%$]?");
        private HMMChineseTokenizer tokenizer;
        private CharTermAttribute term;
        private final MutableCharArray tempCharSequence = new MutableCharArray();

        private ChineseTokenizerAdapter() {
        }

        public short nextToken() throws IOException {
            boolean hasNextToken = this.tokenizer.incrementToken();
            if (hasNextToken) {
                short flags = 0;
                char[] image = this.term.buffer();
                int length = this.term.length();
                this.tempCharSequence.reset(image, 0, length);
                flags = length == 1 && image[0] == ',' ? (short)3 : (numeric.matcher((CharSequence)this.tempCharSequence).matches() ? (short)2 : 1);
                return flags;
            }
            return -1;
        }

        public void setTermBuffer(MutableCharArray array) {
            array.reset(this.term.buffer(), 0, this.term.length());
        }

        public void reset(Reader input) throws IOException {
            if (this.tokenizer != null) {
                this.tokenizer.end();
                this.tokenizer.close();
            } else {
                this.tokenizer = new HMMChineseTokenizer();
                this.term = (CharTermAttribute)this.tokenizer.addAttribute(CharTermAttribute.class);
            }
            this.tokenizer.setReader(input);
            this.tokenizer.reset();
        }
    }
}

