/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.japanese;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneAnalyzerTokenizerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class JapaneseLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Japanese";

    public JapaneseLanguageComponents() {
        super("Carrot2 (Japanese)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = JapaneseLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> word -> null);
        components.put(Tokenizer.class, () -> new LuceneAnalyzerTokenizerAdapter((Analyzer)new JapaneseAnalyzer()));
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }
}

