/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.korean;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ko.KoreanAnalyzer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneAnalyzerTokenizerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class KoreanLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Korean";

    public KoreanLanguageComponents() {
        super("Carrot2 (Korean)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = KoreanLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> word -> null);
        components.put(Tokenizer.class, () -> new LuceneAnalyzerTokenizerAdapter((Analyzer)new KoreanAnalyzer()));
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }
}

