/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.ar.ArabicNormalizer;
import org.apache.lucene.analysis.ar.ArabicStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class ArabicLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Arabic";

    public ArabicLanguageComponents() {
        super("Carrot2 (extras)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = ArabicLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> {
            ArabicStemmer stemmer = new ArabicStemmer();
            ArabicNormalizer normalizer = new ArabicNormalizer();
            return new LuceneStemmerAdapter((word, len) -> {
                int newLen = normalizer.normalize(word, len);
                newLen = stemmer.stem(word, newLen);
                return newLen;
            });
        });
        components.put(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }
}

