/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.hi.HindiNormalizer;
import org.apache.lucene.analysis.hi.HindiStemmer;
import org.apache.lucene.analysis.in.IndicNormalizer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class HindiLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Hindi";

    public HindiLanguageComponents() {
        super("Carrot2 (extras)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = HindiLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> new LuceneStemmerAdapter(new HindiStemming()));
        components.put(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private class HindiStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final IndicNormalizer indicNormalizer = new IndicNormalizer();
        final HindiNormalizer hindiNormalizer = new HindiNormalizer();
        final HindiStemmer hindiStemmer = new HindiStemmer();

        private HindiStemming() {
        }

        @Override
        public int apply(char[] word, int len) {
            len = this.indicNormalizer.normalize(word, len);
            len = this.hindiNormalizer.normalize(word, len);
            len = this.hindiStemmer.stem(word, len);
            return len;
        }
    }
}

