/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.id.IndonesianStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class IndonesianLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Indonesian";

    public IndonesianLanguageComponents() {
        super("Carrot2 (extras)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = IndonesianLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> new LuceneStemmerAdapter(new IndonesianStemming()));
        components.put(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private class IndonesianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        private final IndonesianStemmer stemmer = new IndonesianStemmer();

        private IndonesianStemming() {
        }

        @Override
        public int apply(char[] buffer, int length) {
            return this.stemmer.stem(buffer, length, true);
        }
    }
}

