/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.IdentityStemmer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.MutableCharArray;
import org.carrot2.util.ResourceLookup;

public class ThaiLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Thai";

    public ThaiLanguageComponents() {
        super("Carrot2 (extras)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = ThaiLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, IdentityStemmer::new);
        components.put(Tokenizer.class, () -> new ThaiTokenizerAdapter());
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private static class ThaiTokenizerAdapter
    implements Tokenizer {
        private CharTermAttribute term = null;
        private final MutableCharArray tempCharSequence = new MutableCharArray();
        private final ThaiTokenizer tokenizer = new ThaiTokenizer();

        private ThaiTokenizerAdapter() {
        }

        public short nextToken() throws IOException {
            boolean hasNextToken = this.tokenizer.incrementToken();
            if (hasNextToken) {
                char[] image = this.term.buffer();
                int length = this.term.length();
                this.tempCharSequence.reset(image, 0, length);
                return 1;
            }
            return -1;
        }

        public void setTermBuffer(MutableCharArray array) {
            array.reset(this.term.buffer(), 0, this.term.length());
        }

        public void reset(Reader input) throws IOException {
            if (this.tokenizer != null) {
                this.tokenizer.end();
                this.tokenizer.close();
            }
            this.tokenizer.setReader(input);
            this.term = (CharTermAttribute)this.tokenizer.addAttribute(CharTermAttribute.class);
            this.tokenizer.reset();
        }
    }
}

