/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.analysis.gl.GalicianStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LanguageComponentsProviderImpl;
import org.carrot2.language.LexicalData;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class GalicianLanguageComponents
extends LanguageComponentsProviderImpl {
    public static final String NAME = "Galician";

    public GalicianLanguageComponents() {
        super("Carrot2 (extras)", NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LexicalData lexicalData = GalicianLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, () -> new LuceneStemmerAdapter(new GalicianStemming(), 1));
        components.put(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        components.put(LexicalData.class, () -> lexicalData);
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    private class GalicianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final GalicianStemmer stemmer = new GalicianStemmer();

        private GalicianStemming() {
        }

        @Override
        public int apply(char[] word, int len) {
            return this.stemmer.stem(word, len);
        }
    }
}

