/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.carrot2.language.Tokenizer;
import org.carrot2.util.MutableCharArray;

public class LuceneAnalyzerTokenizerAdapter
implements Tokenizer {
    private static final TokenInfo SENTENCE_SEPARATOR = new TokenInfo(259, ".", 1);
    private final ArrayDeque<TokenInfo> queue = new ArrayDeque();
    private final Analyzer analyzer;
    private TokenStream ts;
    private PositionIncrementAttribute posIncrAttr;
    private PositionLengthAttribute posLengthAttr;
    private CharTermAttribute charTermAttr;
    private TokenInfo last;

    public LuceneAnalyzerTokenizerAdapter(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void reset(Reader reader) throws IOException {
        if (this.ts != null) {
            this.ts.end();
            this.ts.close();
        }
        this.ts = this.analyzer.tokenStream("", reader);
        this.ts.reset();
        this.posIncrAttr = (PositionIncrementAttribute)this.ts.getAttribute(PositionIncrementAttribute.class);
        this.charTermAttr = (CharTermAttribute)this.ts.getAttribute(CharTermAttribute.class);
        int position = 0;
        while (this.ts.incrementToken()) {
            int increment;
            int n = increment = this.posIncrAttr != null ? this.posIncrAttr.getPositionIncrement() : 1;
            if (increment < 0) {
                throw new AssertionError((Object)("Unexpected negative position increment: " + increment));
            }
            if (increment > 1 && !this.queue.isEmpty() && !this.isSentenceSeparator(this.queue.peekLast())) {
                this.queue.addLast(SENTENCE_SEPARATOR);
            }
            position += increment;
            int positionLength = this.posLengthAttr != null ? this.posLengthAttr.getPositionLength() : 1;
            TokenInfo current = new TokenInfo(1, this.charTermAttr.toString(), positionLength);
            if (increment == 0 && !this.queue.isEmpty()) {
                if (positionLength >= this.queue.peekLast().positionLength) continue;
                this.queue.removeLast();
                this.queue.addLast(current);
                continue;
            }
            this.queue.addLast(current);
        }
        this.ts.end();
        this.ts.close();
        this.ts = null;
    }

    private boolean isSentenceSeparator(TokenInfo ti) {
        return (ti.type & 0x100) != 0;
    }

    public short nextToken() {
        if (this.queue.isEmpty()) {
            this.last = null;
            return -1;
        }
        this.last = this.queue.removeFirst();
        return this.last.type;
    }

    public void setTermBuffer(MutableCharArray array) {
        array.reset(this.last.term);
    }

    private static class TokenInfo {
        CharSequence term;
        short type;
        int positionLength;

        public TokenInfo(short type, String term, int positionLength) {
            this.type = type;
            this.term = term;
            this.positionLength = positionLength;
        }
    }
}

