/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import org.apache.lucene.analysis.ar.ArabicNormalizer;
import org.apache.lucene.analysis.ar.ArabicStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class ArabicLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Arabic";

    public ArabicLanguageComponents() {
        super("Carrot2 (extras)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = ArabicLanguageComponents.loadLexicalData((String)language, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
        this.registerResourceless(Stemmer.class, () -> {
            ArabicStemmer stemmer = new ArabicStemmer();
            ArabicNormalizer normalizer = new ArabicNormalizer();
            return new LuceneStemmerAdapter((word, len) -> {
                int newLen = normalizer.normalize(word, len);
                newLen = stemmer.stem(word, newLen);
                return newLen;
            });
        });
    }
}

