/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.util.Objects;
import org.apache.lucene.analysis.br.BrazilianStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class BrazilianLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Brazilian";

    public BrazilianLanguageComponents() {
        super("Carrot2 (extras)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = BrazilianLanguageComponents.loadLexicalData((String)language, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
        this.registerResourceless(Stemmer.class, () -> new LuceneStemmerAdapter(new BrazilianStemmerAdapter()::stems, 5));
    }

    private class BrazilianStemmerAdapter
    extends BrazilianStemmer {
        private BrazilianStemmerAdapter() {
        }

        public int stems(char[] chars, int len) {
            String word = new String(chars, 0, len);
            String stem = super.stem(word);
            if (Objects.equals(word, stem)) {
                return len;
            }
            stem.getChars(0, stem.length(), chars, 0);
            return stem.length();
        }
    }
}

