/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import org.apache.lucene.analysis.el.GreekStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class GreekLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Greek";

    public GreekLanguageComponents() {
        super("Carrot2 (extras)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = GreekLanguageComponents.loadLexicalData((String)language, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
        this.registerResourceless(Stemmer.class, () -> {
            GreekStemmer stemmer = new GreekStemmer();
            return new LuceneStemmerAdapter((word, len) -> {
                this.lowerCase(word, len);
                return stemmer.stem(word, len);
            });
        });
    }

    private void lowerCase(char[] word, int len) {
        for (int i = 0; i < len; i += Character.toChars(this.lowerCase(Character.codePointAt(word, i, len)), word, i)) {
        }
    }

    private int lowerCase(int codepoint) {
        switch (codepoint) {
            case 962: {
                return 963;
            }
            case 902: 
            case 940: {
                return 945;
            }
            case 904: 
            case 941: {
                return 949;
            }
            case 905: 
            case 942: {
                return 951;
            }
            case 906: 
            case 912: 
            case 938: 
            case 943: 
            case 970: {
                return 953;
            }
            case 910: 
            case 939: 
            case 944: 
            case 971: 
            case 973: {
                return 965;
            }
            case 908: 
            case 972: {
                return 959;
            }
            case 911: 
            case 974: {
                return 969;
            }
            case 930: {
                return 962;
            }
        }
        return Character.toLowerCase(codepoint);
    }
}

