/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import org.apache.lucene.analysis.id.IndonesianStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class IndonesianLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Indonesian";

    public IndonesianLanguageComponents() {
        super("Carrot2 (extras)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = IndonesianLanguageComponents.loadLexicalData((String)language, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
        this.registerResourceless(Stemmer.class, () -> new LuceneStemmerAdapter(new IndonesianStemming()));
    }

    private class IndonesianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        private final IndonesianStemmer stemmer = new IndonesianStemmer();

        private IndonesianStemming() {
        }

        @Override
        public int apply(char[] buffer, int length) {
            return this.stemmer.stem(buffer, length, true);
        }
    }
}

