/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.IdentityStemmer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.MutableCharArray;
import org.carrot2.util.ResourceLookup;

public class ThaiLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Thai";

    public ThaiLanguageComponents() {
        super("Carrot2 (extras)", NAME);
        this.registerResourceless(Tokenizer.class, () -> new ThaiTokenizerAdapter());
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = ThaiLanguageComponents.loadLexicalData((String)language, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
        this.registerResourceless(Stemmer.class, IdentityStemmer::new);
    }

    private static class ThaiTokenizerAdapter
    implements Tokenizer {
        private CharTermAttribute term = null;
        private final MutableCharArray tempCharSequence = new MutableCharArray();
        private final ThaiTokenizer tokenizer = new ThaiTokenizer();

        private ThaiTokenizerAdapter() {
        }

        public short nextToken() throws IOException {
            boolean hasNextToken = this.tokenizer.incrementToken();
            if (hasNextToken) {
                char[] image = this.term.buffer();
                int length = this.term.length();
                this.tempCharSequence.reset(image, 0, length);
                return 1;
            }
            return -1;
        }

        public void setTermBuffer(MutableCharArray array) {
            array.reset(this.term.buffer(), 0, this.term.length());
        }

        public void reset(Reader input) throws IOException {
            this.tokenizer.end();
            this.tokenizer.close();
            this.tokenizer.setReader(input);
            this.term = (CharTermAttribute)this.tokenizer.addAttribute(CharTermAttribute.class);
            this.tokenizer.reset();
        }
    }
}

