/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import org.apache.lucene.analysis.gl.GalicianStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;

public class GalicianLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Galician";

    public GalicianLanguageComponents() {
        super("Carrot2 (Galician support via Apache Lucene components)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.registerDefaultLexicalData();
        this.registerResourceless(Stemmer.class, () -> new LuceneStemmerAdapter(new GalicianStemming(), 1));
    }

    private class GalicianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final GalicianStemmer stemmer = new GalicianStemmer();

        private GalicianStemming() {
        }

        @Override
        public int apply(char[] word, int len) {
            return this.stemmer.stem(word, len);
        }
    }
}

