/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.extras;

import org.apache.lucene.analysis.hi.HindiNormalizer;
import org.apache.lucene.analysis.hi.HindiStemmer;
import org.apache.lucene.analysis.in.IndicNormalizer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.language.extras.LuceneStemmerAdapter;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;

public class HindiLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Hindi";

    public HindiLanguageComponents() {
        super("Carrot2 (Hindi support via Apache Lucene components)", NAME);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.registerDefaultLexicalData();
        this.registerResourceless(Stemmer.class, () -> new LuceneStemmerAdapter(new HindiStemming()));
    }

    private class HindiStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final IndicNormalizer indicNormalizer = new IndicNormalizer();
        final HindiNormalizer hindiNormalizer = new HindiNormalizer();
        final HindiStemmer hindiStemmer = new HindiStemmer();

        private HindiStemming() {
        }

        @Override
        public int apply(char[] word, int len) {
            len = this.indicNormalizer.normalize(word, len);
            len = this.hindiNormalizer.normalize(word, len);
            len = this.hindiStemmer.stem(word, len);
            return len;
        }
    }
}

