/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import java.util.Map;
import org.carrot2.lucene.analysis.RSLPStemmerBase;

class GalicianStemmer
extends RSLPStemmerBase {
    private static final RSLPStemmerBase.Step plural;
    private static final RSLPStemmerBase.Step unification;
    private static final RSLPStemmerBase.Step adverb;
    private static final RSLPStemmerBase.Step augmentative;
    private static final RSLPStemmerBase.Step noun;
    private static final RSLPStemmerBase.Step verb;
    private static final RSLPStemmerBase.Step vowel;

    GalicianStemmer() {
    }

    int stem(char[] cArray, int n) {
        int n2;
        assert (cArray.length >= n + 1) : "this stemmer requires an oversized array of at least 1";
        n = plural.apply(cArray, n);
        n = unification.apply(cArray, n);
        n = adverb.apply(cArray, n);
        do {
            n2 = n;
        } while ((n = augmentative.apply(cArray, n)) != n2);
        n2 = n;
        if ((n = noun.apply(cArray, n)) == n2) {
            n = verb.apply(cArray, n);
        }
        n = vowel.apply(cArray, n);
        block8: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\u00e1': {
                    cArray[i] = 97;
                    continue block8;
                }
                case '\u00e9': 
                case '\u00ea': {
                    cArray[i] = 101;
                    continue block8;
                }
                case '\u00ed': {
                    cArray[i] = 105;
                    continue block8;
                }
                case '\u00f3': {
                    cArray[i] = 111;
                    continue block8;
                }
                case '\u00fa': {
                    cArray[i] = 117;
                }
            }
        }
        return n;
    }

    static {
        Map<String, RSLPStemmerBase.Step> map = GalicianStemmer.parse(GalicianStemmer.class, "galician.rslp");
        plural = map.get("Plural");
        unification = map.get("Unification");
        adverb = map.get("Adverb");
        augmentative = map.get("Augmentative");
        noun = map.get("Noun");
        verb = map.get("Verb");
        vowel = map.get("Vowel");
    }
}

