/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class LatvianStemmer {
    static final Affix[] affixes = new Affix[]{new Affix("ajiem", 3, false), new Affix("ajai", 3, false), new Affix("ajam", 2, false), new Affix("aj\u0101m", 2, false), new Affix("ajos", 2, false), new Affix("aj\u0101s", 2, false), new Affix("iem", 2, true), new Affix("aj\u0101", 2, false), new Affix("ais", 2, false), new Affix("ai", 2, false), new Affix("ei", 2, false), new Affix("\u0101m", 1, false), new Affix("am", 1, false), new Affix("\u0113m", 1, false), new Affix("\u012bm", 1, false), new Affix("im", 1, false), new Affix("um", 1, false), new Affix("us", 1, true), new Affix("as", 1, false), new Affix("\u0101s", 1, false), new Affix("es", 1, false), new Affix("os", 1, true), new Affix("ij", 1, false), new Affix("\u012bs", 1, false), new Affix("\u0113s", 1, false), new Affix("is", 1, false), new Affix("ie", 1, false), new Affix("u", 1, true), new Affix("a", 1, true), new Affix("i", 1, true), new Affix("e", 1, false), new Affix("\u0101", 1, false), new Affix("\u0113", 1, false), new Affix("\u012b", 1, false), new Affix("\u016b", 1, false), new Affix("o", 1, false), new Affix("s", 0, false), new Affix("\u0161", 0, false)};

    LatvianStemmer() {
    }

    int stem(char[] cArray, int n) {
        int n2 = this.numVowels(cArray, n);
        for (int i = 0; i < affixes.length; ++i) {
            Affix affix = affixes[i];
            if (n2 <= affix.vc || n < affix.affix.length + 3 || !StemmerUtil.endsWith(cArray, n, affix.affix)) continue;
            return affix.palatalizes ? this.unpalatalize(cArray, n) : (n -= affix.affix.length);
        }
        return n;
    }

    private int unpalatalize(char[] cArray, int n) {
        if (cArray[n] == 'u') {
            if (StemmerUtil.endsWith(cArray, n, "k\u0161")) {
                cArray[++n - 2] = 115;
                cArray[n - 1] = 116;
                return n;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0146\u0146")) {
                cArray[n - 2] = 110;
                cArray[n - 1] = 110;
                return n;
            }
        }
        if (StemmerUtil.endsWith(cArray, n, "pj") || StemmerUtil.endsWith(cArray, n, "bj") || StemmerUtil.endsWith(cArray, n, "mj") || StemmerUtil.endsWith(cArray, n, "vj")) {
            return n - 1;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u0161\u0146")) {
            cArray[n - 2] = 115;
            cArray[n - 1] = 110;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u017e\u0146")) {
            cArray[n - 2] = 122;
            cArray[n - 1] = 110;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u0161\u013c")) {
            cArray[n - 2] = 115;
            cArray[n - 1] = 108;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u017e\u013c")) {
            cArray[n - 2] = 122;
            cArray[n - 1] = 108;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u013c\u0146")) {
            cArray[n - 2] = 108;
            cArray[n - 1] = 110;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u013c\u013c")) {
            cArray[n - 2] = 108;
            cArray[n - 1] = 108;
            return n;
        }
        if (cArray[n - 1] == '\u010d') {
            cArray[n - 1] = 99;
            return n;
        }
        if (cArray[n - 1] == '\u013c') {
            cArray[n - 1] = 108;
            return n;
        }
        if (cArray[n - 1] == '\u0146') {
            cArray[n - 1] = 110;
            return n;
        }
        return n;
    }

    private int numVowels(char[] cArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': 
                case 'u': 
                case '\u0101': 
                case '\u0113': 
                case '\u012b': 
                case '\u016b': {
                    ++n2;
                }
            }
        }
        return n2;
    }

    static class Affix {
        char[] affix;
        int vc;
        boolean palatalizes;

        Affix(String string, int n, boolean bl) {
            this.affix = string.toCharArray();
            this.vc = n;
            this.palatalizes = bl;
        }
    }
}

