/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import java.util.Objects;
import org.carrot2.language.Stemmer;
import org.carrot2.lucene.analysis.ArabicNormalizer;
import org.carrot2.lucene.analysis.ArabicStemmer;
import org.carrot2.lucene.analysis.BrazilianStemmer;
import org.carrot2.lucene.analysis.BulgarianStemmer;
import org.carrot2.lucene.analysis.CzechStemmer;
import org.carrot2.lucene.analysis.GalicianStemmer;
import org.carrot2.lucene.analysis.GreekStemmer;
import org.carrot2.lucene.analysis.HindiNormalizer;
import org.carrot2.lucene.analysis.HindiStemmer;
import org.carrot2.lucene.analysis.IndicNormalizer;
import org.carrot2.lucene.analysis.IndonesianStemmer;
import org.carrot2.lucene.analysis.LatvianStemmer;
import org.carrot2.lucene.analysis.LuceneStemmerAdapter;

public class LuceneAccessBypass {
    public static Stemmer getCzechStemmer() {
        return new LuceneStemmerAdapter(new CzechStemmer()::stem);
    }

    public static Stemmer getArabicStemmer() {
        ArabicStemmer stemmer = new ArabicStemmer();
        ArabicNormalizer normalizer = new ArabicNormalizer();
        return new LuceneStemmerAdapter((word, len) -> {
            int newLen = normalizer.normalize(word, len);
            newLen = stemmer.stem(word, newLen);
            return newLen;
        });
    }

    public static Stemmer getBrazilianStemmer() {
        return new LuceneStemmerAdapter(new BrazilianStemmerAdapter()::stems, 5);
    }

    public static Stemmer getHindiStemmer() {
        return new LuceneStemmerAdapter(new HindiStemming());
    }

    public static Stemmer getIndonesianStemmer() {
        return new LuceneStemmerAdapter(new IndonesianStemming());
    }

    public static Stemmer getLatvianStemmer() {
        return new LuceneStemmerAdapter(new LatvianStemmer()::stem);
    }

    public static Stemmer getBulgarianStemmer() {
        return new LuceneStemmerAdapter(new BulgarianStemmer()::stem);
    }

    public static Stemmer getGalicianStemmer() {
        return new LuceneStemmerAdapter(new GalicianStemmer()::stem);
    }

    public static Stemmer getGreekStemmer() {
        final GreekStemmer stemmer = new GreekStemmer();
        return new LuceneStemmerAdapter(new LuceneStemmerAdapter.StemmingFunction(){

            @Override
            public int apply(char[] word, int len) {
                this.lowerCase(word, len);
                return stemmer.stem(word, len);
            }

            private void lowerCase(char[] word, int len) {
                for (int i = 0; i < len; i += Character.toChars(this.lowerCase(Character.codePointAt(word, i, len)), word, i)) {
                }
            }

            private int lowerCase(int codepoint) {
                switch (codepoint) {
                    case 962: {
                        return 963;
                    }
                    case 902: 
                    case 940: {
                        return 945;
                    }
                    case 904: 
                    case 941: {
                        return 949;
                    }
                    case 905: 
                    case 942: {
                        return 951;
                    }
                    case 906: 
                    case 912: 
                    case 938: 
                    case 943: 
                    case 970: {
                        return 953;
                    }
                    case 910: 
                    case 939: 
                    case 944: 
                    case 971: 
                    case 973: {
                        return 965;
                    }
                    case 908: 
                    case 972: {
                        return 959;
                    }
                    case 911: 
                    case 974: {
                        return 969;
                    }
                    case 930: {
                        return 962;
                    }
                }
                return Character.toLowerCase(codepoint);
            }
        });
    }

    private static class BrazilianStemmerAdapter
    extends BrazilianStemmer {
        private BrazilianStemmerAdapter() {
        }

        public int stems(char[] chars, int len) {
            String word = new String(chars, 0, len);
            String stem = super.stem(word);
            if (stem == null || Objects.equals(word, stem)) {
                return len;
            }
            stem.getChars(0, stem.length(), chars, 0);
            return stem.length();
        }
    }

    private static class HindiStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final IndicNormalizer indicNormalizer = new IndicNormalizer();
        final HindiNormalizer hindiNormalizer = new HindiNormalizer();
        final HindiStemmer hindiStemmer = new HindiStemmer();

        private HindiStemming() {
        }

        @Override
        public int apply(char[] word, int len) {
            len = this.indicNormalizer.normalize(word, len);
            len = this.hindiNormalizer.normalize(word, len);
            len = this.hindiStemmer.stem(word, len);
            return len;
        }
    }

    private static class IndonesianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        private final IndonesianStemmer stemmer = new IndonesianStemmer();

        private IndonesianStemming() {
        }

        @Override
        public int apply(char[] buffer, int length) {
            return this.stemmer.stem(buffer, length, true);
        }
    }

    private class GalicianStemming
    implements LuceneStemmerAdapter.StemmingFunction {
        final GalicianStemmer stemmer = new GalicianStemmer();

        private GalicianStemming(LuceneAccessBypass luceneAccessBypass) {
        }

        @Override
        public int apply(char[] word, int len) {
            return this.stemmer.stem(word, len);
        }
    }
}

