/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import java.util.Arrays;
import org.carrot2.language.Stemmer;
import org.carrot2.util.MutableCharArray;

final class LuceneStemmerAdapter
implements Stemmer {
    private final int extraBufferPadding;
    private final StemmingFunction stemmer;
    private char[] buffer = new char[128];

    LuceneStemmerAdapter(StemmingFunction stemmer, int extraBufferPadding) {
        this.stemmer = stemmer;
        this.extraBufferPadding = extraBufferPadding;
    }

    LuceneStemmerAdapter(StemmingFunction stemmer) {
        this(stemmer, 0);
    }

    public CharSequence stem(CharSequence word) {
        if (word.length() + this.extraBufferPadding > this.buffer.length) {
            this.buffer = new char[word.length() + this.extraBufferPadding];
        }
        int max = word.length();
        for (int i = 0; i < max; ++i) {
            this.buffer[i] = word.charAt(i);
        }
        int newLen = this.stemmer.apply(this.buffer, word.length());
        if (newLen != word.length() || !this.equals(this.buffer, newLen, word)) {
            return new MutableCharArray(Arrays.copyOf(this.buffer, newLen));
        }
        return null;
    }

    private boolean equals(char[] buffer, int len, CharSequence word) {
        assert (len == word.length());
        for (int i = 0; i < len; ++i) {
            if (buffer[i] == word.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static interface StemmingFunction {
        public int apply(char[] var1, int var2);
    }
}

