/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class ArabicNormalizer {
    static final char ALEF = '\u0627';
    static final char ALEF_MADDA = '\u0622';
    static final char ALEF_HAMZA_ABOVE = '\u0623';
    static final char ALEF_HAMZA_BELOW = '\u0625';
    static final char YEH = '\u064a';
    static final char DOTLESS_YEH = '\u0649';
    static final char TEH_MARBUTA = '\u0629';
    static final char HEH = '\u0647';
    static final char TATWEEL = '\u0640';
    static final char FATHATAN = '\u064b';
    static final char DAMMATAN = '\u064c';
    static final char KASRATAN = '\u064d';
    static final char FATHA = '\u064e';
    static final char DAMMA = '\u064f';
    static final char KASRA = '\u0650';
    static final char SHADDA = '\u0651';
    static final char SUKUN = '\u0652';

    ArabicNormalizer() {
    }

    int normalize(char[] cArray, int n) {
        block6: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\u0622': 
                case '\u0623': 
                case '\u0625': {
                    cArray[i] = 1575;
                    continue block6;
                }
                case '\u0649': {
                    cArray[i] = 1610;
                    continue block6;
                }
                case '\u0629': {
                    cArray[i] = 1607;
                    continue block6;
                }
                case '\u0640': 
                case '\u064b': 
                case '\u064c': 
                case '\u064d': 
                case '\u064e': 
                case '\u064f': 
                case '\u0650': 
                case '\u0651': 
                case '\u0652': {
                    n = StemmerUtil.delete(cArray, i, n);
                    --i;
                    continue block6;
                }
            }
        }
        return n;
    }
}

