/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class ArabicStemmer {
    static final char ALEF = '\u0627';
    static final char BEH = '\u0628';
    static final char TEH_MARBUTA = '\u0629';
    static final char TEH = '\u062a';
    static final char FEH = '\u0641';
    static final char KAF = '\u0643';
    static final char LAM = '\u0644';
    static final char NOON = '\u0646';
    static final char HEH = '\u0647';
    static final char WAW = '\u0648';
    static final char YEH = '\u064a';
    static final char[][] prefixes = new char[][]{"\u0627\u0644".toCharArray(), "\u0648\u0627\u0644".toCharArray(), "\u0628\u0627\u0644".toCharArray(), "\u0643\u0627\u0644".toCharArray(), "\u0641\u0627\u0644".toCharArray(), "\u0644\u0644".toCharArray(), "\u0648".toCharArray()};
    static final char[][] suffixes = new char[][]{"\u0647\u0627".toCharArray(), "\u0627\u0646".toCharArray(), "\u0627\u062a".toCharArray(), "\u0648\u0646".toCharArray(), "\u064a\u0646".toCharArray(), "\u064a\u0647".toCharArray(), "\u064a\u0629".toCharArray(), "\u0647".toCharArray(), "\u0629".toCharArray(), "\u064a".toCharArray()};

    ArabicStemmer() {
    }

    int stem(char[] cArray, int n) {
        n = this.stemPrefix(cArray, n);
        n = this.stemSuffix(cArray, n);
        return n;
    }

    int stemPrefix(char[] cArray, int n) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!this.startsWithCheckLength(cArray, n, prefixes[i])) continue;
            return StemmerUtil.deleteN(cArray, 0, n, prefixes[i].length);
        }
        return n;
    }

    int stemSuffix(char[] cArray, int n) {
        for (int i = 0; i < suffixes.length; ++i) {
            if (!this.endsWithCheckLength(cArray, n, suffixes[i])) continue;
            n = StemmerUtil.deleteN(cArray, n - suffixes[i].length, n, suffixes[i].length);
        }
        return n;
    }

    boolean startsWithCheckLength(char[] cArray, int n, char[] cArray2) {
        if (cArray2.length == 1 && n < 4) {
            return false;
        }
        if (n < cArray2.length + 2) {
            return false;
        }
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    boolean endsWithCheckLength(char[] cArray, int n, char[] cArray2) {
        if (n < cArray2.length + 2) {
            return false;
        }
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[n - cArray2.length + i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }
}

