/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class BulgarianStemmer {
    BulgarianStemmer() {
    }

    int stem(char[] cArray, int n) {
        if (n < 4) {
            return n;
        }
        if (n > 5 && StemmerUtil.endsWith(cArray, n, "\u0438\u0449\u0430")) {
            return n - 3;
        }
        n = this.removeArticle(cArray, n);
        if ((n = this.removePlural(cArray, n)) > 3) {
            if (StemmerUtil.endsWith(cArray, n, "\u044f")) {
                --n;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0430") || StemmerUtil.endsWith(cArray, n, "\u043e") || StemmerUtil.endsWith(cArray, n, "\u0435")) {
                --n;
            }
        }
        if (n > 4 && StemmerUtil.endsWith(cArray, n, "\u0435\u043d")) {
            cArray[n - 2] = 1085;
            --n;
        }
        if (n > 5 && cArray[n - 2] == '\u044a') {
            cArray[n - 2] = cArray[n - 1];
            --n;
        }
        return n;
    }

    private int removeArticle(char[] cArray, int n) {
        if (n > 6 && StemmerUtil.endsWith(cArray, n, "\u0438\u044f\u0442")) {
            return n - 3;
        }
        if (n > 5 && (StemmerUtil.endsWith(cArray, n, "\u044a\u0442") || StemmerUtil.endsWith(cArray, n, "\u0442\u043e") || StemmerUtil.endsWith(cArray, n, "\u0442\u0435") || StemmerUtil.endsWith(cArray, n, "\u0442\u0430") || StemmerUtil.endsWith(cArray, n, "\u0438\u044f"))) {
            return n - 2;
        }
        if (n > 4 && StemmerUtil.endsWith(cArray, n, "\u044f\u0442")) {
            return n - 2;
        }
        return n;
    }

    private int removePlural(char[] cArray, int n) {
        if (n > 6) {
            if (StemmerUtil.endsWith(cArray, n, "\u043e\u0432\u0446\u0438")) {
                return n - 3;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u043e\u0432\u0435")) {
                return n - 3;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0435\u0432\u0435")) {
                cArray[n - 3] = 1081;
                return n - 2;
            }
        }
        if (n > 5) {
            if (StemmerUtil.endsWith(cArray, n, "\u0438\u0449\u0430")) {
                return n - 3;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0442\u0430")) {
                return n - 2;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0446\u0438")) {
                cArray[n - 2] = 1082;
                return n - 1;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0437\u0438")) {
                cArray[n - 2] = 1075;
                return n - 1;
            }
            if (cArray[n - 3] == '\u0435' && cArray[n - 1] == '\u0438') {
                cArray[n - 3] = 1103;
                return n - 1;
            }
        }
        if (n > 4) {
            if (StemmerUtil.endsWith(cArray, n, "\u0441\u0438")) {
                cArray[n - 2] = 1093;
                return n - 1;
            }
            if (StemmerUtil.endsWith(cArray, n, "\u0438")) {
                return n - 1;
            }
        }
        return n;
    }
}

