/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class CzechStemmer {
    CzechStemmer() {
    }

    int stem(char[] cArray, int n) {
        n = this.removeCase(cArray, n);
        if ((n = this.removePossessives(cArray, n)) > 0) {
            n = this.normalize(cArray, n);
        }
        return n;
    }

    private int removeCase(char[] cArray, int n) {
        if (n > 7 && StemmerUtil.endsWith(cArray, n, "atech")) {
            return n - 5;
        }
        if (n > 6 && (StemmerUtil.endsWith(cArray, n, "\u011btem") || StemmerUtil.endsWith(cArray, n, "etem") || StemmerUtil.endsWith(cArray, n, "at\u016fm"))) {
            return n - 4;
        }
        if (n > 5 && (StemmerUtil.endsWith(cArray, n, "ech") || StemmerUtil.endsWith(cArray, n, "ich") || StemmerUtil.endsWith(cArray, n, "\u00edch") || StemmerUtil.endsWith(cArray, n, "\u00e9ho") || StemmerUtil.endsWith(cArray, n, "\u011bmi") || StemmerUtil.endsWith(cArray, n, "emi") || StemmerUtil.endsWith(cArray, n, "\u00e9mu") || StemmerUtil.endsWith(cArray, n, "\u011bte") || StemmerUtil.endsWith(cArray, n, "ete") || StemmerUtil.endsWith(cArray, n, "\u011bti") || StemmerUtil.endsWith(cArray, n, "eti") || StemmerUtil.endsWith(cArray, n, "\u00edho") || StemmerUtil.endsWith(cArray, n, "iho") || StemmerUtil.endsWith(cArray, n, "\u00edmi") || StemmerUtil.endsWith(cArray, n, "\u00edmu") || StemmerUtil.endsWith(cArray, n, "imu") || StemmerUtil.endsWith(cArray, n, "\u00e1ch") || StemmerUtil.endsWith(cArray, n, "ata") || StemmerUtil.endsWith(cArray, n, "aty") || StemmerUtil.endsWith(cArray, n, "\u00fdch") || StemmerUtil.endsWith(cArray, n, "ama") || StemmerUtil.endsWith(cArray, n, "ami") || StemmerUtil.endsWith(cArray, n, "ov\u00e9") || StemmerUtil.endsWith(cArray, n, "ovi") || StemmerUtil.endsWith(cArray, n, "\u00fdmi"))) {
            return n - 3;
        }
        if (n > 4 && (StemmerUtil.endsWith(cArray, n, "em") || StemmerUtil.endsWith(cArray, n, "es") || StemmerUtil.endsWith(cArray, n, "\u00e9m") || StemmerUtil.endsWith(cArray, n, "\u00edm") || StemmerUtil.endsWith(cArray, n, "\u016fm") || StemmerUtil.endsWith(cArray, n, "at") || StemmerUtil.endsWith(cArray, n, "\u00e1m") || StemmerUtil.endsWith(cArray, n, "os") || StemmerUtil.endsWith(cArray, n, "us") || StemmerUtil.endsWith(cArray, n, "\u00fdm") || StemmerUtil.endsWith(cArray, n, "mi") || StemmerUtil.endsWith(cArray, n, "ou"))) {
            return n - 2;
        }
        if (n > 3) {
            switch (cArray[n - 1]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'y': 
                case '\u00e1': 
                case '\u00e9': 
                case '\u00ed': 
                case '\u00fd': 
                case '\u011b': 
                case '\u016f': {
                    return n - 1;
                }
            }
        }
        return n;
    }

    private int removePossessives(char[] cArray, int n) {
        if (n > 5 && (StemmerUtil.endsWith(cArray, n, "ov") || StemmerUtil.endsWith(cArray, n, "in") || StemmerUtil.endsWith(cArray, n, "\u016fv"))) {
            return n - 2;
        }
        return n;
    }

    private int normalize(char[] cArray, int n) {
        if (StemmerUtil.endsWith(cArray, n, "\u010dt")) {
            cArray[n - 2] = 99;
            cArray[n - 1] = 107;
            return n;
        }
        if (StemmerUtil.endsWith(cArray, n, "\u0161t")) {
            cArray[n - 2] = 115;
            cArray[n - 1] = 107;
            return n;
        }
        switch (cArray[n - 1]) {
            case 'c': 
            case '\u010d': {
                cArray[n - 1] = 107;
                return n;
            }
            case 'z': 
            case '\u017e': {
                cArray[n - 1] = 104;
                return n;
            }
        }
        if (n > 1 && cArray[n - 2] == 'e') {
            cArray[n - 2] = cArray[n - 1];
            return n - 1;
        }
        if (n > 2 && cArray[n - 2] == '\u016f') {
            cArray[n - 2] = 111;
            return n;
        }
        return n;
    }
}

