/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import java.util.Arrays;
import org.apache.lucene.analysis.CharArraySet;

class GreekStemmer {
    private static final CharArraySet exc4 = new CharArraySet(Arrays.asList("\u03b8", "\u03b4", "\u03b5\u03bb", "\u03b3\u03b1\u03bb", "\u03bd", "\u03c0", "\u03b9\u03b4", "\u03c0\u03b1\u03c1"), false);
    private static final CharArraySet exc6 = new CharArraySet(Arrays.asList("\u03b1\u03bb", "\u03b1\u03b4", "\u03b5\u03bd\u03b4", "\u03b1\u03bc\u03b1\u03bd", "\u03b1\u03bc\u03bc\u03bf\u03c7\u03b1\u03bb", "\u03b7\u03b8", "\u03b1\u03bd\u03b7\u03b8", "\u03b1\u03bd\u03c4\u03b9\u03b4", "\u03c6\u03c5\u03c3", "\u03b2\u03c1\u03c9\u03bc", "\u03b3\u03b5\u03c1", "\u03b5\u03be\u03c9\u03b4", "\u03ba\u03b1\u03bb\u03c0", "\u03ba\u03b1\u03bb\u03bb\u03b9\u03bd", "\u03ba\u03b1\u03c4\u03b1\u03b4", "\u03bc\u03bf\u03c5\u03bb", "\u03bc\u03c0\u03b1\u03bd", "\u03bc\u03c0\u03b1\u03b3\u03b9\u03b1\u03c4", "\u03bc\u03c0\u03bf\u03bb", "\u03bc\u03c0\u03bf\u03c3", "\u03bd\u03b9\u03c4", "\u03be\u03b9\u03ba", "\u03c3\u03c5\u03bd\u03bf\u03bc\u03b7\u03bb", "\u03c0\u03b5\u03c4\u03c3", "\u03c0\u03b9\u03c4\u03c3", "\u03c0\u03b9\u03ba\u03b1\u03bd\u03c4", "\u03c0\u03bb\u03b9\u03b1\u03c4\u03c3", "\u03c0\u03bf\u03c3\u03c4\u03b5\u03bb\u03bd", "\u03c0\u03c1\u03c9\u03c4\u03bf\u03b4", "\u03c3\u03b5\u03c1\u03c4", "\u03c3\u03c5\u03bd\u03b1\u03b4", "\u03c4\u03c3\u03b1\u03bc", "\u03c5\u03c0\u03bf\u03b4", "\u03c6\u03b9\u03bb\u03bf\u03bd", "\u03c6\u03c5\u03bb\u03bf\u03b4", "\u03c7\u03b1\u03c3"), false);
    private static final CharArraySet exc7 = new CharArraySet(Arrays.asList("\u03b1\u03bd\u03b1\u03c0", "\u03b1\u03c0\u03bf\u03b8", "\u03b1\u03c0\u03bf\u03ba", "\u03b1\u03c0\u03bf\u03c3\u03c4", "\u03b2\u03bf\u03c5\u03b2", "\u03be\u03b5\u03b8", "\u03bf\u03c5\u03bb", "\u03c0\u03b5\u03b8", "\u03c0\u03b9\u03ba\u03c1", "\u03c0\u03bf\u03c4", "\u03c3\u03b9\u03c7", "\u03c7"), false);
    private static final CharArraySet exc8a = new CharArraySet(Arrays.asList("\u03c4\u03c1", "\u03c4\u03c3"), false);
    private static final CharArraySet exc8b = new CharArraySet(Arrays.asList("\u03b2\u03b5\u03c4\u03b5\u03c1", "\u03b2\u03bf\u03c5\u03bb\u03ba", "\u03b2\u03c1\u03b1\u03c7\u03bc", "\u03b3", "\u03b4\u03c1\u03b1\u03b4\u03bf\u03c5\u03bc", "\u03b8", "\u03ba\u03b1\u03bb\u03c0\u03bf\u03c5\u03b6", "\u03ba\u03b1\u03c3\u03c4\u03b5\u03bb", "\u03ba\u03bf\u03c1\u03bc\u03bf\u03c1", "\u03bb\u03b1\u03bf\u03c0\u03bb", "\u03bc\u03c9\u03b1\u03bc\u03b5\u03b8", "\u03bc", "\u03bc\u03bf\u03c5\u03c3\u03bf\u03c5\u03bb\u03bc", "\u03bd", "\u03bf\u03c5\u03bb", "\u03c0", "\u03c0\u03b5\u03bb\u03b5\u03ba", "\u03c0\u03bb", "\u03c0\u03bf\u03bb\u03b9\u03c3", "\u03c0\u03bf\u03c1\u03c4\u03bf\u03bb", "\u03c3\u03b1\u03c1\u03b1\u03ba\u03b1\u03c4\u03c3", "\u03c3\u03bf\u03c5\u03bb\u03c4", "\u03c4\u03c3\u03b1\u03c1\u03bb\u03b1\u03c4", "\u03bf\u03c1\u03c6", "\u03c4\u03c3\u03b9\u03b3\u03b3", "\u03c4\u03c3\u03bf\u03c0", "\u03c6\u03c9\u03c4\u03bf\u03c3\u03c4\u03b5\u03c6", "\u03c7", "\u03c8\u03c5\u03c7\u03bf\u03c0\u03bb", "\u03b1\u03b3", "\u03bf\u03c1\u03c6", "\u03b3\u03b1\u03bb", "\u03b3\u03b5\u03c1", "\u03b4\u03b5\u03ba", "\u03b4\u03b9\u03c0\u03bb", "\u03b1\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd", "\u03bf\u03c5\u03c1", "\u03c0\u03b9\u03b8", "\u03c0\u03bf\u03c5\u03c1\u03b9\u03c4", "\u03c3", "\u03b6\u03c9\u03bd\u03c4", "\u03b9\u03ba", "\u03ba\u03b1\u03c3\u03c4", "\u03ba\u03bf\u03c0", "\u03bb\u03b9\u03c7", "\u03bb\u03bf\u03c5\u03b8\u03b7\u03c1", "\u03bc\u03b1\u03b9\u03bd\u03c4", "\u03bc\u03b5\u03bb", "\u03c3\u03b9\u03b3", "\u03c3\u03c0", "\u03c3\u03c4\u03b5\u03b3", "\u03c4\u03c1\u03b1\u03b3", "\u03c4\u03c3\u03b1\u03b3", "\u03c6", "\u03b5\u03c1", "\u03b1\u03b4\u03b1\u03c0", "\u03b1\u03b8\u03b9\u03b3\u03b3", "\u03b1\u03bc\u03b7\u03c7", "\u03b1\u03bd\u03b9\u03ba", "\u03b1\u03bd\u03bf\u03c1\u03b3", "\u03b1\u03c0\u03b7\u03b3", "\u03b1\u03c0\u03b9\u03b8", "\u03b1\u03c4\u03c3\u03b9\u03b3\u03b3", "\u03b2\u03b1\u03c3", "\u03b2\u03b1\u03c3\u03ba", "\u03b2\u03b1\u03b8\u03c5\u03b3\u03b1\u03bb", "\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03b2\u03c1\u03b1\u03c7\u03c5\u03ba", "\u03b4\u03b9\u03b1\u03c4", "\u03b4\u03b9\u03b1\u03c6", "\u03b5\u03bd\u03bf\u03c1\u03b3", "\u03b8\u03c5\u03c3", "\u03ba\u03b1\u03c0\u03bd\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03ba\u03b1\u03c4\u03b1\u03b3\u03b1\u03bb", "\u03ba\u03bb\u03b9\u03b2", "\u03ba\u03bf\u03b9\u03bb\u03b1\u03c1\u03c6", "\u03bb\u03b9\u03b2", "\u03bc\u03b5\u03b3\u03bb\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03bc\u03b9\u03ba\u03c1\u03bf\u03b2\u03b9\u03bf\u03bc\u03b7\u03c7", "\u03bd\u03c4\u03b1\u03b2", "\u03be\u03b7\u03c1\u03bf\u03ba\u03bb\u03b9\u03b2", "\u03bf\u03bb\u03b9\u03b3\u03bf\u03b4\u03b1\u03bc", "\u03bf\u03bb\u03bf\u03b3\u03b1\u03bb", "\u03c0\u03b5\u03bd\u03c4\u03b1\u03c1\u03c6", "\u03c0\u03b5\u03c1\u03b7\u03c6", "\u03c0\u03b5\u03c1\u03b9\u03c4\u03c1", "\u03c0\u03bb\u03b1\u03c4", "\u03c0\u03bf\u03bb\u03c5\u03b4\u03b1\u03c0", "\u03c0\u03bf\u03bb\u03c5\u03bc\u03b7\u03c7", "\u03c3\u03c4\u03b5\u03c6", "\u03c4\u03b1\u03b2", "\u03c4\u03b5\u03c4", "\u03c5\u03c0\u03b5\u03c1\u03b7\u03c6", "\u03c5\u03c0\u03bf\u03ba\u03bf\u03c0", "\u03c7\u03b1\u03bc\u03b7\u03bb\u03bf\u03b4\u03b1\u03c0", "\u03c8\u03b7\u03bb\u03bf\u03c4\u03b1\u03b2"), false);
    private static final CharArraySet exc9 = new CharArraySet(Arrays.asList("\u03b1\u03b2\u03b1\u03c1", "\u03b2\u03b5\u03bd", "\u03b5\u03bd\u03b1\u03c1", "\u03b1\u03b2\u03c1", "\u03b1\u03b4", "\u03b1\u03b8", "\u03b1\u03bd", "\u03b1\u03c0\u03bb", "\u03b2\u03b1\u03c1\u03bf\u03bd", "\u03bd\u03c4\u03c1", "\u03c3\u03ba", "\u03ba\u03bf\u03c0", "\u03bc\u03c0\u03bf\u03c1", "\u03bd\u03b9\u03c6", "\u03c0\u03b1\u03b3", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03bb", "\u03c3\u03b5\u03c1\u03c0", "\u03c3\u03ba\u03b5\u03bb", "\u03c3\u03c5\u03c1\u03c6", "\u03c4\u03bf\u03ba", "\u03c5", "\u03b4", "\u03b5\u03bc", "\u03b8\u03b1\u03c1\u03c1", "\u03b8"), false);
    private static final CharArraySet exc12a = new CharArraySet(Arrays.asList("\u03c0", "\u03b1\u03c0", "\u03c3\u03c5\u03bc\u03c0", "\u03b1\u03c3\u03c5\u03bc\u03c0", "\u03b1\u03ba\u03b1\u03c4\u03b1\u03c0", "\u03b1\u03bc\u03b5\u03c4\u03b1\u03bc\u03c6"), false);
    private static final CharArraySet exc12b = new CharArraySet(Arrays.asList("\u03b1\u03bb", "\u03b1\u03c1", "\u03b5\u03ba\u03c4\u03b5\u03bb", "\u03b6", "\u03bc", "\u03be", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03bb", "\u03b1\u03c1", "\u03c0\u03c1\u03bf", "\u03bd\u03b9\u03c3"), false);
    private static final CharArraySet exc13 = new CharArraySet(Arrays.asList("\u03b4\u03b9\u03b1\u03b8", "\u03b8", "\u03c0\u03b1\u03c1\u03b1\u03ba\u03b1\u03c4\u03b1\u03b8", "\u03c0\u03c1\u03bf\u03c3\u03b8", "\u03c3\u03c5\u03bd\u03b8"), false);
    private static final CharArraySet exc14 = new CharArraySet(Arrays.asList("\u03c6\u03b1\u03c1\u03bc\u03b1\u03ba", "\u03c7\u03b1\u03b4", "\u03b1\u03b3\u03ba", "\u03b1\u03bd\u03b1\u03c1\u03c1", "\u03b2\u03c1\u03bf\u03bc", "\u03b5\u03ba\u03bb\u03b9\u03c0", "\u03bb\u03b1\u03bc\u03c0\u03b9\u03b4", "\u03bb\u03b5\u03c7", "\u03bc", "\u03c0\u03b1\u03c4", "\u03c1", "\u03bb", "\u03bc\u03b5\u03b4", "\u03bc\u03b5\u03c3\u03b1\u03b6", "\u03c5\u03c0\u03bf\u03c4\u03b5\u03b9\u03bd", "\u03b1\u03bc", "\u03b1\u03b9\u03b8", "\u03b1\u03bd\u03b7\u03ba", "\u03b4\u03b5\u03c3\u03c0\u03bf\u03b6", "\u03b5\u03bd\u03b4\u03b9\u03b1\u03c6\u03b5\u03c1", "\u03b4\u03b5", "\u03b4\u03b5\u03c5\u03c4\u03b5\u03c1\u03b5\u03c5", "\u03ba\u03b1\u03b8\u03b1\u03c1\u03b5\u03c5", "\u03c0\u03bb\u03b5", "\u03c4\u03c3\u03b1"), false);
    private static final CharArraySet exc15a = new CharArraySet(Arrays.asList("\u03b1\u03b2\u03b1\u03c3\u03c4", "\u03c0\u03bf\u03bb\u03c5\u03c6", "\u03b1\u03b4\u03b7\u03c6", "\u03c0\u03b1\u03bc\u03c6", "\u03c1", "\u03b1\u03c3\u03c0", "\u03b1\u03c6", "\u03b1\u03bc\u03b1\u03bb", "\u03b1\u03bc\u03b1\u03bb\u03bb\u03b9", "\u03b1\u03bd\u03c5\u03c3\u03c4", "\u03b1\u03c0\u03b5\u03c1", "\u03b1\u03c3\u03c0\u03b1\u03c1", "\u03b1\u03c7\u03b1\u03c1", "\u03b4\u03b5\u03c1\u03b2\u03b5\u03bd", "\u03b4\u03c1\u03bf\u03c3\u03bf\u03c0", "\u03be\u03b5\u03c6", "\u03bd\u03b5\u03bf\u03c0", "\u03bd\u03bf\u03bc\u03bf\u03c4", "\u03bf\u03bb\u03bf\u03c0", "\u03bf\u03bc\u03bf\u03c4", "\u03c0\u03c1\u03bf\u03c3\u03c4", "\u03c0\u03c1\u03bf\u03c3\u03c9\u03c0\u03bf\u03c0", "\u03c3\u03c5\u03bc\u03c0", "\u03c3\u03c5\u03bd\u03c4", "\u03c4", "\u03c5\u03c0\u03bf\u03c4", "\u03c7\u03b1\u03c1", "\u03b1\u03b5\u03b9\u03c0", "\u03b1\u03b9\u03bc\u03bf\u03c3\u03c4", "\u03b1\u03bd\u03c5\u03c0", "\u03b1\u03c0\u03bf\u03c4", "\u03b1\u03c1\u03c4\u03b9\u03c0", "\u03b4\u03b9\u03b1\u03c4", "\u03b5\u03bd", "\u03b5\u03c0\u03b9\u03c4", "\u03ba\u03c1\u03bf\u03ba\u03b1\u03bb\u03bf\u03c0", "\u03c3\u03b9\u03b4\u03b7\u03c1\u03bf\u03c0", "\u03bb", "\u03bd\u03b1\u03c5", "\u03bf\u03c5\u03bb\u03b1\u03bc", "\u03bf\u03c5\u03c1", "\u03c0", "\u03c4\u03c1", "\u03bc"), false);
    private static final CharArraySet exc15b = new CharArraySet(Arrays.asList("\u03c8\u03bf\u03c6", "\u03bd\u03b1\u03c5\u03bb\u03bf\u03c7"), false);
    private static final CharArraySet exc16 = new CharArraySet(Arrays.asList("\u03bd", "\u03c7\u03b5\u03c1\u03c3\u03bf\u03bd", "\u03b4\u03c9\u03b4\u03b5\u03ba\u03b1\u03bd", "\u03b5\u03c1\u03b7\u03bc\u03bf\u03bd", "\u03bc\u03b5\u03b3\u03b1\u03bb\u03bf\u03bd", "\u03b5\u03c0\u03c4\u03b1\u03bd"), false);
    private static final CharArraySet exc17 = new CharArraySet(Arrays.asList("\u03b1\u03c3\u03b2", "\u03c3\u03b2", "\u03b1\u03c7\u03c1", "\u03c7\u03c1", "\u03b1\u03c0\u03bb", "\u03b1\u03b5\u03b9\u03bc\u03bd", "\u03b4\u03c5\u03c3\u03c7\u03c1", "\u03b5\u03c5\u03c7\u03c1", "\u03ba\u03bf\u03b9\u03bd\u03bf\u03c7\u03c1", "\u03c0\u03b1\u03bb\u03b9\u03bc\u03c8"), false);
    private static final CharArraySet exc18 = new CharArraySet(Arrays.asList("\u03bd", "\u03c1", "\u03c3\u03c0\u03b9", "\u03c3\u03c4\u03c1\u03b1\u03b2\u03bf\u03bc\u03bf\u03c5\u03c4\u03c3", "\u03ba\u03b1\u03ba\u03bf\u03bc\u03bf\u03c5\u03c4\u03c3", "\u03b5\u03be\u03c9\u03bd"), false);
    private static final CharArraySet exc19 = new CharArraySet(Arrays.asList("\u03c0\u03b1\u03c1\u03b1\u03c3\u03bf\u03c5\u03c3", "\u03c6", "\u03c7", "\u03c9\u03c1\u03b9\u03bf\u03c0\u03bb", "\u03b1\u03b6", "\u03b1\u03bb\u03bb\u03bf\u03c3\u03bf\u03c5\u03c3", "\u03b1\u03c3\u03bf\u03c5\u03c3"), false);

    GreekStemmer() {
    }

    int stem(char[] cArray, int n) {
        if (n < 4) {
            return n;
        }
        int n2 = n;
        n = this.rule0(cArray, n);
        n = this.rule1(cArray, n);
        n = this.rule2(cArray, n);
        n = this.rule3(cArray, n);
        n = this.rule4(cArray, n);
        n = this.rule5(cArray, n);
        n = this.rule6(cArray, n);
        n = this.rule7(cArray, n);
        n = this.rule8(cArray, n);
        n = this.rule9(cArray, n);
        n = this.rule10(cArray, n);
        n = this.rule11(cArray, n);
        n = this.rule12(cArray, n);
        n = this.rule13(cArray, n);
        n = this.rule14(cArray, n);
        n = this.rule15(cArray, n);
        n = this.rule16(cArray, n);
        n = this.rule17(cArray, n);
        n = this.rule18(cArray, n);
        n = this.rule19(cArray, n);
        if ((n = this.rule20(cArray, n)) == n2) {
            n = this.rule21(cArray, n);
        }
        return this.rule22(cArray, n);
    }

    private int rule0(char[] cArray, int n) {
        if (n > 9 && (this.endsWith(cArray, n, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03c9\u03bd"))) {
            return n - 4;
        }
        if (n > 8 && (this.endsWith(cArray, n, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03c9\u03bd"))) {
            return n - 4;
        }
        if (n > 8 && this.endsWith(cArray, n, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c4\u03b1")) {
            return n - 3;
        }
        if (n > 7 && (this.endsWith(cArray, n, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03c9\u03bd"))) {
            return n - 4;
        }
        if (n > 7 && this.endsWith(cArray, n, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c4\u03b1")) {
            return n - 3;
        }
        if (n > 7 && this.endsWith(cArray, n, "\u03ba\u03b1\u03b8\u03b5\u03c3\u03c4\u03c9\u03c3")) {
            return n - 2;
        }
        if (n > 6 && this.endsWith(cArray, n, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03c9\u03bd") || this.endsWith(cArray, n, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03c9\u03bd") || this.endsWith(cArray, n, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03c9\u03bd") || this.endsWith(cArray, n, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03c9\u03bd") || this.endsWith(cArray, n, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03c9\u03bd")) {
            return n - 4;
        }
        if (n > 6 && this.endsWith(cArray, n, "\u03c4\u03b1\u03c4\u03bf\u03b3\u03b9\u03b1")) {
            return n - 3;
        }
        if (n > 6 && this.endsWith(cArray, n, "\u03b3\u03b5\u03b3\u03bf\u03bd\u03bf\u03c3")) {
            return n - 2;
        }
        if (n > 5 && (this.endsWith(cArray, n, "\u03c6\u03b1\u03b3\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03c6\u03b1\u03b3\u03b9\u03c9\u03bd") || this.endsWith(cArray, n, "\u03c3\u03bf\u03b3\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03c3\u03bf\u03b3\u03b9\u03c9\u03bd"))) {
            return n - 4;
        }
        if (n > 5 && (this.endsWith(cArray, n, "\u03c3\u03ba\u03b1\u03b3\u03b9\u03b1") || this.endsWith(cArray, n, "\u03bf\u03bb\u03bf\u03b3\u03b9\u03b1") || this.endsWith(cArray, n, "\u03ba\u03c1\u03b5\u03b1\u03c4\u03b1") || this.endsWith(cArray, n, "\u03c0\u03b5\u03c1\u03b1\u03c4\u03b1") || this.endsWith(cArray, n, "\u03c4\u03b5\u03c1\u03b1\u03c4\u03b1"))) {
            return n - 3;
        }
        if (n > 4 && (this.endsWith(cArray, n, "\u03c6\u03b1\u03b3\u03b9\u03b1") || this.endsWith(cArray, n, "\u03c3\u03bf\u03b3\u03b9\u03b1") || this.endsWith(cArray, n, "\u03c6\u03c9\u03c4\u03bf\u03c3") || this.endsWith(cArray, n, "\u03c6\u03c9\u03c4\u03c9\u03bd"))) {
            return n - 3;
        }
        if (n > 4 && (this.endsWith(cArray, n, "\u03ba\u03c1\u03b5\u03b1\u03c3") || this.endsWith(cArray, n, "\u03c0\u03b5\u03c1\u03b1\u03c3") || this.endsWith(cArray, n, "\u03c4\u03b5\u03c1\u03b1\u03c3"))) {
            return n - 2;
        }
        if (n > 3 && this.endsWith(cArray, n, "\u03c6\u03c9\u03c4\u03b1")) {
            return n - 2;
        }
        if (n > 2 && this.endsWith(cArray, n, "\u03c6\u03c9\u03c3")) {
            return n - 1;
        }
        return n;
    }

    private int rule1(char[] cArray, int n) {
        if (!(n <= 4 || !this.endsWith(cArray, n, "\u03b1\u03b4\u03b5\u03c3") && !this.endsWith(cArray, n, "\u03b1\u03b4\u03c9\u03bd") || this.endsWith(cArray, n -= 4, "\u03bf\u03ba") || this.endsWith(cArray, n, "\u03bc\u03b1\u03bc") || this.endsWith(cArray, n, "\u03bc\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bc\u03c0\u03b1\u03bc\u03c0") || this.endsWith(cArray, n, "\u03c0\u03b1\u03c4\u03b5\u03c1") || this.endsWith(cArray, n, "\u03b3\u03b9\u03b1\u03b3\u03b9") || this.endsWith(cArray, n, "\u03bd\u03c4\u03b1\u03bd\u03c4") || this.endsWith(cArray, n, "\u03ba\u03c5\u03c1") || this.endsWith(cArray, n, "\u03b8\u03b5\u03b9") || this.endsWith(cArray, n, "\u03c0\u03b5\u03b8\u03b5\u03c1"))) {
            n += 2;
        }
        return n;
    }

    private int rule2(char[] cArray, int n) {
        if (n > 4 && (this.endsWith(cArray, n, "\u03b5\u03b4\u03b5\u03c3") || this.endsWith(cArray, n, "\u03b5\u03b4\u03c9\u03bd")) && (this.endsWith(cArray, n -= 4, "\u03bf\u03c0") || this.endsWith(cArray, n, "\u03b9\u03c0") || this.endsWith(cArray, n, "\u03b5\u03bc\u03c0") || this.endsWith(cArray, n, "\u03c5\u03c0") || this.endsWith(cArray, n, "\u03b3\u03b7\u03c0") || this.endsWith(cArray, n, "\u03b4\u03b1\u03c0") || this.endsWith(cArray, n, "\u03ba\u03c1\u03b1\u03c3\u03c0") || this.endsWith(cArray, n, "\u03bc\u03b9\u03bb"))) {
            n += 2;
        }
        return n;
    }

    private int rule3(char[] cArray, int n) {
        if (n > 5 && (this.endsWith(cArray, n, "\u03bf\u03c5\u03b4\u03b5\u03c3") || this.endsWith(cArray, n, "\u03bf\u03c5\u03b4\u03c9\u03bd")) && (this.endsWith(cArray, n -= 5, "\u03b1\u03c1\u03ba") || this.endsWith(cArray, n, "\u03ba\u03b1\u03bb\u03b9\u03b1\u03ba") || this.endsWith(cArray, n, "\u03c0\u03b5\u03c4\u03b1\u03bb") || this.endsWith(cArray, n, "\u03bb\u03b9\u03c7") || this.endsWith(cArray, n, "\u03c0\u03bb\u03b5\u03be") || this.endsWith(cArray, n, "\u03c3\u03ba") || this.endsWith(cArray, n, "\u03c3") || this.endsWith(cArray, n, "\u03c6\u03bb") || this.endsWith(cArray, n, "\u03c6\u03c1") || this.endsWith(cArray, n, "\u03b2\u03b5\u03bb") || this.endsWith(cArray, n, "\u03bb\u03bf\u03c5\u03bb") || this.endsWith(cArray, n, "\u03c7\u03bd") || this.endsWith(cArray, n, "\u03c3\u03c0") || this.endsWith(cArray, n, "\u03c4\u03c1\u03b1\u03b3") || this.endsWith(cArray, n, "\u03c6\u03b5"))) {
            n += 3;
        }
        return n;
    }

    private int rule4(char[] cArray, int n) {
        if (n > 3 && (this.endsWith(cArray, n, "\u03b5\u03c9\u03c3") || this.endsWith(cArray, n, "\u03b5\u03c9\u03bd")) && exc4.contains(cArray, 0, n -= 3)) {
            ++n;
        }
        return n;
    }

    private int rule5(char[] cArray, int n) {
        if (n > 2 && this.endsWith(cArray, n, "\u03b9\u03b1")) {
            if (this.endsWithVowel(cArray, n -= 2)) {
                ++n;
            }
        } else if (n > 3 && (this.endsWith(cArray, n, "\u03b9\u03bf\u03c5") || this.endsWith(cArray, n, "\u03b9\u03c9\u03bd")) && this.endsWithVowel(cArray, n -= 3)) {
            ++n;
        }
        return n;
    }

    private int rule6(char[] cArray, int n) {
        boolean bl = false;
        if (n > 3 && (this.endsWith(cArray, n, "\u03b9\u03ba\u03b1") || this.endsWith(cArray, n, "\u03b9\u03ba\u03bf"))) {
            n -= 3;
            bl = true;
        } else if (n > 4 && (this.endsWith(cArray, n, "\u03b9\u03ba\u03bf\u03c5") || this.endsWith(cArray, n, "\u03b9\u03ba\u03c9\u03bd"))) {
            n -= 4;
            bl = true;
        }
        if (bl && (this.endsWithVowel(cArray, n) || exc6.contains(cArray, 0, n))) {
            n += 2;
        }
        return n;
    }

    private int rule7(char[] cArray, int n) {
        if (n == 5 && this.endsWith(cArray, n, "\u03b1\u03b3\u03b1\u03bc\u03b5")) {
            return n - 1;
        }
        if (n > 7 && this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bc\u03b5")) {
            n -= 7;
        } else if (n > 6 && this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b1\u03bc\u03b5")) {
            n -= 6;
        } else if (n > 5 && (this.endsWith(cArray, n, "\u03b1\u03b3\u03b1\u03bc\u03b5") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b1\u03bc\u03b5") || this.endsWith(cArray, n, "\u03b7\u03ba\u03b1\u03bc\u03b5"))) {
            n -= 5;
        }
        if (n > 3 && this.endsWith(cArray, n, "\u03b1\u03bc\u03b5") && exc7.contains(cArray, 0, n -= 3)) {
            n += 2;
        }
        return n;
    }

    private int rule8(char[] cArray, int n) {
        boolean bl = false;
        if (n > 8 && this.endsWith(cArray, n, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd\u03b5")) {
            n -= 8;
            bl = true;
        } else if (n > 7 && this.endsWith(cArray, n, "\u03b9\u03bf\u03bd\u03c4\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bd\u03b5")) {
            n -= 7;
            bl = true;
        } else if (n > 6 && this.endsWith(cArray, n, "\u03b9\u03bf\u03c4\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03bf\u03bd\u03c4\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b1\u03bd\u03b5")) {
            n -= 6;
            bl = true;
        } else if (n > 5 && this.endsWith(cArray, n, "\u03b1\u03b3\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03bf\u03c4\u03b1\u03bd\u03b5") || this.endsWith(cArray, n, "\u03b7\u03ba\u03b1\u03bd\u03b5")) {
            n -= 5;
            bl = true;
        }
        if (bl && exc8a.contains(cArray, 0, n)) {
            cArray[(n += 4) - 4] = 945;
            cArray[n - 3] = 947;
            cArray[n - 2] = 945;
            cArray[n - 1] = 957;
        }
        if (n > 3 && this.endsWith(cArray, n, "\u03b1\u03bd\u03b5") && (this.endsWithVowelNoY(cArray, n -= 3) || exc8b.contains(cArray, 0, n))) {
            n += 2;
        }
        return n;
    }

    private int rule9(char[] cArray, int n) {
        if (n > 5 && this.endsWith(cArray, n, "\u03b7\u03c3\u03b5\u03c4\u03b5")) {
            n -= 5;
        }
        if (n > 3 && this.endsWith(cArray, n, "\u03b5\u03c4\u03b5") && (exc9.contains(cArray, 0, n -= 3) || this.endsWithVowelNoY(cArray, n) || this.endsWith(cArray, n, "\u03bf\u03b4") || this.endsWith(cArray, n, "\u03b1\u03b9\u03c1") || this.endsWith(cArray, n, "\u03c6\u03bf\u03c1") || this.endsWith(cArray, n, "\u03c4\u03b1\u03b8") || this.endsWith(cArray, n, "\u03b4\u03b9\u03b1\u03b8") || this.endsWith(cArray, n, "\u03c3\u03c7") || this.endsWith(cArray, n, "\u03b5\u03bd\u03b4") || this.endsWith(cArray, n, "\u03b5\u03c5\u03c1") || this.endsWith(cArray, n, "\u03c4\u03b9\u03b8") || this.endsWith(cArray, n, "\u03c5\u03c0\u03b5\u03c1\u03b8") || this.endsWith(cArray, n, "\u03c1\u03b1\u03b8") || this.endsWith(cArray, n, "\u03b5\u03bd\u03b8") || this.endsWith(cArray, n, "\u03c1\u03bf\u03b8") || this.endsWith(cArray, n, "\u03c3\u03b8") || this.endsWith(cArray, n, "\u03c0\u03c5\u03c1") || this.endsWith(cArray, n, "\u03b1\u03b9\u03bd") || this.endsWith(cArray, n, "\u03c3\u03c5\u03bd\u03b4") || this.endsWith(cArray, n, "\u03c3\u03c5\u03bd") || this.endsWith(cArray, n, "\u03c3\u03c5\u03bd\u03b8") || this.endsWith(cArray, n, "\u03c7\u03c9\u03c1") || this.endsWith(cArray, n, "\u03c0\u03bf\u03bd") || this.endsWith(cArray, n, "\u03b2\u03c1") || this.endsWith(cArray, n, "\u03ba\u03b1\u03b8") || this.endsWith(cArray, n, "\u03b5\u03c5\u03b8") || this.endsWith(cArray, n, "\u03b5\u03ba\u03b8") || this.endsWith(cArray, n, "\u03bd\u03b5\u03c4") || this.endsWith(cArray, n, "\u03c1\u03bf\u03bd") || this.endsWith(cArray, n, "\u03b1\u03c1\u03ba") || this.endsWith(cArray, n, "\u03b2\u03b1\u03c1") || this.endsWith(cArray, n, "\u03b2\u03bf\u03bb") || this.endsWith(cArray, n, "\u03c9\u03c6\u03b5\u03bb"))) {
            n += 2;
        }
        return n;
    }

    private int rule10(char[] cArray, int n) {
        if (n > 5 && (this.endsWith(cArray, n, "\u03bf\u03bd\u03c4\u03b1\u03c3") || this.endsWith(cArray, n, "\u03c9\u03bd\u03c4\u03b1\u03c3"))) {
            if ((n -= 5) == 3 && this.endsWith(cArray, n, "\u03b1\u03c1\u03c7")) {
                cArray[(n += 3) - 3] = 959;
            }
            if (this.endsWith(cArray, n, "\u03ba\u03c1\u03b5")) {
                cArray[(n += 3) - 3] = 969;
            }
        }
        return n;
    }

    private int rule11(char[] cArray, int n) {
        if (n > 6 && this.endsWith(cArray, n, "\u03bf\u03bc\u03b1\u03c3\u03c4\u03b5")) {
            if ((n -= 6) == 2 && this.endsWith(cArray, n, "\u03bf\u03bd")) {
                n += 5;
            }
        } else if (n > 7 && this.endsWith(cArray, n, "\u03b9\u03bf\u03bc\u03b1\u03c3\u03c4\u03b5") && (n -= 7) == 2 && this.endsWith(cArray, n, "\u03bf\u03bd")) {
            cArray[(n += 5) - 5] = 959;
            cArray[n - 4] = 956;
            cArray[n - 3] = 945;
            cArray[n - 2] = 963;
            cArray[n - 1] = 964;
        }
        return n;
    }

    private int rule12(char[] cArray, int n) {
        if (n > 5 && this.endsWith(cArray, n, "\u03b9\u03b5\u03c3\u03c4\u03b5") && exc12a.contains(cArray, 0, n -= 5)) {
            n += 4;
        }
        if (n > 4 && this.endsWith(cArray, n, "\u03b5\u03c3\u03c4\u03b5") && exc12b.contains(cArray, 0, n -= 4)) {
            n += 3;
        }
        return n;
    }

    private int rule13(char[] cArray, int n) {
        if (n > 6 && this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b5\u03c3")) {
            n -= 6;
        } else if (n > 5 && (this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b1") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b5"))) {
            n -= 5;
        }
        boolean bl = false;
        if (n > 4 && this.endsWith(cArray, n, "\u03b7\u03ba\u03b5\u03c3")) {
            n -= 4;
            bl = true;
        } else if (n > 3 && (this.endsWith(cArray, n, "\u03b7\u03ba\u03b1") || this.endsWith(cArray, n, "\u03b7\u03ba\u03b5"))) {
            n -= 3;
            bl = true;
        }
        if (bl && (exc13.contains(cArray, 0, n) || this.endsWith(cArray, n, "\u03c3\u03ba\u03c9\u03bb") || this.endsWith(cArray, n, "\u03c3\u03ba\u03bf\u03c5\u03bb") || this.endsWith(cArray, n, "\u03bd\u03b1\u03c1\u03b8") || this.endsWith(cArray, n, "\u03c3\u03c6") || this.endsWith(cArray, n, "\u03bf\u03b8") || this.endsWith(cArray, n, "\u03c0\u03b9\u03b8"))) {
            n += 2;
        }
        return n;
    }

    private int rule14(char[] cArray, int n) {
        boolean bl = false;
        if (n > 5 && this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b5\u03c3")) {
            n -= 5;
            bl = true;
        } else if (n > 4 && (this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b1") || this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b5"))) {
            n -= 4;
            bl = true;
        }
        if (bl && (exc14.contains(cArray, 0, n) || this.endsWithVowel(cArray, n) || this.endsWith(cArray, n, "\u03c0\u03bf\u03b4\u03b1\u03c1") || this.endsWith(cArray, n, "\u03b2\u03bb\u03b5\u03c0") || this.endsWith(cArray, n, "\u03c0\u03b1\u03bd\u03c4\u03b1\u03c7") || this.endsWith(cArray, n, "\u03c6\u03c1\u03c5\u03b4") || this.endsWith(cArray, n, "\u03bc\u03b1\u03bd\u03c4\u03b9\u03bb") || this.endsWith(cArray, n, "\u03bc\u03b1\u03bb\u03bb") || this.endsWith(cArray, n, "\u03ba\u03c5\u03bc\u03b1\u03c4") || this.endsWith(cArray, n, "\u03bb\u03b1\u03c7") || this.endsWith(cArray, n, "\u03bb\u03b7\u03b3") || this.endsWith(cArray, n, "\u03c6\u03b1\u03b3") || this.endsWith(cArray, n, "\u03bf\u03bc") || this.endsWith(cArray, n, "\u03c0\u03c1\u03c9\u03c4"))) {
            n += 3;
        }
        return n;
    }

    private int rule15(char[] cArray, int n) {
        boolean bl = false;
        if (n > 4 && this.endsWith(cArray, n, "\u03b1\u03b3\u03b5\u03c3")) {
            n -= 4;
            bl = true;
        } else if (n > 3 && (this.endsWith(cArray, n, "\u03b1\u03b3\u03b1") || this.endsWith(cArray, n, "\u03b1\u03b3\u03b5"))) {
            n -= 3;
            bl = true;
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = exc15a.contains(cArray, 0, n) || this.endsWith(cArray, n, "\u03bf\u03c6") || this.endsWith(cArray, n, "\u03c0\u03b5\u03bb") || this.endsWith(cArray, n, "\u03c7\u03bf\u03c1\u03c4") || this.endsWith(cArray, n, "\u03bb\u03bb") || this.endsWith(cArray, n, "\u03c3\u03c6") || this.endsWith(cArray, n, "\u03c1\u03c0") || this.endsWith(cArray, n, "\u03c6\u03c1") || this.endsWith(cArray, n, "\u03c0\u03c1") || this.endsWith(cArray, n, "\u03bb\u03bf\u03c7") || this.endsWith(cArray, n, "\u03c3\u03bc\u03b7\u03bd");
            boolean bl4 = bl2 = exc15b.contains(cArray, 0, n) || this.endsWith(cArray, n, "\u03ba\u03bf\u03bb\u03bb");
            if (bl3 && !bl2) {
                n += 2;
            }
        }
        return n;
    }

    private int rule16(char[] cArray, int n) {
        boolean bl = false;
        if (n > 4 && this.endsWith(cArray, n, "\u03b7\u03c3\u03bf\u03c5")) {
            n -= 4;
            bl = true;
        } else if (n > 3 && (this.endsWith(cArray, n, "\u03b7\u03c3\u03b5") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b1"))) {
            n -= 3;
            bl = true;
        }
        if (bl && exc16.contains(cArray, 0, n)) {
            n += 2;
        }
        return n;
    }

    private int rule17(char[] cArray, int n) {
        if (n > 4 && this.endsWith(cArray, n, "\u03b7\u03c3\u03c4\u03b5") && exc17.contains(cArray, 0, n -= 4)) {
            n += 3;
        }
        return n;
    }

    private int rule18(char[] cArray, int n) {
        boolean bl = false;
        if (n > 6 && (this.endsWith(cArray, n, "\u03b7\u03c3\u03bf\u03c5\u03bd\u03b5") || this.endsWith(cArray, n, "\u03b7\u03b8\u03bf\u03c5\u03bd\u03b5"))) {
            n -= 6;
            bl = true;
        } else if (n > 4 && this.endsWith(cArray, n, "\u03bf\u03c5\u03bd\u03b5")) {
            n -= 4;
            bl = true;
        }
        if (bl && exc18.contains(cArray, 0, n)) {
            cArray[(n += 3) - 3] = 959;
            cArray[n - 2] = 965;
            cArray[n - 1] = 957;
        }
        return n;
    }

    private int rule19(char[] cArray, int n) {
        boolean bl = false;
        if (n > 6 && (this.endsWith(cArray, n, "\u03b7\u03c3\u03bf\u03c5\u03bc\u03b5") || this.endsWith(cArray, n, "\u03b7\u03b8\u03bf\u03c5\u03bc\u03b5"))) {
            n -= 6;
            bl = true;
        } else if (n > 4 && this.endsWith(cArray, n, "\u03bf\u03c5\u03bc\u03b5")) {
            n -= 4;
            bl = true;
        }
        if (bl && exc19.contains(cArray, 0, n)) {
            cArray[(n += 3) - 3] = 959;
            cArray[n - 2] = 965;
            cArray[n - 1] = 956;
        }
        return n;
    }

    private int rule20(char[] cArray, int n) {
        if (n > 5 && (this.endsWith(cArray, n, "\u03bc\u03b1\u03c4\u03c9\u03bd") || this.endsWith(cArray, n, "\u03bc\u03b1\u03c4\u03bf\u03c3"))) {
            n -= 3;
        } else if (n > 4 && this.endsWith(cArray, n, "\u03bc\u03b1\u03c4\u03b1")) {
            n -= 2;
        }
        return n;
    }

    private int rule21(char[] cArray, int n) {
        if (n > 9 && this.endsWith(cArray, n, "\u03b9\u03bf\u03bd\u03c4\u03bf\u03c5\u03c3\u03b1\u03bd")) {
            return n - 9;
        }
        if (n > 8 && (this.endsWith(cArray, n, "\u03b9\u03bf\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c5\u03bc\u03b1\u03c3\u03c4\u03b5") || this.endsWith(cArray, n, "\u03bf\u03bd\u03c4\u03bf\u03c5\u03c3\u03b1\u03bd"))) {
            return n - 8;
        }
        if (n > 7 && (this.endsWith(cArray, n, "\u03b9\u03b5\u03bc\u03b1\u03c3\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b9\u03b5\u03c3\u03b1\u03c3\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b9\u03bf\u03bc\u03bf\u03c5\u03bd\u03b1") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c3\u03b1\u03c3\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c3\u03bf\u03c5\u03bd\u03b1") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03c4\u03b5") || this.endsWith(cArray, n, "\u03bf\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bc\u03b1\u03c3\u03c4\u03b5"))) {
            return n - 7;
        }
        if (n > 6 && (this.endsWith(cArray, n, "\u03b9\u03bf\u03bc\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03b9\u03bf\u03bd\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c3\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b5\u03b9\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b7\u03ba\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bf\u03bc\u03bf\u03c5\u03bd\u03b1") || this.endsWith(cArray, n, "\u03bf\u03c3\u03b1\u03c3\u03c4\u03b5") || this.endsWith(cArray, n, "\u03bf\u03c3\u03bf\u03c5\u03bd\u03b1") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bd\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b1\u03c4\u03b5"))) {
            return n - 6;
        }
        if (n > 5 && (this.endsWith(cArray, n, "\u03b1\u03b3\u03b1\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b9\u03b5\u03bc\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b9\u03b5\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b9\u03b5\u03c3\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b9\u03bf\u03c5\u03bc\u03b1") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b5\u03b9\u03c3") || this.endsWith(cArray, n, "\u03b7\u03b8\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03b7\u03ba\u03b1\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b1\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b7\u03c3\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03bf\u03bc\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03bf\u03bd\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03bf\u03bd\u03c4\u03b1\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c3\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bc\u03b1\u03b9") || this.endsWith(cArray, n, "\u03bf\u03c5\u03c3\u03b1\u03bd"))) {
            return n - 5;
        }
        if (n > 4 && (this.endsWith(cArray, n, "\u03b1\u03b3\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b1\u03bc\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b1\u03c3\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b1\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b5\u03b9\u03c4\u03b5") || this.endsWith(cArray, n, "\u03b5\u03c3\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b5\u03c4\u03b1\u03b9") || this.endsWith(cArray, n, "\u03b7\u03b4\u03b5\u03c3") || this.endsWith(cArray, n, "\u03b7\u03b4\u03c9\u03bd") || this.endsWith(cArray, n, "\u03b7\u03b8\u03b5\u03b9") || this.endsWith(cArray, n, "\u03b7\u03ba\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b5\u03b9") || this.endsWith(cArray, n, "\u03b7\u03c3\u03b5\u03c3") || this.endsWith(cArray, n, "\u03bf\u03bc\u03b1\u03b9") || this.endsWith(cArray, n, "\u03bf\u03c4\u03b1\u03bd"))) {
            return n - 4;
        }
        if (n > 3 && (this.endsWith(cArray, n, "\u03b1\u03b5\u03b9") || this.endsWith(cArray, n, "\u03b5\u03b9\u03c3") || this.endsWith(cArray, n, "\u03b7\u03b8\u03c9") || this.endsWith(cArray, n, "\u03b7\u03c3\u03c9") || this.endsWith(cArray, n, "\u03bf\u03c5\u03bd") || this.endsWith(cArray, n, "\u03bf\u03c5\u03c3"))) {
            return n - 3;
        }
        if (n > 2 && (this.endsWith(cArray, n, "\u03b1\u03bd") || this.endsWith(cArray, n, "\u03b1\u03c3") || this.endsWith(cArray, n, "\u03b1\u03c9") || this.endsWith(cArray, n, "\u03b5\u03b9") || this.endsWith(cArray, n, "\u03b5\u03c3") || this.endsWith(cArray, n, "\u03b7\u03c3") || this.endsWith(cArray, n, "\u03bf\u03b9") || this.endsWith(cArray, n, "\u03bf\u03c3") || this.endsWith(cArray, n, "\u03bf\u03c5") || this.endsWith(cArray, n, "\u03c5\u03c3") || this.endsWith(cArray, n, "\u03c9\u03bd"))) {
            return n - 2;
        }
        if (n > 1 && this.endsWithVowel(cArray, n)) {
            return n - 1;
        }
        return n;
    }

    private int rule22(char[] cArray, int n) {
        if (this.endsWith(cArray, n, "\u03b5\u03c3\u03c4\u03b5\u03c1") || this.endsWith(cArray, n, "\u03b5\u03c3\u03c4\u03b1\u03c4")) {
            return n - 5;
        }
        if (this.endsWith(cArray, n, "\u03bf\u03c4\u03b5\u03c1") || this.endsWith(cArray, n, "\u03bf\u03c4\u03b1\u03c4") || this.endsWith(cArray, n, "\u03c5\u03c4\u03b5\u03c1") || this.endsWith(cArray, n, "\u03c5\u03c4\u03b1\u03c4") || this.endsWith(cArray, n, "\u03c9\u03c4\u03b5\u03c1") || this.endsWith(cArray, n, "\u03c9\u03c4\u03b1\u03c4")) {
            return n - 4;
        }
        return n;
    }

    private boolean endsWith(char[] cArray, int n, String string) {
        int n2 = string.length();
        if (n2 > n) {
            return false;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            if (cArray[n - (n2 - i)] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean endsWithVowel(char[] cArray, int n) {
        if (n == 0) {
            return false;
        }
        switch (cArray[n - 1]) {
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03b9': 
            case '\u03bf': 
            case '\u03c5': 
            case '\u03c9': {
                return true;
            }
        }
        return false;
    }

    private boolean endsWithVowelNoY(char[] cArray, int n) {
        if (n == 0) {
            return false;
        }
        switch (cArray[n - 1]) {
            case '\u03b1': 
            case '\u03b5': 
            case '\u03b7': 
            case '\u03b9': 
            case '\u03bf': 
            case '\u03c9': {
                return true;
            }
        }
        return false;
    }
}

