/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import org.carrot2.lucene.analysis.StemmerUtil;

class IndonesianStemmer {
    private int numSyllables;
    private int flags;
    private static final int REMOVED_KE = 1;
    private static final int REMOVED_PENG = 2;
    private static final int REMOVED_DI = 4;
    private static final int REMOVED_MENG = 8;
    private static final int REMOVED_TER = 16;
    private static final int REMOVED_BER = 32;
    private static final int REMOVED_PE = 64;

    IndonesianStemmer() {
    }

    int stem(char[] cArray, int n, boolean bl) {
        this.flags = 0;
        this.numSyllables = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isVowel(cArray[i])) continue;
            ++this.numSyllables;
        }
        if (this.numSyllables > 2) {
            n = this.removeParticle(cArray, n);
        }
        if (this.numSyllables > 2) {
            n = this.removePossessivePronoun(cArray, n);
        }
        if (bl) {
            n = this.stemDerivational(cArray, n);
        }
        return n;
    }

    private int stemDerivational(char[] cArray, int n) {
        int n2 = n;
        if (this.numSyllables > 2) {
            n = this.removeFirstOrderPrefix(cArray, n);
        }
        if (n2 != n) {
            n2 = n;
            if (this.numSyllables > 2) {
                n = this.removeSuffix(cArray, n);
            }
            if (n2 != n && this.numSyllables > 2) {
                n = this.removeSecondOrderPrefix(cArray, n);
            }
        } else {
            if (this.numSyllables > 2) {
                n = this.removeSecondOrderPrefix(cArray, n);
            }
            if (this.numSyllables > 2) {
                n = this.removeSuffix(cArray, n);
            }
        }
        return n;
    }

    private boolean isVowel(char c) {
        switch (c) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    private int removeParticle(char[] cArray, int n) {
        if (StemmerUtil.endsWith(cArray, n, "kah") || StemmerUtil.endsWith(cArray, n, "lah") || StemmerUtil.endsWith(cArray, n, "pun")) {
            --this.numSyllables;
            return n - 3;
        }
        return n;
    }

    private int removePossessivePronoun(char[] cArray, int n) {
        if (StemmerUtil.endsWith(cArray, n, "ku") || StemmerUtil.endsWith(cArray, n, "mu")) {
            --this.numSyllables;
            return n - 2;
        }
        if (StemmerUtil.endsWith(cArray, n, "nya")) {
            --this.numSyllables;
            return n - 3;
        }
        return n;
    }

    private int removeFirstOrderPrefix(char[] cArray, int n) {
        if (StemmerUtil.startsWith(cArray, n, "meng")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 4);
        }
        if (StemmerUtil.startsWith(cArray, n, "meny") && n > 4 && this.isVowel(cArray[4])) {
            this.flags |= 8;
            cArray[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "men")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "mem")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "me")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        if (StemmerUtil.startsWith(cArray, n, "peng")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 4);
        }
        if (StemmerUtil.startsWith(cArray, n, "peny") && n > 4 && this.isVowel(cArray[4])) {
            this.flags |= 2;
            cArray[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "peny")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 4);
        }
        if (StemmerUtil.startsWith(cArray, n, "pen") && n > 3 && this.isVowel(cArray[3])) {
            this.flags |= 2;
            cArray[2] = 116;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        if (StemmerUtil.startsWith(cArray, n, "pen")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "pem")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "di")) {
            this.flags |= 4;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        if (StemmerUtil.startsWith(cArray, n, "ter")) {
            this.flags |= 0x10;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "ke")) {
            this.flags |= 1;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        return n;
    }

    private int removeSecondOrderPrefix(char[] cArray, int n) {
        if (StemmerUtil.startsWith(cArray, n, "ber")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (n == 7 && StemmerUtil.startsWith(cArray, n, "belajar")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "be") && n > 4 && !this.isVowel(cArray[2]) && cArray[3] == 'e' && cArray[4] == 'r') {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        if (StemmerUtil.startsWith(cArray, n, "per")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (n == 7 && StemmerUtil.startsWith(cArray, n, "pelajar")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 3);
        }
        if (StemmerUtil.startsWith(cArray, n, "pe")) {
            this.flags |= 0x40;
            --this.numSyllables;
            return StemmerUtil.deleteN(cArray, 0, n, 2);
        }
        return n;
    }

    private int removeSuffix(char[] cArray, int n) {
        if (StemmerUtil.endsWith(cArray, n, "kan") && (this.flags & 1) == 0 && (this.flags & 2) == 0 && (this.flags & 0x40) == 0) {
            --this.numSyllables;
            return n - 3;
        }
        if (StemmerUtil.endsWith(cArray, n, "an") && (this.flags & 4) == 0 && (this.flags & 8) == 0 && (this.flags & 0x10) == 0) {
            --this.numSyllables;
            return n - 2;
        }
        if (StemmerUtil.endsWith(cArray, n, "i") && !StemmerUtil.endsWith(cArray, n, "si") && (this.flags & 0x20) == 0 && (this.flags & 1) == 0 && (this.flags & 2) == 0) {
            --this.numSyllables;
            return n - 1;
        }
        return n;
    }
}

