/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.lucene.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.carrot2.lucene.analysis.StemmerUtil;

public abstract class RSLPStemmerBase {
    private static final Pattern headerPattern = Pattern.compile("^\\{\\s*\"([^\"]*)\",\\s*([0-9]+),\\s*(0|1),\\s*\\{(.*)\\},\\s*$");
    private static final Pattern stripPattern = Pattern.compile("^\\{\\s*\"([^\"]*)\",\\s*([0-9]+)\\s*\\}\\s*(,|(\\}\\s*;))$");
    private static final Pattern repPattern = Pattern.compile("^\\{\\s*\"([^\"]*)\",\\s*([0-9]+),\\s*\"([^\"]*)\"\\}\\s*(,|(\\}\\s*;))$");
    private static final Pattern excPattern = Pattern.compile("^\\{\\s*\"([^\"]*)\",\\s*([0-9]+),\\s*\"([^\"]*)\",\\s*\\{(.*)\\}\\s*\\}\\s*(,|(\\}\\s*;))$");

    protected static Map<String, Step> parse(Class<? extends RSLPStemmerBase> clazz, String string) {
        try {
            String string2;
            InputStream inputStream = clazz.getResourceAsStream(string);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            HashMap<String, Step> hashMap = new HashMap<String, Step>();
            while ((string2 = RSLPStemmerBase.readLine(lineNumberReader)) != null) {
                Step step = RSLPStemmerBase.parseStep(lineNumberReader, string2);
                hashMap.put(step.name, step);
            }
            lineNumberReader.close();
            return hashMap;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static Step parseStep(LineNumberReader lineNumberReader, String string) throws IOException {
        Matcher matcher = headerPattern.matcher(string);
        if (!matcher.find()) {
            throw new RuntimeException("Illegal Step header specified at line " + lineNumberReader.getLineNumber());
        }
        assert (matcher.groupCount() == 4);
        String string2 = matcher.group(1);
        int n = Integer.parseInt(matcher.group(2));
        int n2 = Integer.parseInt(matcher.group(3));
        String[] stringArray = RSLPStemmerBase.parseList(matcher.group(4));
        Rule[] ruleArray = RSLPStemmerBase.parseRules(lineNumberReader, n2);
        return new Step(string2, ruleArray, n, stringArray);
    }

    private static Rule[] parseRules(LineNumberReader lineNumberReader, int n) throws IOException {
        String string;
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        while ((string = RSLPStemmerBase.readLine(lineNumberReader)) != null) {
            Matcher matcher = stripPattern.matcher(string);
            if (matcher.matches()) {
                arrayList.add(new Rule(matcher.group(1), Integer.parseInt(matcher.group(2)), ""));
            } else {
                matcher = repPattern.matcher(string);
                if (matcher.matches()) {
                    arrayList.add(new Rule(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3)));
                } else {
                    matcher = excPattern.matcher(string);
                    if (matcher.matches()) {
                        if (n == 0) {
                            arrayList.add(new RuleWithSuffixExceptions(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), RSLPStemmerBase.parseList(matcher.group(4))));
                        } else {
                            arrayList.add(new RuleWithSetExceptions(matcher.group(1), Integer.parseInt(matcher.group(2)), matcher.group(3), RSLPStemmerBase.parseList(matcher.group(4))));
                        }
                    } else {
                        throw new RuntimeException("Illegal Step rule specified at line " + lineNumberReader.getLineNumber());
                    }
                }
            }
            if (!string.endsWith(";")) continue;
            return arrayList.toArray(new Rule[arrayList.size()]);
        }
        return null;
    }

    private static String[] parseList(String string) {
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = RSLPStemmerBase.parseString(stringArray[i].trim());
        }
        return stringArray;
    }

    private static String parseString(String string) {
        return string.substring(1, string.length() - 1);
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = null;
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.charAt(0) == '#') continue;
            return string;
        }
        return string;
    }

    protected static class Step {
        protected final String name;
        protected final Rule[] rules;
        protected final int min;
        protected final char[][] suffixes;

        public Step(String string, Rule[] ruleArray, int n, String[] stringArray) {
            this.name = string;
            this.rules = ruleArray;
            if (n == 0) {
                n = Integer.MAX_VALUE;
                for (Rule rule : ruleArray) {
                    n = Math.min(n, rule.min + rule.suffix.length);
                }
            }
            this.min = n;
            if (stringArray == null || stringArray.length == 0) {
                this.suffixes = null;
            } else {
                this.suffixes = new char[stringArray.length][];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.suffixes[i] = stringArray[i].toCharArray();
                }
            }
        }

        public int apply(char[] cArray, int n) {
            int n2;
            if (n < this.min) {
                return n;
            }
            if (this.suffixes != null) {
                n2 = 0;
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (!StemmerUtil.endsWith(cArray, n, this.suffixes[i])) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) {
                    return n;
                }
            }
            for (n2 = 0; n2 < this.rules.length; ++n2) {
                if (!this.rules[n2].matches(cArray, n)) continue;
                return this.rules[n2].replace(cArray, n);
            }
            return n;
        }
    }

    protected static class Rule {
        protected final char[] suffix;
        protected final char[] replacement;
        protected final int min;

        public Rule(String string, int n, String string2) {
            this.suffix = string.toCharArray();
            this.replacement = string2.toCharArray();
            this.min = n;
        }

        public boolean matches(char[] cArray, int n) {
            return n - this.suffix.length >= this.min && StemmerUtil.endsWith(cArray, n, this.suffix);
        }

        public int replace(char[] cArray, int n) {
            if (this.replacement.length > 0) {
                System.arraycopy(this.replacement, 0, cArray, n - this.suffix.length, this.replacement.length);
            }
            return n - this.suffix.length + this.replacement.length;
        }
    }

    protected static class RuleWithSuffixExceptions
    extends Rule {
        protected final char[][] exceptions;

        public RuleWithSuffixExceptions(String string, int n, String string2, String[] stringArray) {
            super(string, n, string2);
            int n2;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].endsWith(string)) continue;
                throw new RuntimeException("warning: useless exception '" + stringArray[n2] + "' does not end with '" + string + "'");
            }
            this.exceptions = new char[stringArray.length][];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.exceptions[n2] = stringArray[n2].toCharArray();
            }
        }

        @Override
        public boolean matches(char[] cArray, int n) {
            if (!super.matches(cArray, n)) {
                return false;
            }
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (!StemmerUtil.endsWith(cArray, n, this.exceptions[i])) continue;
                return false;
            }
            return true;
        }
    }

    protected static class RuleWithSetExceptions
    extends Rule {
        protected final CharArraySet exceptions;

        public RuleWithSetExceptions(String string, int n, String string2, String[] stringArray) {
            super(string, n, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith(string)) continue;
                throw new RuntimeException("useless exception '" + stringArray[i] + "' does not end with '" + string + "'");
            }
            this.exceptions = new CharArraySet(Arrays.asList(stringArray), false);
        }

        @Override
        public boolean matches(char[] cArray, int n) {
            return super.matches(cArray, n) && !this.exceptions.contains(cArray, 0, n);
        }
    }
}

