/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.polish;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import morfologik.stemming.WordData;
import morfologik.stemming.polish.PolishStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.LexicalData;
import org.carrot2.language.LexicalDataImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ClassRelativeResourceLookup;
import org.carrot2.util.ResourceLookup;

public class PolishLanguageComponents
implements LanguageComponentsProvider {
    public static final String NAME = "Polish";

    public Set<String> languages() {
        return Collections.singleton(NAME);
    }

    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup) throws IOException {
        LinkedHashMap components = new LinkedHashMap();
        components.put(Stemmer.class, this::createStemmer);
        components.put(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        String langPrefix = language.toLowerCase(Locale.ROOT);
        LexicalDataImpl lexicalData = new LexicalDataImpl(resourceLookup, langPrefix + ".stopwords.utf8", langPrefix + ".stoplabels.utf8");
        components.put(LexicalData.class, () -> PolishLanguageComponents.lambda$load$0((LexicalData)lexicalData));
        components.put(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        return components;
    }

    public Map<Class<?>, Supplier<?>> load(String language) throws IOException {
        return this.load(language, (ResourceLookup)new ClassRelativeResourceLookup(this.getClass()));
    }

    private Stemmer createStemmer() {
        PolishStemmer stemmer = new PolishStemmer();
        return word -> {
            List stems = stemmer.lookup(word);
            if (stems == null || stems.isEmpty()) {
                return null;
            }
            return ((WordData)stems.get(0)).getStem().toString();
        };
    }

    public String name() {
        return "Carrot2 (Polish)";
    }

    private static /* synthetic */ Object lambda$load$0(LexicalData lexicalData) {
        return lexicalData;
    }
}

