/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.polish;

import java.util.List;
import morfologik.stemming.WordData;
import morfologik.stemming.polish.PolishStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.LexicalData;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;
import org.carrot2.util.ResourceLookup;

public class PolishLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Polish";

    public PolishLanguageComponents() {
        super("Carrot2 (Polish)", NAME);
        this.registerResourceless(Stemmer.class, this::createStemmer);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
        this.register(LexicalData.class, (language, resourceLookup) -> {
            LexicalData lexicalData = PolishLanguageComponents.loadLexicalData((String)NAME, (ResourceLookup)resourceLookup);
            return () -> lexicalData;
        });
    }

    private Stemmer createStemmer() {
        PolishStemmer stemmer = new PolishStemmer();
        return word -> {
            List stems = stemmer.lookup(word);
            if (stems == null || stems.isEmpty()) {
                return null;
            }
            return ((WordData)stems.get(0)).getStem().toString();
        };
    }
}

