/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language.polish;

import java.util.List;
import morfologik.stemming.WordData;
import morfologik.stemming.polish.PolishStemmer;
import org.carrot2.language.ExtendedWhitespaceTokenizer;
import org.carrot2.language.SingleLanguageComponentsProviderImpl;
import org.carrot2.language.Stemmer;
import org.carrot2.language.Tokenizer;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.LabelFormatterImpl;

public class PolishLanguageComponents
extends SingleLanguageComponentsProviderImpl {
    public static final String NAME = "Polish";

    public PolishLanguageComponents() {
        super("Carrot2 (Polish via Morfologik project)", NAME);
        this.registerDefaultLexicalData();
        this.registerResourceless(Stemmer.class, this::createStemmer);
        this.registerResourceless(Tokenizer.class, ExtendedWhitespaceTokenizer::new);
        this.registerResourceless(LabelFormatter.class, () -> new LabelFormatterImpl(" "));
    }

    private Stemmer createStemmer() {
        PolishStemmer stemmer = new PolishStemmer();
        return word -> {
            List stems = stemmer.lookup(word);
            if (stems == null || stems.isEmpty()) {
                return null;
            }
            return ((WordData)stems.get(0)).getStem().toString();
        };
    }
}

