/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFinalStatesIterator;
import morfologik.fsa.FSAMatch;
import morfologik.fsa.FSAMatchType;
import morfologik.fsa.FSATraversalHelper;
import morfologik.stemming.ArrayViewList;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryIterator;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import morfologik.util.Arrays;
import morfologik.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DictionaryLookup
implements IStemmer,
Iterable<WordData> {
    private final FSATraversalHelper matcher;
    private final FSAFinalStatesIterator finalStatesIterator;
    private final int rootNode;
    private static final int EXPAND_SIZE = 10;
    private WordData[] forms = new WordData[0];
    private ArrayViewList<WordData> formsList = new ArrayViewList<WordData>(this.forms, 0, this.forms.length);
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final FSA fsa;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private CharBuffer charBuffer = CharBuffer.allocate(0);
    private final FSAMatch matchResult = new FSAMatch();
    private final Dictionary dictionary;

    public DictionaryLookup(Dictionary dictionary) throws IllegalArgumentException {
        this.dictionary = dictionary;
        this.dictionaryMetadata = dictionary.metadata;
        this.rootNode = dictionary.fsa.getRootNode();
        this.matcher = dictionary.fsa.getTraversalHelper();
        this.finalStatesIterator = this.matcher.getFinalStatesIterator();
        this.fsa = dictionary.fsa;
        if (this.rootNode == 0) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        try {
            Charset charset = Charset.forName(this.dictionaryMetadata.encoding);
            this.encoder = charset.newEncoder();
            this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.dictionaryMetadata.encoding);
        }
    }

    @Override
    public List<WordData> lookup(CharSequence charSequence) {
        int n;
        byte by = this.dictionaryMetadata.separator;
        this.charBuffer.clear();
        this.charBuffer = BufferUtils.ensureCapacity(this.charBuffer, charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            this.charBuffer.put(charSequence.charAt(i));
        }
        this.charBuffer.flip();
        this.byteBuffer = this.charsToBytes(this.charBuffer, this.byteBuffer);
        FSAMatch fSAMatch = this.matcher.matchSequence(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (fSAMatch.getMatchType() == FSAMatchType.PREMATURE_WORD_END_FOUND && (n = this.fsa.getArc(fSAMatch.getMismatchNode(), by)) != 0 && !this.fsa.isArcFinal(n)) {
            int n2 = 0;
            this.finalStatesIterator.restartFrom(this.fsa.getEndNode(n));
            while (this.finalStatesIterator.hasNext()) {
                int n3;
                ByteBuffer byteBuffer = this.finalStatesIterator.next();
                byte[] byArray = byteBuffer.array();
                int n4 = byteBuffer.remaining();
                if (n2 >= this.forms.length) {
                    this.forms = Arrays.copyOf(this.forms, this.forms.length + 10);
                    for (int i = 0; i < this.forms.length; ++i) {
                        if (this.forms[i] != null) continue;
                        this.forms[i] = new WordData(this.decoder);
                    }
                }
                WordData wordData = this.forms[n2++];
                wordData.reset();
                wordData.wordBuffer = this.byteBuffer;
                wordData.wordCharSequence = charSequence;
                for (n3 = 0; n3 < n4 && byArray[n3] != by; ++n3) {
                }
                wordData.stemBuffer.clear();
                wordData.stemBuffer = DictionaryLookup.decodeStem(wordData.stemBuffer, byArray, n3, this.byteBuffer, this.dictionaryMetadata);
                wordData.stemBuffer.flip();
                wordData.tagBuffer = BufferUtils.ensureCapacity(wordData.tagBuffer, n4 - ++n3);
                wordData.tagBuffer.clear();
                wordData.tagBuffer.put(byArray, n3, n4 - n3);
                wordData.tagBuffer.flip();
            }
            this.formsList.wrap((WordData[])this.forms, 0, n2);
            return this.formsList;
        }
        return Collections.emptyList();
    }

    public static ByteBuffer decodeStem(ByteBuffer byteBuffer, byte[] byArray, int n, ByteBuffer byteBuffer2, DictionaryMetadata dictionaryMetadata) {
        byteBuffer.clear();
        if (n == 0) {
            return byteBuffer;
        }
        byte[] byArray2 = byteBuffer2.array();
        int n2 = byteBuffer2.remaining();
        int n3 = byArray[0] - 65;
        boolean bl = dictionaryMetadata.usesPrefixes;
        boolean bl2 = dictionaryMetadata.usesInfixes;
        if (byteBuffer.capacity() < n2 + n) {
            byteBuffer = ByteBuffer.allocate(n2 + n);
        }
        if (n3 >= 0) {
            int n4;
            int n5;
            if (!bl && !bl2) {
                if (n3 <= n2) {
                    byteBuffer.put(byArray2, 0, n2 - n3);
                    byteBuffer.put(byArray, 1, n - 1);
                    return byteBuffer;
                }
            } else if (bl && !bl2) {
                int n6;
                if (n > 1 && (n6 = byArray[1] - 65 + n3) <= n2) {
                    byteBuffer.put(byArray2, n3, n2 - n6);
                    byteBuffer.put(byArray, 2, n - 2);
                    return byteBuffer;
                }
            } else if (bl2 && n > 2 && (n5 = byArray[2] - 65 + (n4 = byArray[1] - 65 + n3)) <= n2) {
                byteBuffer.put(byArray2, 0, n3);
                byteBuffer.put(byArray2, n4, n2 - n5);
                byteBuffer.put(byArray, 3, n - 3);
                return byteBuffer;
            }
        }
        byteBuffer.clear();
        byteBuffer.put(byArray, 0, n);
        return byteBuffer;
    }

    private ByteBuffer charsToBytes(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        byteBuffer.clear();
        int n = (int)((float)charBuffer.remaining() * this.encoder.maxBytesPerChar());
        if (byteBuffer.capacity() <= n) {
            byteBuffer = ByteBuffer.allocate(n);
        }
        charBuffer.mark();
        this.encoder.reset();
        this.encoder.encode(charBuffer, byteBuffer, true);
        byteBuffer.flip();
        charBuffer.reset();
        return byteBuffer;
    }

    @Override
    public Iterator<WordData> iterator() {
        return new DictionaryIterator(this.dictionary, this.decoder, true);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

