/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.IStemmer;
import morfologik.stemming.PolishStemmer;
import morfologik.stemming.WordData;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class PolishStemmingTool
extends Tool {
    private final IStemmer stemmer = new PolishStemmer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void go(CommandLine commandLine) throws Exception {
        String string = this.getEncodingOption(commandLine, SharedOptions.inputEncodingOption.getOpt());
        String string2 = this.getEncodingOption(commandLine, SharedOptions.outputEncodingOption.getOpt());
        System.out.println("Input encoding: " + string);
        System.out.println("Output encoding: " + string2);
        Reader reader = this.initializeInput(commandLine, string);
        Writer writer = this.initializeOutput(commandLine, string2);
        long l = System.currentTimeMillis();
        try {
            long l2 = this.process(reader, writer);
            writer.flush();
            long l3 = System.currentTimeMillis() - l;
            double d = (double)l3 / 1000.0;
            double d2 = d > 0.0 ? (double)l2 / d : Double.POSITIVE_INFINITY;
            System.out.println(new MessageFormat("Processed {0} words in {1,number,#.###} seconds ({2,number,#} words per second).", Locale.ENGLISH).format(new Object[]{new Long(l2), new Double((double)l3 / 1000.0), new Double(d2)}));
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected long process(Reader reader, Writer writer) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.wordChars(43, 43);
        long l = 0L;
        while ((n = streamTokenizer.nextToken()) != -1) {
            if (n != -3) continue;
            String string = streamTokenizer.sval;
            ++l;
            List<WordData> list = this.stemmer.lookup(string);
            if (list.size() == 0) {
                writer.write(string);
                writer.write("\t-\t-\n");
                continue;
            }
            for (WordData wordData : list) {
                writer.write(string);
                writer.write("\t");
                writer.write(this.asString(wordData.getStem()));
                writer.write("\t");
                writer.write(this.asString(wordData.getTag()));
                writer.write("\n");
            }
        }
        return l;
    }

    private String asString(CharSequence charSequence) {
        if (charSequence == null) {
            return "-";
        }
        return ((Object)charSequence).toString();
    }

    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.inputFileOption);
        options.addOption(SharedOptions.inputEncodingOption);
        options.addOption(SharedOptions.outputFileOption);
        options.addOption(SharedOptions.outputEncodingOption);
    }

    private Writer initializeOutput(CommandLine commandLine, String string) throws IOException, ParseException {
        String string2 = SharedOptions.outputFileOption.getOpt();
        OutputStreamWriter outputStreamWriter = commandLine.hasOption(string2) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream((File)commandLine.getParsedOptionValue(string2))), string) : new OutputStreamWriter((OutputStream)System.out, string);
        return outputStreamWriter;
    }

    private Reader initializeInput(CommandLine commandLine, String string) throws IOException, ParseException {
        String string2 = SharedOptions.inputFileOption.getOpt();
        InputStreamReader inputStreamReader = commandLine.hasOption(string2) ? new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream((File)commandLine.getParsedOptionValue(string2))), string) : new InputStreamReader(System.in, string);
        return inputStreamReader;
    }

    private String getEncodingOption(CommandLine commandLine, String string) {
        String string2 = System.getProperty("file.encoding", "iso-8859-1");
        if (commandLine.hasOption(string)) {
            string2 = commandLine.getOptionValue(string);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        PolishStemmingTool polishStemmingTool = new PolishStemmingTool();
        polishStemmingTool.go(stringArray);
    }
}

