/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

abstract class Tool {
    protected final Options options = new Options();

    Tool() {
    }

    protected final void go(String[] stringArray) {
        this.initializeOptions(this.options);
        if (stringArray.length == 0) {
            this.printUsage();
            return;
        }
        GnuParser gnuParser = new GnuParser();
        try {
            CommandLine commandLine = gnuParser.parse(this.options, stringArray);
            try {
                this.go(commandLine);
            }
            catch (Throwable throwable) {
                this.printError("Unhandled program error occurred.", throwable);
            }
        }
        catch (MissingArgumentException missingArgumentException) {
            this.printError("Provide the required argument for option: " + missingArgumentException.getMessage());
        }
        catch (MissingOptionException missingOptionException) {
            this.printError("Provide the required option: " + missingOptionException.getMessage());
        }
        catch (UnrecognizedOptionException unrecognizedOptionException) {
            this.printError(unrecognizedOptionException.getMessage());
        }
        catch (ParseException parseException) {
            this.printError("Could not parse command line: " + parseException.getMessage());
        }
    }

    protected void printError(String string, Throwable throwable) {
        this.printError(string);
        throwable.printStackTrace(System.err);
    }

    protected void printError(String string) {
        System.err.println();
        System.err.println(string);
    }

    protected void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(this.getClass().getName(), this.options, true);
    }

    protected abstract void go(CommandLine var1) throws Exception;

    protected abstract void initializeOptions(Options var1);
}

