/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CFSA
extends FSA {
    public static final byte VERSION = -59;
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public byte[] arcs;
    public final int nodeDataLength;
    private final Set<FSAFlags> flags;
    public final int gtl;
    public final byte[] labelMapping;

    public CFSA(InputStream inputStream) throws IOException {
        FSAHeader fSAHeader = FSAHeader.read(inputStream);
        if (fSAHeader.version != -59) {
            throw new IOException("This class can read FSA version 5 only: " + fSAHeader.version);
        }
        this.flags = EnumSet.of(FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
        if ((fSAHeader.gtl & 0xF0) != 0) {
            this.nodeDataLength = fSAHeader.gtl >>> 4 & 0xF;
            this.gtl = fSAHeader.gtl & 0xF;
            this.flags.add(FSAFlags.NUMBERS);
        } else {
            this.nodeDataLength = 0;
            this.gtl = fSAHeader.gtl & 0xF;
        }
        this.labelMapping = new byte[32];
        FileUtils.readFully(inputStream, this.labelMapping);
        this.arcs = FileUtils.readFully(inputStream);
    }

    @Override
    public int getRootNode() {
        return this.getEndNode(this.getFirstArc(this.skipArc(this.nodeDataLength)));
    }

    @Override
    public final int getFirstArc(int n) {
        return this.nodeDataLength + n;
    }

    @Override
    public final int getNextArc(int n) {
        if (this.isArcLast(n)) {
            return 0;
        }
        return this.skipArc(n);
    }

    @Override
    public int getArc(int n, byte by) {
        int n2 = this.getFirstArc(n);
        while (n2 != 0) {
            if (this.getArcLabel(n2) == by) {
                return n2;
            }
            n2 = this.getNextArc(n2);
        }
        return 0;
    }

    @Override
    public int getEndNode(int n) {
        int n2 = this.getDestinationNodeOffset(n);
        if (0 == n2) {
            throw new RuntimeException("This is a terminal arc [" + n + "]");
        }
        return n2;
    }

    @Override
    public byte getArcLabel(int n) {
        if (this.isNextSet(n) && this.isLabelCompressed(n)) {
            return this.labelMapping[this.arcs[n] >>> 3 & 0x1F];
        }
        return this.arcs[n + 1];
    }

    @Override
    public boolean isArcFinal(int n) {
        return (this.arcs[n] & 1) != 0;
    }

    @Override
    public boolean isArcTerminal(int n) {
        return 0 == this.getDestinationNodeOffset(n);
    }

    public boolean isArcLast(int n) {
        return (this.arcs[n] & 2) != 0;
    }

    public boolean isNextSet(int n) {
        return (this.arcs[n] & 4) != 0;
    }

    public boolean isLabelCompressed(int n) {
        assert (this.isNextSet(n)) : "Only applicable to arcs with NEXT bit.";
        return (this.arcs[n] & 0xFFFFFFF8) != 0;
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    protected final int getDestinationNodeOffset(int n) {
        if (this.isNextSet(n)) {
            return this.skipArc(n);
        }
        int n2 = 0;
        int n3 = this.gtl;
        while (--n3 >= 1) {
            n2 = n2 << 8 | this.arcs[n + 1 + n3] & 0xFF;
        }
        n2 = n2 << 8 | this.arcs[n] & 0xFF;
        return n2 >>> 3;
    }

    private int skipArc(int n) {
        n = this.isNextSet(n) ? (this.isLabelCompressed(n) ? ++n : (n += 2)) : (n += 1 + this.gtl);
        return n;
    }
}

