/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;

public final class CFSAEncoder {
    private final FSA5 fsa;
    private ArrayList<StreamElement> nodes = new ArrayList();
    private final byte[] compressedLabels = new byte[32];
    private final byte[] compressedLabelsIndex = new byte[256];

    CFSAEncoder(FSA fSA) {
        if (!(fSA instanceof FSA5)) {
            throw new IllegalArgumentException("FSA in version 5 expected.");
        }
        this.fsa = (FSA5)fSA;
        this.createNodeRepresentation();
    }

    private void createNodeRepresentation() {
        HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
        int n = 0;
        StreamElement streamElement = new Node(n);
        this.nodes.add(streamElement);
        hashMap.put(n, (Node)streamElement);
        streamElement = new Arc(n += this.fsa.nodeDataLength);
        this.nodes.add(streamElement);
        hashMap.put(n, (Node)streamElement);
        n += 1 + this.fsa.gtl;
        if (this.fsa.nodeDataLength > 0) {
            streamElement = new Node(n);
            this.nodes.add(streamElement);
            hashMap.put(n, (Node)streamElement);
            n += this.fsa.nodeDataLength;
        }
        while (n < this.fsa.arcs.length) {
            streamElement = new Arc(n);
            this.nodes.add(streamElement);
            hashMap.put(n, (Node)streamElement);
            byte by = this.fsa.arcs[n + 1];
            n = (by & 4) != 0 ? (n += 2) : (n += 1 + this.fsa.gtl);
            if ((by & 2) == 0) continue;
            if (n + this.fsa.nodeDataLength < this.fsa.arcs.length) {
                streamElement = new Node(n);
                this.nodes.add(streamElement);
                hashMap.put(n, (Node)streamElement);
            }
            n += this.fsa.nodeDataLength;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            streamElement = this.nodes.get(i);
            if (!(streamElement instanceof Arc)) continue;
            Arc arc = (Arc)streamElement;
            arc.target = (StreamElement)hashMap.get(this.fsa.getDestinationNodeOffset(arc.address));
            assert (arc.target != null) : "No target node for arc " + arc.address + " -> " + this.fsa.getDestinationNodeOffset(arc.address) + " " + i;
        }
        Arrays.fill(this.compressedLabelsIndex, (byte)-1);
        Arrays.fill(this.compressedLabels, (byte)0);
    }

    protected void doLabelMapping() {
        class IndexValue {
            int index;
            int value;

            public IndexValue(int n) {
                this.index = n;
            }
        }
        IndexValue[] indexValueArray = new IndexValue[256];
        for (int i = 0; i < indexValueArray.length; ++i) {
            indexValueArray[i] = new IndexValue(i);
        }
        for (StreamElement streamElement : this.nodes) {
            if (!(streamElement instanceof Arc)) continue;
            Arc arc = (Arc)streamElement;
            if (!arc.flagNext) continue;
            ++indexValueArray[arc.label & 0xFF].value;
        }
        Arrays.sort(indexValueArray, new Comparator<IndexValue>(){

            @Override
            public int compare(IndexValue indexValue, IndexValue indexValue2) {
                return indexValue2.value - indexValue.value;
            }
        });
        for (int i = 0; i < 31; ++i) {
            this.compressedLabelsIndex[indexValueArray[i].index] = (byte)(i + 1);
            this.compressedLabels[i + 1] = (byte)indexValueArray[i].index;
        }
    }

    protected int updateOffsets() {
        int n = 0;
        for (StreamElement streamElement : this.nodes) {
            streamElement.offset = n;
            n += streamElement.size();
        }
        return n;
    }

    protected void serialize(OutputStream outputStream) throws IOException {
        outputStream.write(new byte[]{92, 102, 115, 97});
        outputStream.write(-59);
        outputStream.write(this.fsa.filler);
        outputStream.write(this.fsa.annotation);
        outputStream.write(this.fsa.nodeDataLength << 4 | this.fsa.gtl);
        outputStream.write(this.compressedLabels);
        for (StreamElement streamElement : this.nodes) {
            streamElement.serialize(outputStream);
        }
    }

    public static void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        CFSAEncoder cFSAEncoder = new CFSAEncoder(new FSA5(inputStream));
        cFSAEncoder.doLabelMapping();
        cFSAEncoder.updateOffsets();
        cFSAEncoder.serialize(outputStream);
    }

    private class Arc
    extends StreamElement {
        public byte label;
        public boolean flagFinal;
        public boolean flagLast;
        public boolean flagNext;
        public StreamElement target;

        public Arc(int n) {
            super(n);
            this.flagFinal = CFSAEncoder.this.fsa.isArcFinal(n);
            this.flagLast = CFSAEncoder.this.fsa.isArcLast(n);
            this.flagNext = CFSAEncoder.this.fsa.isNextSet(n);
            this.label = CFSAEncoder.this.fsa.getArcLabel(n);
        }

        public void serialize(OutputStream outputStream) throws IOException {
            int n = (this.flagFinal ? 1 : 0) | (this.flagLast ? 2 : 0) | (this.flagNext ? 4 : 0);
            if (this.flagNext) {
                byte by = CFSAEncoder.this.compressedLabelsIndex[this.label & 0xFF];
                if (by >= 0) {
                    outputStream.write(by << 3 | n);
                } else {
                    outputStream.write(n);
                    outputStream.write(this.label);
                }
            } else {
                int n2 = this.target.offset << 3 | n;
                outputStream.write(n2 & 0xFF);
                outputStream.write(this.label);
                for (int i = 1; i < ((CFSAEncoder)CFSAEncoder.this).fsa.gtl; ++i) {
                    outputStream.write((n2 >>>= 8) & 0xFF);
                }
            }
        }

        public int size() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.serialize(byteArrayOutputStream);
                return byteArrayOutputStream.size();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private class Node
    extends StreamElement {
        public Node(int n) {
            super(n);
        }

        public void serialize(OutputStream outputStream) throws IOException {
            if (((CFSAEncoder)CFSAEncoder.this).fsa.nodeDataLength > 0) {
                outputStream.write(((CFSAEncoder)CFSAEncoder.this).fsa.arcs, this.address, ((CFSAEncoder)CFSAEncoder.this).fsa.nodeDataLength);
            }
        }

        public int size() {
            return ((CFSAEncoder)CFSAEncoder.this).fsa.nodeDataLength;
        }
    }

    private abstract class StreamElement {
        public final int address;
        public int offset;

        protected StreamElement(int n) {
            assert (n >= 0) : "Address must not be negative.";
            this.address = n;
        }

        public abstract void serialize(OutputStream var1) throws IOException;

        public abstract int size();
    }
}

