/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Set;
import morfologik.fsa.CFSA;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.fsa.FSATraversalHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FSA
implements Iterable<ByteBuffer> {
    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.getTraversalHelper().getAllSubsequences(this.getRootNode());
    }

    public FSATraversalHelper getTraversalHelper() {
        return new FSATraversalHelper(this);
    }

    public abstract int getRootNode();

    public abstract int getFirstArc(int var1);

    public abstract int getArc(int var1, byte var2);

    public abstract int getNextArc(int var1);

    public abstract int getEndNode(int var1);

    public abstract byte getArcLabel(int var1);

    public abstract boolean isArcFinal(int var1);

    public abstract boolean isArcTerminal(int var1);

    public abstract Set<FSAFlags> getFlags();

    public static FSA getInstance(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, Math.max(13, 1024));
        }
        inputStream.mark(12);
        FSAHeader fSAHeader = FSAHeader.read(inputStream);
        inputStream.reset();
        if (fSAHeader.version == 5) {
            return new FSA5(inputStream);
        }
        if (fSAHeader.version == -59) {
            return new CFSA(inputStream);
        }
        throw new IOException("Unsupported automaton version: " + fSAHeader.version);
    }
}

