/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAHeader;
import morfologik.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSA5
extends FSA {
    public static final byte VERSION = 5;
    public static final int BIT_FINAL_ARC = 1;
    public static final int BIT_LAST_ARC = 2;
    public static final int BIT_TARGET_NEXT = 4;
    public static final int ADDRESS_OFFSET = 1;
    public final byte[] arcs;
    public final int nodeDataLength;
    private final Set<FSAFlags> flags;
    public final int gtl;
    public final byte filler;
    public final byte annotation;

    public FSA5(InputStream inputStream) throws IOException {
        FSAHeader fSAHeader = FSAHeader.read(inputStream);
        if (fSAHeader.version != 5) {
            throw new IOException("This class can read FSA version 5 only: " + fSAHeader.version);
        }
        this.flags = EnumSet.of(FSAFlags.FLEXIBLE, FSAFlags.STOPBIT, FSAFlags.NEXTBIT);
        if ((fSAHeader.gtl & 0xF0) != 0) {
            this.nodeDataLength = fSAHeader.gtl >>> 4 & 0xF;
            this.gtl = fSAHeader.gtl & 0xF;
            this.flags.add(FSAFlags.NUMBERS);
        } else {
            this.nodeDataLength = 0;
            this.gtl = fSAHeader.gtl & 0xF;
        }
        this.filler = fSAHeader.filler;
        this.annotation = fSAHeader.annotation;
        this.arcs = FileUtils.readFully(inputStream);
    }

    private int skipArc(int n) {
        return n + (this.isNextSet(n) ? 2 : 1 + this.gtl);
    }

    @Override
    public int getRootNode() {
        return this.getEndNode(this.getFirstArc(this.skipArc(this.nodeDataLength)));
    }

    @Override
    public final int getFirstArc(int n) {
        return this.nodeDataLength + n;
    }

    @Override
    public final int getNextArc(int n) {
        if (this.isArcLast(n)) {
            return 0;
        }
        return this.skipArc(n);
    }

    @Override
    public int getArc(int n, byte by) {
        int n2 = this.getFirstArc(n);
        while (n2 != 0) {
            if (this.getArcLabel(n2) == by) {
                return n2;
            }
            n2 = this.getNextArc(n2);
        }
        return 0;
    }

    @Override
    public int getEndNode(int n) {
        int n2 = this.getDestinationNodeOffset(n);
        if (0 == n2) {
            throw new RuntimeException("This is a terminal arc [" + n + "]");
        }
        return n2;
    }

    @Override
    public byte getArcLabel(int n) {
        return this.arcs[n];
    }

    @Override
    public boolean isArcFinal(int n) {
        return (this.arcs[n + 1] & 1) != 0;
    }

    @Override
    public boolean isArcTerminal(int n) {
        return 0 == this.getDestinationNodeOffset(n);
    }

    @Override
    public Set<FSAFlags> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public boolean isArcLast(int n) {
        return (this.arcs[n + 1] & 2) != 0;
    }

    public boolean isNextSet(int n) {
        return (this.arcs[n + 1] & 4) != 0;
    }

    static final int decodeFromBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            n3 = n3 << 8 | byArray[n + n4] & 0xFF;
        }
        return n3;
    }

    protected final int getDestinationNodeOffset(int n) {
        if (this.isNextSet(n)) {
            return this.skipArc(n);
        }
        return FSA5.decodeFromBytes(this.arcs, n + 1, this.gtl) >>> 3;
    }
}

