/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import morfologik.fsa.FSA;
import morfologik.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSAFinalStatesIterator
implements Iterator<ByteBuffer> {
    private static final int EXPECTED_MAX_STATES = 15;
    private final FSA fsa;
    private ByteBuffer nextElement;
    private byte[] buffer = new byte[15];
    private ByteBuffer bufferWrapper = ByteBuffer.wrap(this.buffer);
    private int[] arcs = new int[15];
    private int position;

    FSAFinalStatesIterator(FSA fSA, int n) {
        this.fsa = fSA;
        if (fSA.getFirstArc(n) != 0) {
            this.restartFrom(n);
        }
    }

    public void restartFrom(int n) {
        this.position = 0;
        this.bufferWrapper.clear();
        this.nextElement = null;
        this.pushNode(n);
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement == null) {
            this.nextElement = this.advance();
        }
        return this.nextElement != null;
    }

    @Override
    public ByteBuffer next() {
        if (this.nextElement != null) {
            ByteBuffer byteBuffer = this.nextElement;
            this.nextElement = null;
            return byteBuffer;
        }
        ByteBuffer byteBuffer = this.advance();
        if (byteBuffer == null) {
            throw new NoSuchElementException();
        }
        return byteBuffer;
    }

    private final ByteBuffer advance() {
        if (this.position == 0) {
            return null;
        }
        while (this.position > 0) {
            int n = this.position - 1;
            int n2 = this.arcs[n];
            if (n2 == 0) {
                --this.position;
                continue;
            }
            this.arcs[n] = this.fsa.getNextArc(n2);
            int n3 = this.buffer.length;
            if (n >= n3) {
                this.buffer = Arrays.copyOf(this.buffer, n3 + 15);
                this.bufferWrapper = ByteBuffer.wrap(this.buffer);
            }
            this.buffer[n] = this.fsa.getArcLabel(n2);
            if (!this.fsa.isArcTerminal(n2)) {
                this.pushNode(this.fsa.getEndNode(n2));
            }
            if (!this.fsa.isArcFinal(n2)) continue;
            this.bufferWrapper.clear();
            this.bufferWrapper.limit(n + 1);
            return this.bufferWrapper;
        }
        return null;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }

    private void pushNode(int n) {
        if (this.position == this.arcs.length) {
            this.arcs = Arrays.copyOf(this.arcs, this.arcs.length + 15);
        }
        this.arcs[this.position] = this.fsa.getFirstArc(n);
        ++this.position;
    }
}

